/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.apip.config;

import com.icbc.apip.config.ConfigPramName;
import com.icbc.apip.config.SdkUtil;
import com.icbc.apip.exception.ConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

@Deprecated
public class SdkConfig {
    private Properties properties = new Properties();
    private static SdkConfig instance;
    private static final String PROPERTIES_FILE_NAME = "sdk-config.properties";

    private SdkConfig() throws ConfigException {
        this.loadEnv(SdkUtil.getSdkConfigFolderPath().concat(PROPERTIES_FILE_NAME));
    }

    private void updateFilePath() throws ConfigException {
        String privateLocSettingPath = ConfigPramName.USER_PRIKEY_LOC.getString();
        String privateLoc = SdkUtil.getSdkConfigFolderPath().concat(privateLocSettingPath);
        this.properties.setProperty(ConfigPramName.USER_PRIKEY_LOC.asString(), privateLoc);
        String publicLocSettingPath = ConfigPramName.SYS_PUBKEY_LOC.getString();
        String publicLoc = SdkUtil.getSdkConfigFolderPath().concat(publicLocSettingPath);
        this.properties.setProperty(ConfigPramName.SYS_PUBKEY_LOC.asString(), publicLoc);
    }

    public static synchronized SdkConfig getInstance() throws ConfigException {
        if (instance == null) {
            instance = new SdkConfig();
            instance.updateFilePath();
        }
        return instance;
    }

    public void loadEnv(String fileFullPath) throws ConfigException {
        File file = new File(fileFullPath);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            if (in != null) {
                this.properties.load(in);
                ((InputStream)in).close();
            }
        }
        catch (Exception e) {
            throw new ConfigException("\u65e0\u6cd5\u627e\u5230\u914d\u7f6e\u6587\u4ef6\uff1a" + fileFullPath);
        }
    }

    public void reLoadProp(String name, String value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getStringProperty(String key) throws ConfigException {
        String str = (String)this.properties.get(key);
        if (str == null) {
            throw new ConfigException("\u53c2\u6570[" + key + "]\u672a\u914d\u7f6e");
        }
        return str;
    }

    public int getIntegerProperty(String key) throws ConfigException {
        int i;
        String str = (String)this.properties.get(key);
        if (str == null) {
            throw new ConfigException("\u53c2\u6570[" + key + "]\u672a\u914d\u7f6e");
        }
        try {
            i = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new ConfigException("\u53c2\u6570[" + key + "]\u6570\u5b57\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        return i;
    }

    public long getLongProperty(String key) throws ConfigException {
        long i;
        String str = (String)this.properties.get(key);
        if (str == null) {
            throw new ConfigException("\u53c2\u6570[" + key + "]\u672a\u914d\u7f6e");
        }
        try {
            i = Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new ConfigException("\u53c2\u6570[" + key + "]\u6570\u5b57\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        return i;
    }

    public boolean getBooleanProperty(String key) throws ConfigException {
        String str = (String)this.properties.get(key);
        if (str == null) {
            throw new ConfigException("\u53c2\u6570[" + key + "]\u672a\u914d\u7f6e");
        }
        return Boolean.valueOf(str);
    }
}

