/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.apip.invoker;

import com.icbc.api.IcbcApiException;
import com.icbc.api.crypt.RSA;
import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HttpEntity;
import com.icbc.api.internal.apache.http.client.ClientProtocolException;
import com.icbc.api.internal.util.codec.Base64;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.utils.IcbcHashMap;
import com.icbc.api.utils.WebUtils;
import com.icbc.apip.context.ApiContext;
import com.icbc.apip.exception.ConfigException;
import com.icbc.apip.exception.InvokerException;
import com.icbc.apip.invoker.Invoker;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class AbstractInvoker
implements Invoker {
    private static final Log logger = LogFactory.getLog(AbstractInvoker.class);
    protected String uri;
    private String reqEncoding;
    private String respEncoding;
    private String userAppId;
    private String version;
    private ApiContext apiContext;
    protected Invoker.HttpMethodType type;
    protected Map<String, String> parameters = new IcbcHashMap();
    private static final String HEADER_NAME_CONTEXT_TYPE = "Content-Type";
    private static Pattern PATTERN = Pattern.compile("text/html;charset=(.+)");

    @Override
    public ApiContext getApiContext() {
        return this.apiContext;
    }

    @Override
    public void setApiContext(ApiContext apiContext) {
        this.apiContext = apiContext;
    }

    protected String getServiceUrl() {
        String apiUrl = this.getApiContext().getConfigure().getSysBaseUri();
        if (apiUrl.endsWith("/")) {
            apiUrl = apiUrl.substring(0, apiUrl.length());
        }
        if (!apiUrl.endsWith("/api")) {
            apiUrl = apiUrl.concat("/api");
        }
        return apiUrl.concat(this.uri);
    }

    protected String invoke() throws Exception {
        String respStr;
        String serviceUrl = this.getServiceUrl();
        IcbcHashMap params = new IcbcHashMap();
        params.put("app_id", this.getApiContext().getConfigure().getAppId());
        params.put("sign_type", "RSA");
        params.put("charset", "UTF-8");
        params.put("format", "json");
        params.putAll(this.parameters);
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        params.put("timestamp", df.format(new Date(timestamp)));
        String strToSign = WebUtils.buildOrderedSignStr(new URL(serviceUrl).getPath(), params);
        String signedStr = RSA.sign(Base64.encodeBase64(strToSign.getBytes("UTF-8")), this.getApiContext().getConfigure().getPrimaryKeyBytes(), "SHA1WithRSA");
        params.put("sign", signedStr);
        if (Invoker.HttpMethodType.GET == this.type) {
            respStr = WebUtils.doGet(serviceUrl, params, "UTF-8");
        } else if (Invoker.HttpMethodType.POST == this.type) {
            respStr = WebUtils.doPost(serviceUrl, params, "UTF-8");
        } else {
            logger.debug((Object)("can not support this http method:" + (Object)((Object)this.type)));
            throw new InvokerException("http method type error!");
        }
        return this.parseJsonWithVerifyIcbcSign(respStr);
    }

    private String parseJsonWithVerifyIcbcSign(String respStr) throws Exception {
        int indexOfRootStart = respStr.indexOf("response_biz_content") + "response_biz_content".length() + 2;
        int indexOfRootEnd = respStr.lastIndexOf(",");
        int indexOfSignStart = respStr.lastIndexOf("sign") + "sign".length() + 3;
        int indexOfSignEnd = respStr.lastIndexOf("\"");
        String respBizContentStr = respStr.substring(indexOfRootStart, indexOfRootEnd);
        String sign = respStr.substring(indexOfSignStart, indexOfSignEnd);
        boolean passed = RSA.verify(Base64.encodeBase64(respBizContentStr.getBytes("UTF-8")), this.apiContext.getApigwPublicKeyBytes(), sign, "SHA1WithRSA");
        if (!passed) {
            throw new IcbcApiException("icbc sign verify not passed.");
        }
        return respBizContentStr;
    }

    public String getJsonStr() {
        return JSON.toJSONString(this.parameters);
    }

    @Override
    public Object syncInvokeObject() throws InvokerException, ConfigException, ClientProtocolException, UnsupportedEncodingException, IOException {
        logger.debug((Object)"start sync invoke object.");
        String respStr = null;
        try {
            respStr = this.invoke();
        }
        catch (Exception e) {
            logger.error((Object)"invoke exception.", (Throwable)e);
            throw new InvokerException("invoke exception.", e);
        }
        try {
            return JSON.parse(respStr);
        }
        catch (RuntimeException re) {
            logger.error((Object)"response string can not transform to json object.");
            throw new InvokerException("response can not transform to object!, response string is: " + respStr, re);
        }
    }

    @Override
    public Map<String, Object> syncInvoke() throws ConfigException, InvokerException, ClientProtocolException, UnsupportedEncodingException, IOException {
        Map result;
        logger.debug((Object)"start sync invoke");
        Object obj = this.syncInvokeObject();
        try {
            result = (Map)obj;
        }
        catch (RuntimeException re) {
            logger.error((Object)"response string can not transform to map.");
            throw new InvokerException("response can not transform to map!, response string is: " + JSON.toJSONString(obj), re);
        }
        logger.debug((Object)("invoke finished, result is " + result));
        return result;
    }

    @Override
    public Invoker setUri(String uri) {
        logger.debug((Object)("set uri to " + uri));
        this.uri = uri;
        return this;
    }

    @Override
    public Invoker setUserAppId(String appId) {
        this.userAppId = appId;
        return this;
    }

    @Override
    public String getUserAppId() throws ConfigException {
        return this.userAppId == null ? this.getApiContext().getConfigure().getAppId() : this.userAppId;
    }

    @Override
    public Invoker setVersion(String version) {
        this.version = version;
        return this;
    }

    @Override
    public String getVersion() throws ConfigException {
        return this.version == null ? this.getApiContext().getConfigure().getVersion() : this.version;
    }

    @Override
    public Invoker setSendEncoding(String encoding) {
        logger.debug((Object)("set send encoding to " + encoding));
        this.reqEncoding = encoding;
        return this;
    }

    @Override
    public Invoker setReceiveEncoding(String encoding) {
        logger.debug((Object)("set reseive encoding to " + encoding));
        this.respEncoding = encoding;
        return this;
    }

    @Override
    public String getRequestEncoding() throws ConfigException {
        if (this.reqEncoding != null) {
            logger.debug((Object)("get request encoding is " + this.reqEncoding));
            return this.reqEncoding;
        }
        String defailtCharset = this.getApiContext().getConfigure().getSysDefaultCharset();
        logger.debug((Object)("get request encoding is " + defailtCharset));
        return defailtCharset;
    }

    @Override
    public String getResponseEncoding(HttpEntity httpEntity) throws ConfigException {
        if (this.respEncoding != null) {
            logger.debug((Object)("get response encoding is " + this.respEncoding));
            return this.respEncoding;
        }
        Header contentTypeHeader = httpEntity.getContentType();
        if (contentTypeHeader != null) {
            Matcher matcher;
            String name = contentTypeHeader.getName();
            String value = contentTypeHeader.getValue().replace(" ", "");
            if (name.equalsIgnoreCase(HEADER_NAME_CONTEXT_TYPE) && (matcher = PATTERN.matcher(value)).find()) {
                String encoding = matcher.group(1);
                logger.debug((Object)("get response encoding is " + encoding));
                return encoding;
            }
        }
        String defailtCharset = this.getApiContext().getConfigure().getSysDefaultCharset();
        logger.debug((Object)("get response encoding is " + defailtCharset));
        return defailtCharset;
    }
}

