/*
 * Decompiled with CFR 0.152.
 */
package com.indigosoftware.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.indigosoftware.client.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class IndigoServiceClient {
    public static int socketTimeout = 100000;
    public static int connectTimeout = 10000;
    public static boolean jugeJson = true;
    private static ThreadLocal<String> currentRoot = new ThreadLocal();

    public static void setXmlRootNodeForJson(String name) {
        currentRoot.set(name);
    }

    private static String getXmlRootNode() {
        String name = currentRoot.get();
        currentRoot.set(null);
        return name;
    }

    public static InputStream submitJob(String url, String instanceName, String base64ContentOrJsonString, Map<String, Object> attactments, String key) throws Exception {
        if (jugeJson && JsonUtils.isJson(base64ContentOrJsonString)) {
            base64ContentOrJsonString = JsonUtils.toXmlBase64(IndigoServiceClient.getXmlRootNode(), "UTF-8", base64ContentOrJsonString);
        }
        int num = (int)(Math.random() * 9.99999999E8);
        JSONObject jsonParam = IndigoServiceClient.createJsonObj(String.valueOf(num), instanceName, base64ContentOrJsonString, attactments, key, false);
        return IndigoServiceClient.service(url, jsonParam);
    }

    public static InputStream submitJob(String url, String instanceName, String base64ContentOrJsonString) throws Exception {
        return IndigoServiceClient.submitJob(url, instanceName, base64ContentOrJsonString, null, null);
    }

    public static void submitJob(String url, String instanceName, String base64ContentOrJsonString, Map<String, Object> attactments, String key, String outDir) throws Exception {
        InputStream is = IndigoServiceClient.submitJob(url, instanceName, base64ContentOrJsonString, attactments, key);
        IndigoServiceClient.zipInputStreamToFile(is, outDir);
    }

    public static void submitJob(String url, String instanceName, String base64ContentOrJsonString, String outDir) throws Exception {
        IndigoServiceClient.submitJob(url, instanceName, base64ContentOrJsonString, null, null, outDir);
    }

    public static InputStream submitJobWithMutiAttactmentsAsOne(String url, String instanceName, String base64ContentOrJsonString, Map<String, Object> attactments, String key) throws Exception {
        if (jugeJson && JsonUtils.isJson(base64ContentOrJsonString)) {
            base64ContentOrJsonString = JsonUtils.toXmlBase64(IndigoServiceClient.getXmlRootNode(), "UTF-8", base64ContentOrJsonString);
        }
        int num = (int)(Math.random() * 9.99999999E8);
        JSONObject jsonParam = IndigoServiceClient.createJsonObj(String.valueOf(num), instanceName, base64ContentOrJsonString, attactments, key, true);
        return IndigoServiceClient.service(url, jsonParam);
    }

    public static void submitJobWithMutiAttactmentsAsOne(String url, String instanceName, String base64ContentOrJsonString, Map<String, Object> attactments, String key, String outDir) throws Exception {
        InputStream is = IndigoServiceClient.submitJobWithMutiAttactmentsAsOne(url, instanceName, base64ContentOrJsonString, attactments, key);
        IndigoServiceClient.zipInputStreamToFile(is, outDir);
    }

    public static String submitJobForString(String url, String dataID, String instanceName, Object base64ContentOrJsonStringOrFile) throws Exception {
        return IndigoServiceClient.submitJobForString(url, dataID, instanceName, base64ContentOrJsonStringOrFile, null, null);
    }

    public static String submitJobForString(String url, String dataID, String instanceName, Object base64ContentOrJsonStringOrFile, Map<String, Object> attactments, String key) throws Exception {
        JSONObject jsonParam = IndigoServiceClient.createJsonObj(dataID, instanceName, base64ContentOrJsonStringOrFile, attactments, key, false);
        jsonParam.put("returnType", (Object)"String");
        return IndigoServiceClient.postForString(url, jsonParam);
    }

    public static String submitJobForStringWithAttachmentsAsOne(String url, String dataID, String instanceName, Object base64ContentOrJsonStringOrFile, Map<String, Object> attactments, String key) throws Exception {
        JSONObject jsonParam = IndigoServiceClient.createJsonObj(dataID, instanceName, base64ContentOrJsonStringOrFile, attactments, key, true);
        jsonParam.put("returnType", (Object)"String");
        return IndigoServiceClient.postForString(url, jsonParam);
    }

    private static InputStream service(String url, JSONObject obj) throws Exception {
        CloseableHttpClient httpclient = null;
        CloseableHttpResponse response = null;
        try {
            HttpEntity responseEntity;
            httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Accept", "application/json");
            RequestConfig config = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectTimeout).build();
            httpPost.setConfig(config);
            StringEntity entity = new StringEntity(obj.toString(), "UTF-8");
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            response = httpclient.execute((HttpUriRequest)httpPost);
            int returnStatus = response.getStatusLine().getStatusCode();
            InputStream is = null;
            if (returnStatus == 500) {
                String resData = EntityUtils.toString((HttpEntity)response.getEntity());
                JSONObject jsonObj = JSON.parseObject((String)resData);
                throw new Exception("\"errorCode\":\"" + jsonObj.get((Object)"errorCode") + "\",\"detail\":\"" + jsonObj.get((Object)"detail") + "\"");
            }
            if (returnStatus == 200 && (responseEntity = response.getEntity()) != null) {
                is = responseEntity.getContent();
            }
            InputStream inputStream = IndigoServiceClient.copyInputStream(is);
            return inputStream;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpclient != null) {
                httpclient.close();
            }
        }
    }

    private static InputStream copyInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        if (is != null) {
            int len;
            while ((len = is.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private static String postForString(String url, JSONObject obj) throws Exception {
        CloseableHttpClient httpclient = null;
        CloseableHttpResponse response = null;
        try {
            httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Accept", "application/json");
            RequestConfig config = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectTimeout).build();
            httpPost.setConfig(config);
            StringEntity entity = new StringEntity(obj.toString(), "UTF-8");
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            response = httpclient.execute((HttpUriRequest)httpPost);
            int returnStatus = response.getStatusLine().getStatusCode();
            String resData = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            if (returnStatus == 500) {
                JSONObject jsonObj = JSON.parseObject((String)resData);
                throw new Exception("\"errorCode\":\"" + jsonObj.get((Object)"errorCode") + "\",\"detail\":\"" + jsonObj.get((Object)"detail") + "\"");
            }
            if (returnStatus == 200) {
                String string = resData;
                return string;
            }
            return null;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpclient != null) {
                httpclient.close();
            }
        }
    }

    public static void setSocketTimeout(int socketTimeout) throws Exception {
        IndigoServiceClient.socketTimeout = socketTimeout;
    }

    public static void setConnectTimeout(int connectTimeout) throws Exception {
        IndigoServiceClient.connectTimeout = connectTimeout;
    }

    public static String zipInputStreamToFile(InputStream is, String outDir) throws Exception {
        ZipInputStream zis = null;
        String result = "";
        try {
            zis = new ZipInputStream(is);
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                File outFile = new File(String.valueOf(outDir) + File.separator + entry.getName());
                if (!outFile.getParentFile().exists()) {
                    outFile.getParentFile().mkdir();
                }
                if (!outFile.exists()) {
                    outFile.createNewFile();
                }
                if (!entry.isDirectory()) {
                    FileOutputStream fos = new FileOutputStream(outFile);
                    byte[] buffer = new byte[1024];
                    int i = 0;
                    while ((i = zis.read(buffer)) != -1) {
                        fos.write(buffer, 0, i);
                    }
                    fos.close();
                }
                result = outFile.getAbsolutePath();
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    is = null;
                }
            }
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException ex) {
                    zis = null;
                }
            }
        }
        return result;
    }

    private static JSONObject createJsonObj(String dataID, String instanceName, Object base64ContentOrJsonStringOrFile, Map<String, Object> attactments, String key, boolean mutiAsOne) throws Exception {
        String fileBase64 = "";
        if (base64ContentOrJsonStringOrFile instanceof String) {
            fileBase64 = jugeJson && JsonUtils.isJson((String)base64ContentOrJsonStringOrFile) ? JsonUtils.toXmlBase64(IndigoServiceClient.getXmlRootNode(), "UTF-8", (String)base64ContentOrJsonStringOrFile) : (String)base64ContentOrJsonStringOrFile;
        } else if (base64ContentOrJsonStringOrFile instanceof File) {
            byte[] bb = FileUtils.readFileToByteArray((File)((File)base64ContentOrJsonStringOrFile));
            String ss = new String(bb, "UTF-8");
            fileBase64 = jugeJson && JsonUtils.isJson(ss) ? JsonUtils.toXmlBase64(IndigoServiceClient.getXmlRootNode(), "UTF-8", ss) : Base64.encodeBase64String((byte[])bb);
        } else {
            throw new Exception("data is not String or File");
        }
        JSONObject jsonParam = new JSONObject();
        jsonParam.put("dataID", (Object)dataID);
        jsonParam.put("instanceName", (Object)instanceName);
        jsonParam.put("content", (Object)fileBase64);
        JSONObject attaObj = new JSONObject();
        if (attactments != null && !attactments.isEmpty()) {
            String attaBase64 = "";
            if (mutiAsOne) {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                ZipOutputStream out = new ZipOutputStream(bs);
                for (String attaKey : attactments.keySet()) {
                    Object att = attactments.get(attaKey);
                    out.putNextEntry(new ZipEntry(attaKey));
                    if (att instanceof String) {
                        out.write(Base64.decodeBase64((String)((String)att)));
                        continue;
                    }
                    if (att instanceof File) {
                        out.write(FileUtils.readFileToByteArray((File)((File)att)));
                        continue;
                    }
                    throw new Exception("attactments[" + attaKey + "] is not String or File");
                }
                out.flush();
                out.close();
                attaBase64 = Base64.encodeBase64String((byte[])bs.toByteArray());
                attaObj.put("zip.pdf", (Object)attaBase64);
            } else {
                for (String attaKey : attactments.keySet()) {
                    Object att = attactments.get(attaKey);
                    if (att instanceof String) {
                        attaBase64 = (String)att;
                    } else if (att instanceof File) {
                        attaBase64 = Base64.encodeBase64String((byte[])FileUtils.readFileToByteArray((File)((File)att)));
                    } else {
                        throw new Exception("attactments[" + attaKey + "] is not String or File");
                    }
                    attaObj.put(attaKey, (Object)attaBase64);
                }
            }
            jsonParam.put("attachment", (Object)attaObj);
        }
        if (key != null) {
            String fileOriginal = fileBase64;
            ArrayList keyList = new ArrayList(attaObj.keySet());
            Collections.sort(keyList);
            for (String fileName : keyList) {
                fileOriginal = String.valueOf(fileOriginal) + attaObj.getString(fileName);
            }
            String originalText = "content=" + fileOriginal + "&dataID=" + dataID + "&instanceName=" + instanceName + "&key=" + key;
            String digest = DigestUtils.md5Hex((String)originalText);
            jsonParam.put("digest", (Object)digest);
        }
        return jsonParam;
    }
}

