/*
 * Decompiled with CFR 0.152.
 */
package com.indigosoftware.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class JsonUtils {
    public static final String UTF8 = "UTF-8";

    public static boolean isJson(String content) {
        char c;
        int len = content.length();
        if (len > 20) {
            len = 20;
        }
        boolean isBegin = false;
        int i = 0;
        while (i < len) {
            c = content.charAt(i);
            if (c != ' ' && c != '\r' && c != '\n' && c != '\t') {
                if (c == '{') {
                    isBegin = true;
                    break;
                }
                return false;
            }
            ++i;
        }
        if (!isBegin) {
            return false;
        }
        len = content.length() - 20;
        if (len <= i) {
            len = i;
        }
        i = content.length() - 1;
        while (i > len) {
            c = content.charAt(i);
            if (c != ' ') {
                return c == '}';
            }
            --i;
        }
        return false;
    }

    public static String toXmlBase64(String rootName, String xmlChartSet, String jsonData) throws UnsupportedEncodingException {
        String s = JsonUtils.toXml(rootName, xmlChartSet, jsonData.getBytes(UTF8));
        return Base64.encodeBase64String((byte[])s.getBytes(UTF8));
    }

    public static String toXml(String rootName, String xmlChartSet, byte[] utf8JsonData) throws UnsupportedEncodingException {
        Object obj = JSON.parse((byte[])utf8JsonData, (Feature[])new Feature[0]);
        StringBuilder buf = new StringBuilder();
        if (rootName == null || rootName.isEmpty()) {
            if (obj instanceof Map) {
                Map m = (Map)obj;
                if (m.size() == 1) {
                    Map.Entry ent = m.entrySet().iterator().next();
                    obj = ent.getValue();
                    rootName = (String)ent.getKey();
                }
            } else {
                rootName = "ROOT";
            }
        }
        boolean chr = false;
        if (obj instanceof List || obj instanceof Map) {
            chr = true;
        }
        buf.append("<?xml version=\"1.0\" encoding=\"").append(xmlChartSet).append("\"?>\n");
        buf.append("<").append(rootName).append(">");
        if (chr) {
            buf.append("\n");
        }
        JsonUtils.objToXml(buf, xmlChartSet, null, obj);
        buf.append("</").append(rootName).append(">");
        return buf.toString();
    }

    private static void objToXml(StringBuilder buf, String xmlChartSet, String key, Object obj) throws UnsupportedEncodingException {
        if (obj instanceof String) {
            JsonUtils.stringToXml(buf, xmlChartSet, (String)obj);
        } else if (obj instanceof Map) {
            JsonUtils.mapToXml(buf, xmlChartSet, key, (Map)obj);
        } else if (obj instanceof List) {
            JsonUtils.listToXml(buf, xmlChartSet, key, (List)obj);
        } else {
            buf.append(obj.toString());
        }
    }

    private static void stringToXml(StringBuilder buf, String xmlChartSet, String str) throws UnsupportedEncodingException {
        if (!UTF8.equalsIgnoreCase(xmlChartSet)) {
            str = new String(str.getBytes(xmlChartSet), xmlChartSet);
        }
        int i = 0;
        int len = str.length();
        while (i < len) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
    }

    private static void listToXml(StringBuilder buf, String xmlChartSet, String key, List<Object> list) throws UnsupportedEncodingException {
        if (key == null) {
            if (!list.isEmpty()) {
                buf.append("\n");
            }
            JsonUtils.listToXml(buf, xmlChartSet, "item", list);
        } else {
            for (Object obj : list) {
                if (obj instanceof List) {
                    buf.append("<").append(key).append(">");
                    JsonUtils.listToXml(buf, xmlChartSet, null, (List)obj);
                    buf.append("</").append(key).append(">\n");
                    continue;
                }
                buf.append("<").append(key).append(">");
                JsonUtils.objToXml(buf, xmlChartSet, key, obj);
                buf.append("</").append(key).append(">\n");
            }
        }
    }

    private static void mapToXml(StringBuilder buf, String xmlChartSet, String key, Map<String, Object> map) throws UnsupportedEncodingException {
        if (key != null) {
            buf.append("\n");
        }
        for (Map.Entry<String, Object> ent : map.entrySet()) {
            if (ent.getValue() instanceof List) {
                JsonUtils.listToXml(buf, xmlChartSet, ent.getKey(), (List)ent.getValue());
                continue;
            }
            buf.append("<").append(ent.getKey()).append(">");
            JsonUtils.objToXml(buf, xmlChartSet, ent.getKey(), ent.getValue());
            buf.append("</").append(ent.getKey()).append(">\n");
        }
    }
}

