/*
 * Decompiled with CFR 0.152.
 */
package com.indigopacific.idg;

import com.indigopacific.idg.IDGClientException;
import com.indigopacific.idg.IDGResult;
import com.indigopacific.idg.IDGResultImpl;
import com.indigopacific.idg.IDGServerServiceLocator;
import com.indigopacific.idg.IDGServerSoapBindingStub;
import com.indigopacific.idg.IDGWSBuilder;
import com.indigopacific.idg.IIDGClient;
import com.indigopacific.idg.IIDGResult;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.OctetStream;
import org.apache.axis.attachments.OctetStreamDataSource;
import org.dom4j.Document;

public class IDGClientImpl
implements IIDGClient {
    private IDGServerServiceLocator server = new IDGServerServiceLocator();
    private IDGServerSoapBindingStub client = null;
    private String serverIP = "127.0.0.1";
    private String port = "8080";
    private int timeout = 43200000;
    private String cVersion = "0.0.1";
    private String sVersion = "3.0.5";
    private Document doc;
    static byte[] lock = new byte[0];

    public IDGClientImpl(String IP, String port) throws IDGClientException {
        int i = 0;
        boolean flag = false;
        while (i < 50 && !flag) {
            try {
                this.server = new IDGServerServiceLocator();
                flag = true;
            }
            catch (NullPointerException e) {
                try {
                    flag = false;
                    ++i;
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    throw new IDGClientException(e1.getMessage());
                }
            }
        }
        if (!flag) {
            throw new IDGClientException("init client failed...");
        }
        this.serverIP = IP;
        this.port = port;
        try {
            URL url = new URL("http://" + IP + ":" + port);
            this.client = (IDGServerSoapBindingStub)this.server.getIDGServer(url);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setServerIP(String IP, String port) {
        this.serverIP = IP;
        this.port = port;
        try {
            URL url = new URL(String.valueOf(IP) + ":" + port);
            this.client = (IDGServerSoapBindingStub)this.server.getIDGServer(url);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] zipData(byte[] bytes) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);
        BufferedOutputStream buf = new BufferedOutputStream(bos);
        ZipOutputStream zos = new ZipOutputStream(buf);
        ZipEntry e = new ZipEntry("zip");
        byte[] compressed = null;
        e.setMethod(8);
        e.setSize(bytes.length);
        zos.putNextEntry(e);
        zos.write(bytes, 0, bytes.length);
        zos.flush();
        buf.flush();
        bos.flush();
        zos.close();
        compressed = bos.toByteArray();
        buf.close();
        bos.close();
        return compressed;
    }

    public byte[] zipData(InputStream is) throws IOException {
        byte[] bytes = new byte[is.available()];
        is.read(bytes);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);
        BufferedOutputStream buf = new BufferedOutputStream(bos);
        ZipOutputStream zos = new ZipOutputStream(buf);
        ZipEntry e = new ZipEntry("zip");
        byte[] compressed = null;
        e.setMethod(8);
        e.setSize(bytes.length);
        zos.putNextEntry(e);
        zos.write(bytes, 0, bytes.length);
        zos.flush();
        buf.flush();
        bos.flush();
        zos.close();
        compressed = bos.toByteArray();
        buf.close();
        bos.close();
        return compressed;
    }

    public String format(int n) {
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMinimumIntegerDigits(3);
        formatter.setGroupingUsed(false);
        String formated = formatter.format(n);
        return formated;
    }

    public void setTimeOut(int sec) {
        this.timeout = sec * 1000;
        if (this.client != null) {
            this.client.setTimeout(this.timeout);
        }
    }

    public String getClientVersion() {
        return this.cVersion;
    }

    public String getIDGVersion() {
        return this.sVersion;
    }

    public IIDGResult submitJob(String[] fileNames, String jobName, String ID, String priority, String[] authentication) throws IDGClientException {
        if (fileNames == null || fileNames.length <= 0) {
            return null;
        }
        try {
            IDGWSBuilder builder = new IDGWSBuilder();
            byte[] xmlData = builder.buildXML(fileNames, jobName, ID, priority, authentication);
            OctetStream octecStream = new OctetStream(this.zipData(xmlData));
            OctetStreamDataSource octetDS = new OctetStreamDataSource("", octecStream);
            DataHandler dh = new DataHandler((DataSource)octetDS);
            AttachmentPart apart = new AttachmentPart(dh);
            apart.setContentId("IDGWSInfo");
            this.client.addAttachment(apart);
        }
        catch (ParserConfigurationException e) {
            throw new IDGClientException("build xml error...");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IIDGResult idgResult = null;
        int i = 0;
        while (i < fileNames.length) {
            File file = new File(fileNames[i]);
            if (!file.exists()) {
                throw new IDGClientException("file : [" + fileNames[i] + "] is not exit.");
            }
            try {
                FileInputStream is = new FileInputStream(file);
                OctetStream octecStream = new OctetStream(this.zipData(is));
                OctetStreamDataSource octetDS = new OctetStreamDataSource("", octecStream);
                DataHandler dh = new DataHandler((DataSource)octetDS);
                AttachmentPart apart = new AttachmentPart(dh);
                apart.setContentId("input_" + this.format(i));
                this.client.addAttachment(apart);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        try {
            IDGResult result = this.client.submitJobByAttatch();
            if (result.getMessagecode() != 0) {
                throw new IDGClientException(result.getMessage());
            }
            idgResult = this.doResult(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IDGClientException(e.getMessage());
        }
        return idgResult;
    }

    public IIDGResult submitJob(String fileName, String jobName, String ID, String priority, String[] authentication) throws IDGClientException {
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            throw new IDGClientException("file : [" + fileName + "] is not exit.");
        }
        try {
            IDGWSBuilder builder = new IDGWSBuilder();
            byte[] xmlData = builder.buildXML(fileName, jobName, ID, priority, authentication);
            OctetStream octecStream = new OctetStream(this.zipData(xmlData));
            OctetStreamDataSource octetDS = new OctetStreamDataSource("", octecStream);
            DataHandler dh = new DataHandler((DataSource)octetDS);
            AttachmentPart apart = new AttachmentPart(dh);
            apart.setContentId("IDGWSInfo");
            this.client.addAttachment(apart);
        }
        catch (ParserConfigurationException e) {
            throw new IDGClientException("build xml error...");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            FileInputStream is = new FileInputStream(file);
            OctetStream octecStream = new OctetStream(this.zipData(is));
            OctetStreamDataSource octetDS = new OctetStreamDataSource("", octecStream);
            DataHandler dh = new DataHandler((DataSource)octetDS);
            AttachmentPart apart = new AttachmentPart(dh);
            apart.setContentId("input_000");
            this.client.addAttachment(apart);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IDGResult result = null;
        IIDGResult idgResult = null;
        try {
            result = this.client.submitJobByAttatch();
            if (result.getMessagecode() != 0) {
                throw new IDGClientException(result.getMessage());
            }
            idgResult = this.doResult(result);
        }
        catch (Exception e) {
            throw new IDGClientException(e.getMessage());
        }
        return idgResult;
    }

    public IIDGResult submitJob(InputStream[] inputs, String[] fileNames, String jobName, String ID, String priority, String[] authentication) throws IDGClientException {
        AttachmentPart apart;
        DataHandler dh;
        OctetStreamDataSource octetDS;
        OctetStream octecStream;
        IIDGResult idgResult = null;
        IDGResult result = null;
        try {
            IDGWSBuilder builder = new IDGWSBuilder();
            byte[] xmlData = builder.buildXML(fileNames, jobName, ID, priority, authentication);
            octecStream = new OctetStream(this.zipData(xmlData));
            octetDS = new OctetStreamDataSource("", octecStream);
            dh = new DataHandler((DataSource)octetDS);
            apart = new AttachmentPart(dh);
            apart.setContentId("IDGWSInfo");
            this.client.addAttachment(apart);
        }
        catch (ParserConfigurationException e) {
            throw new IDGClientException("build xml error...");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (inputs == null || inputs.length == 0 || fileNames == null || fileNames.length == 0 || fileNames.length != inputs.length) {
                throw new IDGClientException("arg is invaild.");
            }
            int i = 0;
            while (i < inputs.length) {
                InputStream stream = inputs[i];
                if (stream != null) {
                    octecStream = new OctetStream(this.zipData(stream));
                    octetDS = new OctetStreamDataSource("", octecStream);
                    dh = new DataHandler((DataSource)octetDS);
                    apart = new AttachmentPart(dh);
                    apart.setContentId("input_" + this.format(i));
                    this.client.addAttachment(apart);
                }
                ++i;
            }
            result = this.client.submitJobByAttatch();
            idgResult = this.doResult(result);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return idgResult;
    }

    public IIDGResult submitJob(InputStream input, String fileName, String jobName, String ID, String priority, String[] authentication) throws IDGClientException {
        if (input == null) {
            return null;
        }
        IIDGResult idgResult = null;
        IDGResult result = null;
        try {
            IDGWSBuilder builder = new IDGWSBuilder();
            byte[] xmlData = builder.buildXML(fileName, jobName, ID, priority, authentication);
            OctetStream octecStream = new OctetStream(this.zipData(xmlData));
            OctetStreamDataSource octetDS = new OctetStreamDataSource("", octecStream);
            DataHandler dh = new DataHandler((DataSource)octetDS);
            AttachmentPart apart = new AttachmentPart(dh);
            apart.setContentId("IDGWSInfo");
            this.client.addAttachment(apart);
        }
        catch (ParserConfigurationException e) {
            throw new IDGClientException("build xml error...");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            OctetStream octecStream = new OctetStream(this.zipData(input));
            OctetStreamDataSource octetDS = new OctetStreamDataSource("", octecStream);
            DataHandler dh = new DataHandler((DataSource)octetDS);
            AttachmentPart apart = new AttachmentPart(dh);
            apart.setContentId("input_000");
            this.client.addAttachment(apart);
            result = this.client.submitJobByAttatch();
            idgResult = this.doResult(result);
        }
        catch (Exception e) {
            throw new IDGClientException(e.getMessage());
        }
        return idgResult;
    }

    public IIDGResult submitJob(byte[] buf, String fileName, String jobName, String ID, String priority, String[] authentication) throws IDGClientException {
        if (buf == null || buf.length == 0) {
            return null;
        }
        IIDGResult idgResult = null;
        IDGResult result = null;
        try {
            IDGWSBuilder builder = new IDGWSBuilder();
            byte[] xmlData = builder.buildXML(fileName, jobName, ID, priority, authentication);
            OctetStream octecStream = new OctetStream(this.zipData(xmlData));
            OctetStreamDataSource octetDS = new OctetStreamDataSource("", octecStream);
            DataHandler dh = new DataHandler((DataSource)octetDS);
            AttachmentPart apart = new AttachmentPart(dh);
            apart.setContentId("IDGWSInfo");
            this.client.addAttachment(apart);
        }
        catch (ParserConfigurationException e) {
            throw new IDGClientException("build xml error...");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            OctetStream octecStream = new OctetStream(this.zipData(buf));
            OctetStreamDataSource octetDS = new OctetStreamDataSource("", octecStream);
            DataHandler dh = new DataHandler((DataSource)octetDS);
            AttachmentPart apart = new AttachmentPart(dh);
            apart.setContentId("input_000");
            this.client.addAttachment(apart);
            result = this.client.submitJobByAttatch();
            idgResult = this.doResult(result);
        }
        catch (Exception e) {
            throw new IDGClientException(e.getMessage());
        }
        return idgResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLog(String content) {
        byte[] byArray = lock;
        synchronized (lock) {
            try {
                FileWriter fw = new FileWriter("D:\\agentlog.txt", true);
                fw.write(content);
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    private IIDGResult doResult(IDGResult result) throws IDGClientException {
        IDGResultImpl idgResult = null;
        try {
            if (result.getMessagecode() != 0) {
                throw new IDGClientException(result.getMessage());
            }
            Object[] ap = this.client.getAttachments();
            if (ap.length > 0) {
                InputStream[] isAry = new InputStream[ap.length];
                int i = 0;
                while (i < ap.length) {
                    InputStream is;
                    AttachmentPart attach = (AttachmentPart)ap[i];
                    DataHandler datahandler = attach.getDataHandler();
                    isAry[i] = is = datahandler.getInputStream();
                    ++i;
                }
                idgResult = new IDGResultImpl(isAry);
            }
        }
        catch (Exception e) {
            throw new IDGClientException(e.getMessage());
        }
        return idgResult;
    }

    public static void main(String[] args) {
        IDGClientImpl aa = null;
        try {
            aa = new IDGClientImpl("172.86.50.70", "8899");
        }
        catch (IDGClientException e) {
            e.printStackTrace();
        }
        int timeout = 10000000;
        aa.setTimeOut(timeout);
        IIDGResult result = null;
        try {
            try {
                String[] filenames = new String[]{"D:\\seal.xml", "D:\\ONE.pdf"};
                result = aa.submitJob(filenames, "", "", "", new String[]{"Richard Zhang", "1qaz@WSX"});
                InputStream[] streams = result.getStreams();
                if (streams != null && streams.length > 0) {
                    int j = 0;
                    while (j < streams.length) {
                        aa.save(streams[j], new File("D:\\ppppage.pdf"));
                        ++j;
                    }
                }
                result.closeStreams();
            }
            catch (IDGClientException idgEx) {
                System.out.println(idgEx.getErrorMessage());
                idgEx.printStackTrace();
                if (result != null) {
                    result.closeStreams();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (result != null) {
                    result.closeStreams();
                }
            }
        }
        finally {
            if (result != null) {
                result.closeStreams();
            }
        }
    }

    public void save(InputStream in, File destFile) throws Exception {
        byte[] buf = new byte[10240];
        int len = -1;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(destFile);
            while ((len = in.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }
}

