/*
 * Decompiled with CFR 0.152.
 */
package com.docnologies.digitalsignature;

import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfPKCS7;
import com.itextpdf.text.pdf.PdfReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class VerifyPdf {
    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static byte[] verifySignature(String pdf, String chain) throws Exception {
        FileInputStream pdfStream = null;
        InputStream chainStream = null;
        byte[] result = null;
        try {
            pdfStream = new FileInputStream(pdf);
            chainStream = new FileInputStream(chain);
            result = VerifyPdf.verifySignature((InputStream)pdfStream, chainStream);
        }
        finally {
            if (pdfStream != null) {
                ((InputStream)pdfStream).close();
            }
            if (chainStream != null) {
                chainStream.close();
            }
        }
        return result;
    }

    public static byte[] verifySignature(String pdf, InputStream chain) throws Exception {
        FileInputStream pdfStream = null;
        byte[] result = null;
        try {
            pdfStream = new FileInputStream(pdf);
            result = VerifyPdf.verifySignature((InputStream)pdfStream, chain);
        }
        finally {
            if (pdfStream != null) {
                ((InputStream)pdfStream).close();
            }
        }
        return result;
    }

    public static byte[] verifySignature(String pdf, byte[] chain) throws Exception {
        FileInputStream pdfStream = null;
        InputStream chainStream = null;
        byte[] result = null;
        try {
            pdfStream = new FileInputStream(pdf);
            chainStream = new ByteArrayInputStream(chain);
            result = VerifyPdf.verifySignature((InputStream)pdfStream, chainStream);
        }
        finally {
            if (pdfStream != null) {
                ((InputStream)pdfStream).close();
            }
            if (chainStream != null) {
                chainStream.close();
            }
        }
        return result;
    }

    public static byte[] verifySignature(InputStream pdf, String chain) throws Exception {
        FileInputStream chainStream = null;
        byte[] result = null;
        try {
            chainStream = new FileInputStream(chain);
            result = VerifyPdf.verifySignature(pdf, (InputStream)chainStream);
        }
        finally {
            if (chainStream != null) {
                ((InputStream)chainStream).close();
            }
        }
        return result;
    }

    public static byte[] verifySignature(InputStream pdf, byte[] chain) throws Exception {
        ByteArrayInputStream chainStream = null;
        byte[] result = null;
        try {
            chainStream = new ByteArrayInputStream(chain);
            result = VerifyPdf.verifySignature(pdf, (InputStream)chainStream);
        }
        finally {
            if (chainStream != null) {
                ((InputStream)chainStream).close();
            }
        }
        return result;
    }

    public static byte[] verifySignature(InputStream pdf, InputStream chain) throws Exception {
        ByteArrayOutputStream bos = null;
        try {
            int n;
            bos = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            while ((n = pdf.read(buff)) != -1) {
                bos.write(buff, 0, n);
            }
            byte[] byArray = VerifyPdf.verifySignature(bos.toByteArray(), chain);
            return byArray;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (bos != null) {
                bos.close();
            }
        }
    }

    public static byte[] verifySignature(byte[] pdf, String chain) throws Exception {
        InputStream chainStream = null;
        ByteArrayInputStream pdfStream = null;
        byte[] result = null;
        try {
            pdfStream = new ByteArrayInputStream(pdf);
            chainStream = new FileInputStream(chain);
            result = VerifyPdf.verifySignature((InputStream)pdfStream, chainStream);
        }
        finally {
            if (chainStream != null) {
                chainStream.close();
            }
            if (pdfStream != null) {
                ((InputStream)pdfStream).close();
            }
        }
        return result;
    }

    public static byte[] verifySignature(byte[] pdf, byte[] chain) throws Exception {
        InputStream chainStream = null;
        ByteArrayInputStream pdfStream = null;
        byte[] result = null;
        try {
            pdfStream = new ByteArrayInputStream(pdf);
            chainStream = new ByteArrayInputStream(chain);
            result = VerifyPdf.verifySignature((InputStream)pdfStream, chainStream);
        }
        finally {
            if (chainStream != null) {
                chainStream.close();
            }
            if (pdfStream != null) {
                ((InputStream)pdfStream).close();
            }
        }
        return result;
    }

    public static byte[] verifySignature(byte[] pdf, InputStream chain) throws Exception {
        PdfReader reader = null;
        Document document = null;
        XMLWriter writer = null;
        ByteArrayOutputStream bos = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            Collection<? extends Certificate> col = cf.generateCertificates(chain);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, null);
            for (X509Certificate x509Certificate : col) {
                ks.setCertificateEntry(x509Certificate.getSerialNumber().toString(36), x509Certificate);
            }
            reader = new PdfReader(pdf);
            AcroFields af = reader.getAcroFields();
            ArrayList arrayList = af.getSignatureNames();
            document = DocumentHelper.createDocument();
            document.setXMLEncoding("utf-8");
            Element verificationElement = document.addElement("verification");
            document.setRootElement(verificationElement);
            Element statusElement = verificationElement.addElement("status");
            if (arrayList.size() == 0) {
                statusElement.setText("unsigned");
            } else if (arrayList.size() > 1) {
                statusElement.setText("modified");
            } else {
                InputStream revisionStream = null;
                ByteArrayOutputStream tempOs = null;
                try {
                    int n;
                    revisionStream = af.extractRevision((String)arrayList.get(0));
                    tempOs = new ByteArrayOutputStream();
                    byte[] buff = new byte[1024];
                    while ((n = revisionStream.read(buff)) != -1) {
                        tempOs.write(buff, 0, n);
                    }
                    tempOs.close();
                    byte[] revision = tempOs.toByteArray();
                    if (revision.length != pdf.length) {
                        statusElement.setText("modified");
                    } else {
                        boolean same = true;
                        int i = 0;
                        int length = revision.length;
                        while (i < length) {
                            if (pdf[i] != revision[i]) {
                                same = false;
                                break;
                            }
                            ++i;
                        }
                        if (same) {
                            statusElement.setText("original");
                        } else {
                            statusElement.setText("modified");
                        }
                    }
                }
                finally {
                    if (revisionStream != null) {
                        revisionStream.close();
                    }
                    if (tempOs != null) {
                        tempOs.close();
                    }
                }
            }
            Element signaturesElement = verificationElement.addElement("signatures");
            for (String name : arrayList) {
                signaturesElement.add(VerifyPdf.verifySpecifiedSignature(af, name, ks));
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("utf-8");
            bos = new ByteArrayOutputStream();
            writer = new XMLWriter((OutputStream)bos, format);
            writer.write(document);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return bos.toByteArray();
    }

    private static Element verifySpecifiedSignature(AcroFields af, String signatureName, KeyStore ks) throws Exception {
        Element signatureElement = DocumentHelper.createElement((String)"signature");
        Element nameElement = signatureElement.addElement("name");
        nameElement.setText(signatureName);
        PdfPKCS7 pk = af.verifySignature(signatureName, "BC");
        if (pk == null) {
            throw new Exception(String.valueOf(signatureName) + " signature field is not exist");
        }
        Calendar cal = pk.getSignDate();
        Certificate[] pkc = pk.getCertificates();
        Element subjectElement = signatureElement.addElement("subject");
        subjectElement.setText(PdfPKCS7.getSubjectFields((X509Certificate)pk.getSigningCertificate()).toString());
        Element contactElement = signatureElement.addElement("contact");
        contactElement.setText(pk.getSignName() == null ? "" : pk.getSignName());
        Element reasonElement = signatureElement.addElement("reason");
        reasonElement.setText(pk.getReason() == null ? "" : pk.getReason());
        Element locationElement = signatureElement.addElement("location");
        locationElement.setText(pk.getLocation() == null ? "" : pk.getLocation());
        Element signdateElement = signatureElement.addElement("signdate");
        signdateElement.setText(pk.getSignDate().getTime().toString());
        Element issuerElement = signatureElement.addElement("issuer");
        issuerElement.setText(pk.getSigningCertificate().getIssuerDN().getName());
        Element modifiedElement = signatureElement.addElement("modified");
        modifiedElement.setText(String.valueOf(!pk.verify()));
        Object[] fails = PdfPKCS7.verifyCertificates((Certificate[])pkc, (KeyStore)ks, null, (Calendar)cal);
        Element verifyElement = signatureElement.addElement("verify");
        if (fails == null) {
            verifyElement.setText("true");
        } else {
            verifyElement.setText("false");
        }
        Element coverElement = signatureElement.addElement("coverwholedoc");
        coverElement.setText(String.valueOf(af.signatureCoversWholeDocument(signatureName)));
        return signatureElement;
    }

    public static void main(String[] args) {
        try {
            byte[] xml = VerifyPdf.verifySignature("G:\\certify.pdf", "g:\\mykey.cer");
            System.out.println(new String(xml));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static byte[] streamToByteArray(InputStream rangeStream) throws IOException {
        ByteArrayOutputStream bos = null;
        byte[] result = null;
        try {
            int c;
            bos = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            while ((c = rangeStream.read(buf)) != -1) {
                bos.write(buf, 0, c);
            }
            result = bos.toByteArray();
        }
        finally {
            if (bos != null) {
                bos.close();
            }
        }
        return result;
    }
}

