/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbcx.IfxPooledConnection;
import com.informix.jdbcx.IfxReUsableConnection;
import java.sql.SQLException;
import java.util.Properties;

public class IfxSqliConnReUsableConnection
extends IfxSqliConnect
implements IfxReUsableConnection {
    private IfxPooledConnection parentPoolConn = null;
    private Properties connProperties;
    private String ldbName;
    private String connUser;
    private String connPasswd;

    public IfxSqliConnReUsableConnection() throws SQLException {
        this.connProperties = null;
        this.ldbName = null;
    }

    public IfxSqliConnReUsableConnection(String string, String string2, IfxPooledConnection ifxPooledConnection, String string3, Properties properties, String string4) throws SQLException {
        super(string, string2, string3, properties);
        this.parentPoolConn = ifxPooledConnection;
        this.connProperties = properties;
        this.connUser = string;
        this.connPasswd = string2;
        if (string4 != null) {
            this.ldbName = string4;
            this.proto.executeOpenDatabase(this.ldbName, 0);
            this.setServerIsolationLevel();
        }
    }

    String getConnUser() {
        return this.connUser;
    }

    String getConnPasswd() {
        return this.connPasswd;
    }

    @Override
    public void close() throws SQLException {
        if (this.ldbName != null) {
            try {
                this.closeAllResultSets();
                this.clearTransactions(false);
                this.closeAllStatements();
                this.resetDatabaseProperties();
            }
            catch (SQLException sQLException) {
                if (this.parentPoolConn != null) {
                    this.parentPoolConn.notifyListenersOfErrors(sQLException);
                }
                throw sQLException;
            }
        }
        this.parentPoolConn.notifyListeners();
        this.softCloseDone = true;
    }

    @Override
    public void hardClose() throws SQLException {
        super.close();
    }

    protected void finalize() {
    }
}

