/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbcx.IfxXAReusableConnection;
import com.informix.jdbcx.IfxXASqli;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.sql.SQLException;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class IfxXAResource
implements XAResource {
    private IfxXAReusableConnection conn = null;
    private int rmid = 1;
    private Trace trace = null;
    private IfxXASqli proto = null;
    private int XAError = 0;
    protected Vector xidList = null;

    IfxXAResource(IfxXAReusableConnection ifxXAReusableConnection) {
        this.conn = ifxXAReusableConnection;
        this.trace = this.conn.getTrace();
        this.proto = (IfxXASqli)this.conn.getProto();
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        int n = 0;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: commit() called");
        }
        this.XAError = 0;
        this.proto.clearWarnings();
        if (bl) {
            n = 0x40000000;
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "  commit() setting TMONEPHASE");
            }
        }
        try {
            this.XAError = this.proto.executeXACommand((short)67, xid, this.rmid, n);
            this.errClose(this.XAError, 0);
        }
        catch (Exception exception) {
            throw new XAException(exception.toString());
        }
        if (this.XAError != 0) {
            throw new XAException(this.XAError);
        }
        this.removeFromXidList(xid);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: commit() exited");
        }
    }

    @Override
    public void end(Xid xid, int n) throws XAException {
        Object var3_3 = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: end() called");
        }
        this.XAError = 0;
        this.proto.clearWarnings();
        if ((n & 0x26000000) == 0) {
            throw new XAException(-5);
        }
        try {
            this.XAError = this.proto.executeXACommand((short)68, xid, this.rmid, n);
        }
        catch (Exception exception) {
            this.removeFromXidList(xid);
            throw new XAException(exception.toString());
        }
        this.conn.startXA = false;
        this.conn.currentXid = null;
        if (this.XAError != 0) {
            this.removeFromXidList(xid);
            throw new XAException(this.XAError);
        }
        if (n == 0x2000000) {
            this.removeFromXidList(xid);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: end() exited");
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: forget() called");
        }
        this.XAError = 0;
        this.proto.clearWarnings();
        try {
            this.XAError = this.proto.executeXACommand((short)69, xid, this.rmid, 0);
        }
        catch (Exception exception) {
            this.conn.startXA = false;
            this.conn.currentXid = null;
            this.removeFromXidList(xid);
            throw new XAException(exception.toString());
        }
        this.errClose(this.XAError, 0);
        if (this.XAError != 0) {
            this.conn.startXA = false;
            this.conn.currentXid = null;
            this.removeFromXidList(xid);
            throw new XAException(this.XAError);
        }
        this.removeFromXidList(xid);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: forget() exited");
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: getTransactionTimeout() called");
        }
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl = false;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: isSameRM() called");
        }
        if (xAResource instanceof IfxXAResource && this.conn.getServerName().equals(((IfxXAResource)xAResource).conn.getServerName())) {
            bl = true;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: isSameRM() exited");
        }
        return bl;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: prepare() called");
        }
        this.XAError = 0;
        this.proto.clearWarnings();
        try {
            this.XAError = this.proto.executeXACommand((short)70, xid, this.rmid, 0);
        }
        catch (Exception exception) {
            throw new XAException(exception.toString());
        }
        this.errClose(this.XAError, 0);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: prepare() exited");
        }
        if (this.XAError >= 100 && this.XAError <= 107 || this.XAError == 3) {
            this.removeFromXidList(xid);
            this.conn.startXA = false;
            this.conn.currentXid = null;
        }
        if (this.XAError < 0) {
            this.removeFromXidList(xid);
            throw new XAException(this.XAError);
        }
        return this.XAError;
    }

    @Override
    public Xid[] recover(int n) throws XAException {
        int n2 = 10;
        String string = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: recover() called");
        }
        this.XAError = 0;
        this.proto.clearWarnings();
        if (n != 0 && n != 0x1000000 && n != 0x800000 && n != 0x1800000) {
            throw new XAException(-5);
        }
        try {
            this.XAError = this.proto.executeXARecover(n2, this.rmid, n);
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        int n3 = this.proto.getSQLCode();
        if (n3 == -457 || n3 == -408) {
            this.removeXidList();
            throw new XAException(-7);
        }
        if (n3 != 0) {
            this.removeXidList();
            throw new XAException(string);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: recover() exited");
        }
        if (this.XAError < 0) {
            this.removeXidList();
            throw new XAException(this.XAError);
        }
        return (Xid[])this.proto.getXidArray();
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        int n = 0;
        String string = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: rollback() called");
        }
        this.XAError = 0;
        this.proto.clearWarnings();
        try {
            this.XAError = this.proto.executeXACommand((short)65, xid, this.rmid, 0);
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        n = this.proto.getSQLCode();
        if (n == -457 || n == -408) {
            this.removeFromXidList(xid);
            throw new XAException(-7);
        }
        if (this.XAError < 0 && this.XAError != -3) {
            this.removeFromXidList(xid);
            throw new XAException(this.XAError);
        }
        this.errClose(this.XAError, 0);
        if (this.XAError != 0) {
            throw new XAException(this.XAError);
        }
        this.removeFromXidList(xid);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: rollback() exited");
        }
    }

    @Override
    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    @Override
    public void start(Xid xid, int n) throws XAException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: start() called");
        }
        if (this.conn.isInUserTransaction()) {
            throw new XAException(-9);
        }
        this.XAError = 0;
        this.proto.clearWarnings();
        if (n != 0 && (n & 0x8200000) == 0) {
            throw new XAException(-5);
        }
        try {
            this.XAError = this.proto.executeXACommand((short)72, xid, this.rmid, n);
        }
        catch (SQLException sQLException) {
            this.removeXidList();
            throw new XAException(-7);
        }
        if (this.XAError != 0) {
            throw new XAException(this.XAError);
        }
        this.conn.startXA = true;
        this.conn.currentXid = xid;
        this.conn.inXATXN = true;
        if (n == 0) {
            this.addToXidList(xid);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: start() exited");
        }
    }

    private void errClose(int n, int n2) {
        String string = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: errClose() called");
        }
        if (n == -7) {
            try {
                string = this.conn.getDbName();
                this.conn.startXA = false;
                this.conn.currentXid = null;
                this.removeXidList();
                this.proto.executeXAClose(string, this.rmid, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource: errClose() exited");
        }
    }

    protected void removeFromXidList(Xid xid) {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource:removeFromXidList called");
        }
        if (this.xidList == null) {
            this.conn.inXATXN = false;
        }
        if (xid == null) {
            return;
        }
        if (this.xidList != null && this.xidList.size() > 0) {
            boolean bl = this.xidList.removeElement(xid);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(1, "xid removed(status=" + bl + "):" + xid);
            }
            if (this.xidList.size() == 0) {
                this.conn.inXATXN = false;
            }
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource:removeFromXidList exited");
        }
    }

    protected void addToXidList(Xid xid) {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAResource:addToXidList called");
        }
        if (this.xidList == null) {
            this.xidList = new Vector(20);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(1, "xidList is created");
            }
        }
        if (xid != null && !this.xidList.contains(xid)) {
            this.xidList.addElement(xid);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(1, "added xid to xidList:" + xid);
            }
        }
    }

    protected void removeXidList() {
        if (this.xidList != null) {
            this.xidList.removeAllElements();
            this.xidList = null;
            this.conn.inXATXN = false;
        }
    }

    private Xid findInXidList(Xid xid) {
        if (this.xidList != null && this.xidList.contains(xid)) {
            return xid;
        }
        return null;
    }

    private int noOfElementsInxidList() {
        if (this.xidList != null) {
            return this.xidList.size();
        }
        return 0;
    }

    private void cleanAllTransactions() {
        Xid[] xidArray = null;
        try {
            xidArray = this.recover(0x1000000);
            System.out.println("x is : " + xidArray);
        }
        catch (XAException xAException) {
            System.err.println("Exception: " + xAException.toString());
        }
        if (xidArray != null && xidArray.length > 0) {
            for (int i = 0; i < xidArray.length; ++i) {
                System.out.println("Recovered Xid: " + xidArray[i]);
                try {
                    this.rollback(xidArray[i]);
                    continue;
                }
                catch (XAException xAException) {
                    try {
                        this.forget(xidArray[i]);
                        continue;
                    }
                    catch (XAException xAException2) {
                        System.err.println("Exception: " + xAException2.toString());
                    }
                }
            }
        }
    }
}

