/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbcx.IfxPooledConnection;
import com.informix.jdbcx.IfxXAPooledConnection;
import com.informix.jdbcx.IfxXAResource;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class IfxXAReusableConnection
extends IfxSqliConnect {
    IfxPooledConnection parentPooledConn;
    private Properties dsProps;
    private boolean xaOpened = false;
    boolean startXA = false;
    boolean inXATXN = false;
    Xid currentXid = null;
    Trace trace = null;

    public IfxXAReusableConnection(String string, String string2, IfxPooledConnection ifxPooledConnection, String string3, Properties properties) throws SQLException {
        super(string, string2, string3, properties);
        if (this.externalVersion.startsWith("8")) {
            throw IfxErrMsg.getSQLException((int)-79834, (IfxConnection)this);
        }
        this.parentPooledConn = ifxPooledConnection;
        this.dsProps = properties;
        this.startXA = false;
        this.inXATXN = false;
        this.currentXid = null;
        this.trace = super.getTrace();
    }

    protected void finalize() {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxReusableConnection.finalize() called");
        }
        try {
            if (((IfxXAPooledConnection)this.parentPooledConn).connOpen) {
                this.hardClose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxReusableConnection.finalize() exited");
        }
    }

    public void close() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAReusableConnection.close() entered");
        }
        if (this.dbName != null) {
            try {
                this.closeAllResultSets();
                this.clearTransactions(false);
                this.closeAllStatements();
            }
            catch (SQLException sQLException) {
                if (this.parentPooledConn != null) {
                    this.parentPooledConn.notifyListenersOfErrors(sQLException);
                }
                throw sQLException;
            }
        }
        this.parentPooledConn.notifyListeners();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXAReusableConnection.close() exited");
        }
    }

    void hardClose() throws SQLException {
        try {
            this.clearTransactions(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.dbName != null) {
            ((IfxXAPooledConnection)this.parentPooledConn).closeDBforXA();
            super.markStatementAsReleased();
            super.markCursorsToClosed(false);
        }
        super.close();
    }

    public void commit() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxReusableConnection.commit() entered");
        }
        if (this.startXA) {
            throw IfxErrMsg.getSQLException((int)-700, (IfxConnection)this);
        }
        super.commit();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxReusableConnection.commit() exited");
        }
    }

    public void rollback() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxReusableConnection.rollback() entered");
        }
        if (this.startXA) {
            throw IfxErrMsg.getSQLException((int)-700, (IfxConnection)this);
        }
        super.rollback();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxReusableConnection.rollback() exited");
        }
    }

    public boolean getAutoCommit() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxReusableConnection.getAutoCommit() called");
        }
        if (this.startXA) {
            return false;
        }
        return super.getAutoCommit();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxReusableConnection.setAutoCommit() called");
        }
        if (this.startXA) {
            if (!bl) {
                return;
            }
            throw IfxErrMsg.getSQLException((int)-700, (IfxConnection)this);
        }
        super.setAutoCommit(bl);
    }

    String getServerName() {
        return this.dsProps.getProperty("INFORMIXSERVER");
    }

    public boolean isXAConnection() {
        return true;
    }

    public boolean inXATransaction() {
        return this.startXA;
    }

    /*
     * Unable to fully structure code
     */
    protected void clearTransactions(boolean var1_1) throws SQLException {
        var2_2 = null;
        var3_3 = ((IfxXAPooledConnection)this.parentPooledConn).xaRes;
        if (this.inXATransaction()) {
            if (var3_3.xidList != null && var3_3.xidList.size() > 0) {
                var2_2 = (Xid)var3_3.xidList.lastElement();
                try {
                    if (!var1_1) ** GOTO lbl29
                    var3_3.end(var2_2, 0x4000000);
                    var3_3.rollback(var2_2);
                }
                catch (XAException var4_4) {
                    throw new SQLException(var4_4.errorCode + ": " + var4_4.toString());
                }
            }
        } else if (this.isInUserTransaction()) {
            this.rollback();
        } else if (var1_1 && var3_3 != null && var3_3.xidList != null) {
            while (var3_3.xidList.size() > 0) {
                var2_2 = (Xid)var3_3.xidList.elementAt(0);
                try {
                    var3_3.rollback(var2_2);
                }
                catch (XAException var4_5) {
                    try {
                        var3_3.forget(var2_2);
                    }
                    catch (XAException var5_6) {
                        throw new SQLException(var4_5.errorCode + ": " + var4_5.toString());
                    }
                }
            }
        }
lbl29:
        // 7 sources

        if (var3_3 != null) {
            var3_3.removeXidList();
        }
    }

    private void printXidList() {
        Vector vector;
        IfxXAResource ifxXAResource = ((IfxXAPooledConnection)this.parentPooledConn).xaRes;
        if (ifxXAResource != null && (vector = ifxXAResource.xidList) != null && vector.size() > 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                System.out.println(enumeration.nextElement());
            }
        }
    }

    protected boolean isCommitNeeded() {
        if (this.inXATransaction()) {
            return false;
        }
        return super.isCommitNeeded();
    }

    public Xid getCurrentXid() {
        return this.currentXid;
    }
}

