/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbcx.IfxXMessageTypes;
import com.informix.jdbcx.IfxXid;
import com.informix.util.IfxErrMsg;
import com.informix.util.TraceFlag;
import java.sql.SQLException;
import javax.transaction.xa.Xid;

public class IfxXASqli
extends IfxSqli {
    private int XAError;
    private IfxXid[] xidArray;
    private int XACommand;

    public IfxXASqli(IfxSqliConnect ifxSqliConnect) {
        super(ifxSqliConnect);
    }

    Object[] getXidArray() {
        return this.xidArray;
    }

    public void clear() {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: clear() called");
        }
        super.clear();
        this.XAError = 0;
        this.xidArray = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: clear() exited");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage() throws SQLException {
        short s = 0;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: receiveMessage() called");
        }
        super.clearExceptions();
        try {
            this.flip();
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(1, "\nS->C");
            }
            try {
                do {
                    if (73 == (s = this.is.readSmallInt())) {
                        if (TraceFlag.compiletrace) {
                            this.protoTrace.writeTrace(1, "\tSQ_XERR");
                        }
                        this.receiveXAError();
                        continue;
                    }
                    if (s == 56 && this.conn != null) {
                        this.conn.unlockSession();
                    }
                    if (this.dispatchMsg(s)) continue;
                    break;
                } while (s != 12 && s != 56);
            }
            finally {
                if (this.sqliTrace != null) {
                    this.sqliTrace.recordS2C();
                }
            }
        }
        catch (SQLException sQLException) {
            this.addException(sQLException);
        }
        catch (Exception exception) {
            this.addException(IfxErrMsg.getSQLException((int)-79716, (IfxConnection)this.conn));
        }
        if (super.getExceptions() != null) {
            throw super.getExceptions();
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: receiveMessage() exited");
        }
    }

    public int executeXAOpen(String string, int n, int n2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: executeXAOpen() called");
        }
        if (string == null) {
            throw IfxErrMsg.getSQLException((int)-79760, (IfxConnection)this.conn);
        }
        this.XAError = 0;
        this.XACommand = 82;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException((int)-79748, (int)-80033, (IfxConnection)this.conn);
        }
        try {
            this.sendXAOpen(string, n, n2);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException((int)-79716, (String)exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.conn.xaSetSerWarnFlags((short)1, string);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: executeXAOpen() exited");
        }
        return this.XAError;
    }

    private void sendXAOpen(String string, int n, int n2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: sendXAOpen() called");
        }
        try {
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(1, "\nC->S");
                this.protoTrace.writeTrace(1, "\tSQ_XOPEN");
            }
            this.os.writeSmallInt((short)82);
            this.os.writeChars(string);
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\tDatabase Name: " + string);
            }
            this.os.writeInt(n);
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\tRmid: " + n);
            }
            this.os.writeInt(n2);
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\tFlags: " + n2);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw IfxErrMsg.getSQLException((int)-79716, (String)exception.toString(), (IfxConnection)this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: sendXAOpen() exited");
        }
    }

    public int executeXACommand(short s, Xid xid, int n, int n2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: executeXACommand() called");
        }
        this.XAError = 0;
        this.XACommand = s;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException((int)-79748, (int)-80033, (IfxConnection)this.conn);
        }
        try {
            this.sendXACommand(s, xid, n, n2);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException((int)-79716, (String)exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: executeXACommand() exited");
        }
        return this.XAError;
    }

    private void sendXACommand(short s, Xid xid, int n, int n2) throws SQLException {
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: sendXACommand() called");
        }
        byte[] byArray3 = new byte[128];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        try {
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(1, "\nC->S");
                this.protoTrace.writeTrace(1, "\t" + IfxXMessageTypes.XAMessageNameTable.get(new Integer(s)));
            }
            this.os.writeSmallInt(s);
            this.os.writeInt(xid.getFormatId());
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\tFormat ID: " + xid.getFormatId());
            }
            this.os.writeInt(byArray.length);
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\tGtrid.length: " + byArray.length);
            }
            this.os.writeInt(byArray2.length);
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\tBqual.length: " + byArray2.length);
            }
            this.os.writePadded(byArray3);
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\tData: ");
                this.protoTrace.writeTrace(2, byArray3, 'H');
            }
            this.os.writeInt(n);
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\trmid: " + n);
            }
            this.os.writeInt(n2);
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\tflags: " + n2);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException((int)-79716, (String)exception.toString(), (IfxConnection)this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: sendXACommand() exited");
        }
    }

    public int executeXAClose(String string, int n, int n2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: executeXAClose() called");
        }
        this.XAError = 0;
        this.XACommand = 66;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException((int)-79748, (int)-80033, (IfxConnection)this.conn);
        }
        try {
            this.sendXAClose(string, n, n2);
            this.receiveMessage();
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw IfxErrMsg.getSQLException((int)-79716, (String)exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: executeXAClose() exited");
        }
        return this.XAError;
    }

    private void sendXAClose(String string, int n, int n2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: sendXAClose() called");
        }
        try {
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(1, "\nC->S");
                this.protoTrace.writeTrace(1, "\tSQ_XCLOSE");
            }
            this.os.writeSmallInt((short)66);
            this.os.writeChars(string);
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\tName: " + string);
            }
            this.os.writeInt(n);
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\trmid: " + n);
            }
            this.os.writeInt(n2);
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\tFlags: " + n2);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw IfxErrMsg.getSQLException((int)-79716, (String)exception.toString(), (IfxConnection)this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: sendXAClose() exited");
        }
    }

    public int executeXARecover(int n, int n2, int n3) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: executeXARecover() called");
        }
        this.XAError = 0;
        this.XACommand = 71;
        if (!this.conn.lockSession()) {
            throw IfxErrMsg.getSQLMinorException((int)-79748, (int)-80033, (IfxConnection)this.conn);
        }
        try {
            this.sendXARecover(n, n2, n3);
            this.receiveMessage();
        }
        catch (SQLException sQLException) {
            this.conn.unlockSession();
            throw sQLException;
        }
        catch (Exception exception) {
            this.conn.unlockSession();
            throw IfxErrMsg.getSQLException((int)-79716, (String)exception.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: executeXARecover() exited");
        }
        return this.XAError;
    }

    private void sendXARecover(int n, int n2, int n3) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: sendXARecover() called");
        }
        try {
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(1, "\nC->S");
                this.protoTrace.writeTrace(1, "\tSQ_XRECOVER");
            }
            this.os.writeSmallInt((short)71);
            this.os.writeInt(n);
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\tCount: " + n);
            }
            this.os.writeInt(n2);
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\tend: " + n2);
            }
            this.os.writeInt(n3);
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\tFlags: " + n3);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException((int)-79716, (String)exception.toString(), (IfxConnection)this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: sendXARecover() exited");
        }
    }

    private void receiveXAError() throws SQLException {
        boolean bl = false;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: receiveXAError() called");
        }
        try {
            this.xidArray = null;
            this.XAError = this.is.readSmallInt();
            if (TraceFlag.compiletrace) {
                this.protoTrace.writeTrace(2, "\t\tXAError: " + this.XAError);
            }
            if (this.XACommand == 71) {
                int n = this.XAError;
                if (TraceFlag.compiletrace) {
                    this.protoTrace.writeTrace(2, "\t\tXid count: " + n);
                }
                if (n <= 0) {
                    return;
                }
                this.xidArray = new IfxXid[n];
                byte[] byArray = null;
                byte[] byArray2 = null;
                byte[] byArray3 = new byte[128];
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    int n3 = this.is.readInt();
                    if (TraceFlag.compiletrace) {
                        this.protoTrace.writeTrace(2, "\t\t\tformatId: " + n3);
                    }
                    n2 = this.is.readInt();
                    if (TraceFlag.compiletrace) {
                        this.protoTrace.writeTrace(2, "\t\t\tgtrid length: " + n2);
                    }
                    byArray = new byte[n2];
                    n2 = this.is.readInt();
                    if (TraceFlag.compiletrace) {
                        this.protoTrace.writeTrace(2, "\t\t\tbqual length: " + n2);
                    }
                    byArray2 = new byte[n2];
                    this.is.readPadded(byArray3);
                    if (TraceFlag.compiletrace) {
                        this.protoTrace.writeTrace(2, "\t\tData: ");
                        this.protoTrace.writeTrace(2, byArray3, 'H');
                    }
                    System.arraycopy(byArray3, 0, byArray, 0, byArray.length);
                    System.arraycopy(byArray3, byArray.length, byArray2, 0, byArray2.length);
                    this.xidArray[i] = new IfxXid(n3, byArray, byArray2);
                }
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException((int)-79716, (String)exception.toString(), (IfxConnection)this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxXASqli: receiveXAError() exited");
        }
    }
}

