/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbcx.IfxPooledConnection;
import com.informix.jdbcx.IfxXADataSource;
import com.informix.jdbcx.IfxXAResource;
import com.informix.jdbcx.IfxXAReusableConnection;
import com.informix.jdbcx.IfxXASqli;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

class IfxXAPooledConnection
extends IfxPooledConnection
implements XAConnection {
    private final int TMMTSDTC = 4096;
    private Vector listeners;
    private IfxXADataSource xads;
    private IfxXAReusableConnection conn;
    protected IfxXAResource xaRes;
    protected boolean connOpen;
    private String url;
    private String dbName;
    private IfxXASqli proto;
    private boolean isConnAvailable;

    public IfxXAPooledConnection() throws SQLException {
        this.listeners = new Vector();
        this.xads = null;
        this.conn = null;
        this.xaRes = null;
        this.url = null;
        this.dbName = null;
        this.proto = null;
        this.isConnAvailable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IfxXAPooledConnection(IfxXADataSource ifxXADataSource, String string, String string2) throws SQLException {
        Properties properties = null;
        this.xaRes = null;
        this.url = null;
        this.dbName = null;
        this.proto = null;
        this.listeners = new Vector();
        this.xads = ifxXADataSource;
        Properties properties2 = properties = this.xads.getDsProperties();
        synchronized (properties2) {
            this.url = properties.getProperty("IFXHOST") + ":" + properties.getProperty("PORTNO");
            this.dbName = properties.getProperty("DATABASE");
            if (this.dbName != null) {
                properties.remove("DATABASE");
            }
            try {
                this.conn = new IfxXAReusableConnection(string, string2, this, this.url, properties);
            }
            catch (SQLException sQLException) {
                this.conn = null;
                this.url = null;
                if (this.dbName != null) {
                    properties.put("DATABASE", this.dbName);
                }
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw sQLException;
            }
            if (this.dbName != null) {
                properties.put("DATABASE", this.dbName);
            }
            this.proto = (IfxXASqli)this.conn.getProto();
            this.openDBforXA();
            this.conn.setServerIsolationLevel();
        }
        this.connOpen = true;
        this.isConnAvailable = true;
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        SQLException sQLException = null;
        if (!this.connOpen) {
            return;
        }
        try {
            try {
                this.conn.hardClose();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                Object var4_3 = null;
                this.conn = null;
                this.dbName = null;
                this.proto = null;
                this.xaRes = null;
                this.connOpen = false;
                if (sQLException == null) return;
                throw sQLException;
            }
            Object var4_2 = null;
            this.conn = null;
            this.dbName = null;
            this.proto = null;
            this.xaRes = null;
            this.connOpen = false;
            if (sQLException == null) return;
            throw sQLException;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.conn = null;
            this.dbName = null;
            this.proto = null;
            this.xaRes = null;
            this.connOpen = false;
            if (sQLException == null) throw throwable;
            throw sQLException;
        }
    }

    public XAResource getXAResource() throws SQLException {
        if (this.xaRes == null) {
            this.xaRes = new IfxXAResource(this.conn);
        }
        return this.xaRes;
    }

    void openDBforXA() throws SQLException {
        String string = this.xads.getIfxIFX_XASPEC();
        this.proto.executeXAOpen(this.dbName, 1, string.equals("y") ? 4096 : 0);
        this.connOpen = true;
    }

    void closeDBforXA() throws SQLException {
        this.proto.executeXAClose(this.dbName, 1, 0);
        this.connOpen = false;
    }
}

