/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.ironsoftware.ironpdf.internal.proto.BooleanResult;
import com.ironsoftware.ironpdf.internal.proto.EmptyResult;
import com.ironsoftware.ironpdf.internal.proto.GetVerifiedSignatureRequest;
import com.ironsoftware.ironpdf.internal.proto.GetVerifySignatureResult;
import com.ironsoftware.ironpdf.internal.proto.SignPdfRequestStream;
import com.ironsoftware.ironpdf.internal.proto.VerifyPdfSignaturesRequest;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Signature_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_ReceivingCustomStreamObserver;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import com.ironsoftware.ironpdf.signature.Signature;
import com.ironsoftware.ironpdf.signature.VerifiedSignature;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public final class Signature_Api {
    public static List<VerifiedSignature> getVerifiedSignatures(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        GetVerifiedSignatureRequest.Builder req = GetVerifiedSignatureRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList resultChunks = new ArrayList();
        client.stub.pdfDocumentSignatureGetVerifiedSignature(req.build(), new Utils_ReceivingCustomStreamObserver<GetVerifySignatureResult>(finishLatch, resultChunks));
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        if (resultChunks.size() == 0) {
            throw new RuntimeException("No response from IronPdf.");
        }
        GetVerifySignatureResult res = (GetVerifySignatureResult)resultChunks.stream().findFirst().get();
        return Signature_Converter.fromProto(res);
    }

    public static void signPdfWithSignatureFile(InternalPdfDocument internalPdfDocument, Signature signature) {
        SignPdfRequestStream.Builder msg;
        byte[] bytes;
        RpcClient client = Access.ensureConnection();
        SignPdfRequestStream.Info.Builder info = SignPdfRequestStream.Info.newBuilder();
        info.setDocument(internalPdfDocument.remoteDocument);
        if (signature.getSigningContact() != null) {
            info.setSigningContact(signature.getSigningContact());
        }
        if (signature.getPassword() != null) {
            info.setPassword(signature.getPassword());
        }
        if (signature.getSigningLocation() != null) {
            info.setSigningLocation(signature.getSigningLocation());
        }
        if (signature.getSigningReason() != null) {
            info.setSigningReason(signature.getSigningReason());
        }
        if (signature.getSignatureDate() != null) {
            info.setSignatureDate(Timestamp.newBuilder().setSeconds(signature.getSignatureDate().getEpochSecond()).setNanos(signature.getSignatureDate().getNano()));
        }
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<EmptyResult> resultChunks = new ArrayList<EmptyResult>();
        StreamObserver<SignPdfRequestStream> requestStream = client.stub.pdfDocumentSignatureSignPdf(new Utils_ReceivingCustomStreamObserver<EmptyResult>(finishLatch, resultChunks));
        SignPdfRequestStream.Builder infoMsg = SignPdfRequestStream.newBuilder();
        infoMsg.setInfo(info);
        requestStream.onNext((Object)infoMsg.build());
        Iterator<byte[]> it = Utils_Util.chunk(signature.getCertificateRawData());
        while (it.hasNext()) {
            bytes = it.next();
            msg = SignPdfRequestStream.newBuilder();
            msg.setCertificateFileBytesChunk(ByteString.copyFrom((byte[])bytes));
            requestStream.onNext((Object)msg.build());
        }
        if (signature.getSignatureImage() != null) {
            it = Utils_Util.chunk(signature.getSignatureImage());
            while (it.hasNext()) {
                bytes = it.next();
                msg = SignPdfRequestStream.newBuilder();
                msg.setSignatureImageChunk(ByteString.copyFrom((byte[])bytes));
                requestStream.onNext((Object)msg.build());
            }
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        Utils_Util.handleEmptyResultChunks(resultChunks);
    }

    public static boolean verifyPdfSignatures(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        VerifyPdfSignaturesRequest.Builder req = VerifyPdfSignaturesRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList resultChunks = new ArrayList();
        client.stub.pdfDocumentSignatureVerifiedSignatures(req.build(), new Utils_ReceivingCustomStreamObserver<BooleanResult>(finishLatch, resultChunks));
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        if (resultChunks.size() == 0) {
            throw new RuntimeException("No response from IronPdf.");
        }
        BooleanResult res = (BooleanResult)resultChunks.stream().findFirst().get();
        return Utils_Util.handleBooleanResult(res);
    }
}

