/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text;

import com.lowagie2.text.Paragraph;
import com.lowagie2.text.Section;
import com.lowagie2.text.TextElementArray;
import java.util.ArrayList;
import java.util.Properties;

public class Chapter
extends Section
implements TextElementArray {
    public Chapter(Properties attributes, int number) {
        this(new Paragraph(""), number);
        String value = (String)attributes.remove("numberdepth");
        if (value != null) {
            this.setNumberDepth(Integer.parseInt(value));
        }
        if ((value = (String)attributes.remove("indent")) != null) {
            this.setIndentation(Float.valueOf(value + "f").floatValue());
        }
        if ((value = (String)attributes.remove("indentationleft")) != null) {
            this.setIndentationLeft(Float.valueOf(value + "f").floatValue());
        }
        if ((value = (String)attributes.remove("indentationright")) != null) {
            this.setIndentationRight(Float.valueOf(value + "f").floatValue());
        }
    }

    public Chapter(String title, int number) {
        this(new Paragraph(title), number);
    }

    public Chapter(Paragraph title, int number) {
        super(title, 1);
        this.numbers = new ArrayList();
        this.numbers.add(new Integer(number));
    }

    public static boolean isTag(String tag) {
        return "chapter".equals(tag);
    }

    public int type() {
        return 16;
    }
}

