/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Element;
import com.lowagie2.text.ElementListener;
import com.lowagie2.text.FontFactory;
import com.lowagie2.text.ListItem;
import com.lowagie2.text.MarkupAttributes;
import com.lowagie2.text.TextElementArray;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class List
implements TextElementArray,
MarkupAttributes {
    public static final boolean ALPHABETICAL = true;
    public static final boolean NUMBERICAL = false;
    public static final boolean ORDERED = true;
    public static final boolean UNORDERED = false;
    protected int first = 1;
    protected char firstCh;
    protected float indentationLeft = 0.0f;
    protected float indentationRight = 0.0f;
    protected char lastCh;
    protected boolean lettered;
    protected ArrayList list = new ArrayList();
    protected Properties markupAttributes;
    protected boolean numbered;
    protected Chunk symbol;
    protected float symbolIndent;

    public List(Properties attributes) {
        this.firstCh = (char)65;
        this.lastCh = (char)90;
        this.symbol = new Chunk("-");
        String value = (String)attributes.remove("listsymbol");
        if (value == null) {
            value = "-";
        }
        this.symbol = new Chunk(value, FontFactory.getFont(attributes));
        this.numbered = false;
        value = (String)attributes.remove("numbered");
        if (value != null) {
            this.numbered = new Boolean(value);
            if (this.lettered && this.numbered) {
                this.lettered = false;
            }
        }
        if ((value = (String)attributes.remove("lettered")) != null) {
            this.lettered = new Boolean(value);
            if (this.numbered && this.lettered) {
                this.numbered = false;
            }
        }
        this.symbolIndent = 0.0f;
        value = (String)attributes.remove("symbolindent");
        if (value != null) {
            this.symbolIndent = Float.parseFloat(value);
        }
        if ((value = (String)attributes.remove("first")) != null) {
            char khar = value.charAt(0);
            if (Character.isLetter(khar)) {
                this.setFirst(khar);
            } else {
                this.setFirst(Integer.parseInt(value));
            }
        }
        if ((value = (String)attributes.remove("indentationleft")) != null) {
            this.setIndentationLeft(Float.valueOf(value + "f").floatValue());
        }
        if ((value = (String)attributes.remove("indentationright")) != null) {
            this.setIndentationRight(Float.valueOf(value + "f").floatValue());
        }
        if (attributes.size() > 0) {
            this.setMarkupAttributes(attributes);
        }
    }

    public List(boolean numbered, boolean lettered, float symbolIndent) {
        this.firstCh = (char)65;
        this.lastCh = (char)90;
        this.symbol = new Chunk("-");
        this.numbered = numbered;
        this.lettered = lettered;
        this.symbolIndent = symbolIndent;
    }

    public List(boolean numbered, float symbolIndent) {
        this.firstCh = (char)65;
        this.lastCh = (char)90;
        this.symbol = new Chunk("-");
        this.numbered = numbered;
        this.lettered = false;
        this.symbolIndent = symbolIndent;
    }

    public boolean add(Object o) {
        if (o instanceof ListItem) {
            ListItem item = (ListItem)o;
            if (this.numbered || this.lettered) {
                Chunk chunk = this.lettered ? new Chunk(this.nextLetter(), this.symbol.font()) : new Chunk(String.valueOf(this.first + this.list.size()), this.symbol.font());
                chunk.append(".");
                item.setListSymbol(chunk);
            } else {
                item.setListSymbol(this.symbol);
            }
            item.setIndentationLeft(this.symbolIndent);
            item.setIndentationRight(0.0f);
            this.list.add(item);
        } else {
            if (o instanceof List) {
                List nested = (List)o;
                nested.setIndentationLeft(nested.indentationLeft() + this.symbolIndent);
                --this.first;
                return this.list.add(nested);
            }
            if (o instanceof String) {
                return this.add(new ListItem((String)o));
            }
        }
        return false;
    }

    public int first() {
        return this.first;
    }

    public ArrayList getChunks() {
        ArrayList tmp = new ArrayList();
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            tmp.addAll(((Element)i.next()).getChunks());
        }
        return tmp;
    }

    public ArrayList getItems() {
        return this.list;
    }

    public String getMarkupAttribute(String name) {
        return this.markupAttributes == null ? null : String.valueOf(this.markupAttributes.get(name));
    }

    public Set getMarkupAttributeNames() {
        return Chunk.getKeySet(this.markupAttributes);
    }

    public Properties getMarkupAttributes() {
        return this.markupAttributes;
    }

    public float indentationLeft() {
        return this.indentationLeft;
    }

    public float indentationRight() {
        return this.indentationRight;
    }

    public boolean isNumbered() {
        return this.numbered;
    }

    public static boolean isSymbol(String tag) {
        return "listsymbol".equals(tag);
    }

    public static boolean isTag(String tag) {
        return "list".equals(tag);
    }

    public float leading() {
        if (this.list.size() < 1) {
            return -1.0f;
        }
        ListItem item = (ListItem)this.list.get(0);
        return item.leading();
    }

    private int listItemsInList() {
        int result = 0;
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof List) continue;
            ++result;
        }
        return result;
    }

    private String nextLetter() {
        int num_in_list = this.listItemsInList();
        int max_ival = this.lastCh + '\u0000';
        int ival = this.firstCh + num_in_list;
        while (ival > max_ival) {
            ival -= 26;
        }
        char[] new_char = new char[]{(char)ival};
        String ret = new String(new_char);
        return ret;
    }

    public boolean process(ElementListener listener) {
        try {
            Iterator i = this.list.iterator();
            while (i.hasNext()) {
                listener.add((Element)i.next());
            }
            return true;
        }
        catch (DocumentException de) {
            return false;
        }
    }

    public void setFirst(char first) {
        this.firstCh = first;
        this.lastCh = Character.isLowerCase(this.firstCh) ? (char)122 : (char)90;
    }

    public void setFirst(int first) {
        this.first = first;
    }

    public void setIndentationLeft(float indentation) {
        this.indentationLeft = indentation;
    }

    public void setIndentationRight(float indentation) {
        this.indentationRight = indentation;
    }

    public void setListSymbol(String symbol) {
        this.symbol = new Chunk(symbol);
    }

    public void setListSymbol(Chunk symbol) {
        this.symbol = symbol;
    }

    public void setMarkupAttribute(String name, String value) {
        if (this.markupAttributes == null) {
            this.markupAttributes = new Properties();
        }
        this.markupAttributes.put(name, value);
    }

    public void setMarkupAttributes(Properties markupAttributes) {
        this.markupAttributes = markupAttributes;
    }

    public int size() {
        return this.list.size();
    }

    public Chunk symbol() {
        return this.symbol;
    }

    public float symbolIndent() {
        return this.symbolIndent;
    }

    public int type() {
        return 14;
    }
}

