/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.html;

import com.lowagie2.text.Cell;
import com.lowagie2.text.DocListener;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Element;
import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.Paragraph;
import com.lowagie2.text.Table;
import com.lowagie2.text.html.HtmlTagMap;
import com.lowagie2.text.pdf.BaseFont;
import com.lowagie2.text.xml.SAXiTextHandler;
import com.lowagie2.text.xml.XmlPeer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.Attributes;

public class SAXmyHtmlHandler
extends SAXiTextHandler {
    private Properties bodyAttributes = new Properties();
    private boolean tableBorder = false;

    public SAXmyHtmlHandler(DocListener document, HashMap htmlTags) throws DocumentException, IOException {
        super(document, htmlTags);
    }

    public SAXmyHtmlHandler(DocListener document, BaseFont bf) throws DocumentException, IOException {
        super(document, new HtmlTagMap(), bf);
    }

    public SAXmyHtmlHandler(DocListener document) throws DocumentException, IOException {
        super(document, new HtmlTagMap());
    }

    public void endElement(String uri, String lname, String name) {
        if (Paragraph.isTag(name = name.toLowerCase())) {
            try {
                this.document.add((Element)this.stack.pop());
                return;
            }
            catch (DocumentException e) {
                throw new ExceptionConverter(e);
            }
        }
        if (((HtmlTagMap)this.myTags).isHead(name)) {
            return;
        }
        if (((HtmlTagMap)this.myTags).isTitle(name)) {
            if (this.currentChunk != null) {
                this.bodyAttributes.put("title", this.currentChunk.content());
            }
            return;
        }
        if (((HtmlTagMap)this.myTags).isMeta(name)) {
            return;
        }
        if (((HtmlTagMap)this.myTags).isLink(name)) {
            return;
        }
        if (((HtmlTagMap)this.myTags).isBody(name)) {
            return;
        }
        if (this.myTags.containsKey(name)) {
            XmlPeer peer = (XmlPeer)this.myTags.get(name);
            if (Table.isTag(peer.getTag())) {
                this.tableBorder = false;
            }
            super.handleEndingTags(peer.getTag());
            return;
        }
        this.handleEndingTags(name);
    }

    public void startElement(String uri, String lname, String name, Attributes attrs) {
        if (((HtmlTagMap)this.myTags).isHtml(name = name.toLowerCase())) {
            return;
        }
        if (((HtmlTagMap)this.myTags).isHead(name)) {
            return;
        }
        if (((HtmlTagMap)this.myTags).isTitle(name)) {
            return;
        }
        if (((HtmlTagMap)this.myTags).isMeta(name)) {
            String meta = null;
            String content = null;
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    String attribute = attrs.getQName(i);
                    if (attribute.equalsIgnoreCase("content")) {
                        content = attrs.getValue(i);
                    } else if (attribute.equalsIgnoreCase("name")) {
                        meta = attrs.getValue(i);
                    }
                    ++i;
                }
            }
            if (meta != null && content != null) {
                this.bodyAttributes.put(meta, content);
            }
            return;
        }
        if (((HtmlTagMap)this.myTags).isLink(name)) {
            return;
        }
        if (((HtmlTagMap)this.myTags).isBody(name)) {
            XmlPeer peer = new XmlPeer("itext", name);
            peer.addAlias("top", "topmargin");
            peer.addAlias("bottom", "bottommargin");
            peer.addAlias("right", "rightmargin");
            peer.addAlias("left", "leftmargin");
            Object content = null;
            this.bodyAttributes.putAll((Map<?, ?>)peer.getAttributes(attrs));
            this.handleStartingTags(peer.getTag(), this.bodyAttributes);
            return;
        }
        if (this.myTags.containsKey(name)) {
            XmlPeer peer = (XmlPeer)this.myTags.get(name);
            if (Table.isTag(peer.getTag()) || Cell.isTag(peer.getTag())) {
                String value;
                Properties p = peer.getAttributes(attrs);
                if (Table.isTag(peer.getTag()) && (value = p.getProperty("borderwidth")) != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (Float.valueOf(stringBuffer.append(value).append("f").toString()).floatValue() > 0.0f) {
                        this.tableBorder = true;
                    }
                }
                if (this.tableBorder) {
                    p.put("left", String.valueOf(true));
                    p.put("right", String.valueOf(true));
                    p.put("top", String.valueOf(true));
                    p.put("bottom", String.valueOf(true));
                }
                this.handleStartingTags(peer.getTag(), p);
                return;
            }
            this.handleStartingTags(peer.getTag(), peer.getAttributes(attrs));
            return;
        }
        Properties attributes = new Properties();
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                String attribute = attrs.getQName(i).toLowerCase();
                attributes.setProperty(attribute, attrs.getValue(i).toLowerCase());
                ++i;
            }
        }
        this.handleStartingTags(name, attributes);
    }
}

