/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.html.simpleparser;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.Font;
import com.lowagie2.text.FontFactory;
import com.lowagie2.text.FontFactoryImp;
import com.lowagie2.text.ListItem;
import com.lowagie2.text.Paragraph;
import com.lowagie2.text.html.simpleparser.ChainedProperties;
import java.awt.Color;
import java.util.HashMap;
import java.util.StringTokenizer;

public class FactoryProperties {
    public static HashMap colorTable = new HashMap();
    public static HashMap followTags = new HashMap();
    private FontFactoryImp fontImp;

    static {
        followTags.put("i", "i");
        followTags.put("b", "b");
        followTags.put("u", "u");
        followTags.put("sub", "sub");
        followTags.put("sup", "sup");
        followTags.put("em", "i");
        followTags.put("strong", "b");
        colorTable.put("black", new Color(0));
        colorTable.put("green", new Color(32768));
        colorTable.put("silver", new Color(0xC0C0C0));
        colorTable.put("lime", new Color(65280));
        colorTable.put("gray", new Color(0x808080));
        colorTable.put("olive", new Color(0x808000));
        colorTable.put("white", new Color(0xFFFFFF));
        colorTable.put("yellow", new Color(0xFFFF00));
        colorTable.put("maroon", new Color(0x800000));
        colorTable.put("navy", new Color(128));
        colorTable.put("red", new Color(0xFF0000));
        colorTable.put("blue", new Color(255));
        colorTable.put("purple", new Color(0x800080));
        colorTable.put("teal", new Color(32896));
        colorTable.put("fuchsia", new Color(0xFF00FF));
        colorTable.put("aqua", new Color(65535));
    }

    public Chunk createChunk(String text, ChainedProperties props) {
        Chunk ck = new Chunk(text, this.getFont(props));
        if (props.hasProperty("sub")) {
            ck.setTextRise(-6.0f);
        } else if (props.hasProperty("sup")) {
            ck.setTextRise(6.0f);
        }
        return ck;
    }

    public static ListItem createListItem(ChainedProperties props) {
        ListItem p = new ListItem();
        FactoryProperties.createParagraph(p, props);
        return p;
    }

    public static Paragraph createParagraph(ChainedProperties props) {
        Paragraph p = new Paragraph();
        FactoryProperties.createParagraph(p, props);
        return p;
    }

    public static void createParagraph(Paragraph p, ChainedProperties props) {
        String value = props.getProperty("align");
        if (value != null) {
            if (value.equalsIgnoreCase("center")) {
                p.setAlignment(1);
            } else if (value.equalsIgnoreCase("right")) {
                p.setAlignment(2);
            } else if (value.equalsIgnoreCase("justify")) {
                p.setAlignment(3);
            }
        }
        FactoryProperties.setParagraphLeading(p, props.getProperty("leading"));
        value = props.getProperty("before");
        if (value != null) {
            try {
                p.setSpacingBefore(Float.valueOf(value).floatValue());
            }
            catch (Exception e) {
            }
        }
        if ((value = props.getProperty("after")) != null) {
            try {
                p.setSpacingAfter(Float.valueOf(value).floatValue());
            }
            catch (Exception e) {
            }
        }
        if ((value = props.getProperty("extraparaspace")) != null) {
            try {
                p.setExtraParagraphSpace(Float.valueOf(value).floatValue());
            }
            catch (Exception e) {
            }
        }
    }

    public static Paragraph createParagraph(HashMap props) {
        Paragraph p = new Paragraph();
        String value = (String)props.get("align");
        if (value != null) {
            if (value.equalsIgnoreCase("center")) {
                p.setAlignment(1);
            } else if (value.equalsIgnoreCase("right")) {
                p.setAlignment(2);
            } else if (value.equalsIgnoreCase("justify")) {
                p.setAlignment(3);
            }
        }
        FactoryProperties.setParagraphLeading(p, (String)props.get("leading"));
        return p;
    }

    public static Color decodeColor(String s) {
        if (s == null) {
            return null;
        }
        Color c = (Color)colorTable.get(s = s.toLowerCase().trim());
        if (c != null) {
            return c;
        }
        try {
            if (s.startsWith("#")) {
                return new Color(Integer.parseInt(s.substring(1), 16));
            }
        }
        catch (Exception e) {}
        return null;
    }

    public Font getFont(ChainedProperties props) {
        FontFactoryImp ff;
        String face = props.getProperty("face");
        if (face != null) {
            StringTokenizer tok = new StringTokenizer(face, ",");
            while (tok.hasMoreTokens()) {
                face = tok.nextToken().trim();
                if (FontFactory.isRegistered(face)) break;
            }
        }
        int style = 0;
        if (props.hasProperty("i")) {
            style |= 2;
        }
        if (props.hasProperty("b")) {
            style |= 1;
        }
        if (props.hasProperty("u")) {
            style |= 4;
        }
        String value = props.getProperty("size");
        float size = 12.0f;
        if (value != null) {
            size = Float.valueOf(value).floatValue();
        }
        Color color = FactoryProperties.decodeColor(props.getProperty("color"));
        String encoding = props.getProperty("encoding");
        if (encoding == null) {
            encoding = "Cp1252";
        }
        if ((ff = this.fontImp) == null) {
            ff = FontFactory.getFontImp();
        }
        return ff.getFont(face, encoding, true, size, style, color);
    }

    public FontFactoryImp getFontImp() {
        return this.fontImp;
    }

    public void setFontImp(FontFactoryImp fontImp) {
        this.fontImp = fontImp;
    }

    private static void setParagraphLeading(Paragraph p, String leading) {
        if (leading == null) {
            p.setLeading(0.0f, 1.5f);
            return;
        }
        try {
            StringTokenizer tk = new StringTokenizer(leading, " ,");
            String v = tk.nextToken();
            float v1 = Float.valueOf(v).floatValue();
            if (!tk.hasMoreTokens()) {
                p.setLeading(v1, 0.0f);
                return;
            }
            v = tk.nextToken();
            float v2 = Float.valueOf(v).floatValue();
            p.setLeading(v1, v2);
        }
        catch (Exception e) {
            p.setLeading(0.0f, 1.5f);
        }
    }
}

