/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.BaseFont;
import com.lowagie2.text.pdf.PdfAppearance;
import com.lowagie2.text.pdf.PdfContentByte;
import com.lowagie2.text.pdf.PdfCopyFieldsImp;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class BaseField {
    public static final float BORDER_WIDTH_MEDIUM = 2.0f;
    public static final float BORDER_WIDTH_THICK = 3.0f;
    public static final float BORDER_WIDTH_THIN = 1.0f;
    public static final int COMB = 256;
    public static final int DO_NOT_SCROLL = 8;
    public static final int DO_NOT_SPELL_CHECK = 64;
    public static final int EDIT = 128;
    public static final int FILE_SELECTION = 32;
    public static final int HIDDEN = 1;
    public static final int HIDDEN_BUT_PRINTABLE = 3;
    public static final int MULTILINE = 4;
    public static final int PASSWORD = 16;
    public static final int READ_ONLY = 1;
    public static final int REQUIRED = 2;
    public static final int VISIBLE = 0;
    public static final int VISIBLE_BUT_DOES_NOT_PRINT = 2;
    protected int alignment = 0;
    protected Color backgroundColor;
    protected Color borderColor;
    protected int borderStyle = 0;
    protected float borderWidth = 1.0f;
    protected Rectangle box;
    private static final HashMap fieldKeys = new HashMap();
    protected String fieldName;
    protected BaseFont font;
    protected float fontSize = 0.0f;
    protected int maxCharacterLength;
    protected int options;
    protected int rotation = 0;
    protected String text;
    protected Color textColor;
    protected int visibility;
    protected PdfWriter writer;

    static {
        fieldKeys.putAll(PdfCopyFieldsImp.fieldKeys);
        fieldKeys.put(PdfName.T, new Integer(1));
    }

    public BaseField(PdfWriter writer, Rectangle box, String fieldName) {
        this.writer = writer;
        this.box = box;
        this.fieldName = fieldName;
    }

    protected static ArrayList breakLines(ArrayList breaks, BaseFont font, float fontSize, float width) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        int ck = 0;
        while (ck < breaks.size()) {
            buf.setLength(0);
            float w = 0.0f;
            char[] cs = ((String)breaks.get(ck)).toCharArray();
            int len = cs.length;
            int state = 0;
            int lastspace = -1;
            char c = '\u0000';
            int refk = 0;
            int k = 0;
            while (k < len) {
                c = cs[k];
                switch (state) {
                    case 0: {
                        w += font.getWidthPoint(c, fontSize);
                        buf.append(c);
                        if (w > width) {
                            w = 0.0f;
                            if (buf.length() > 1) {
                                buf.setLength(buf.length() - 1);
                            }
                            lines.add(buf.toString());
                            buf.setLength(0);
                            refk = --k;
                            if (c == ' ') {
                                state = 2;
                                break;
                            }
                            state = 1;
                            break;
                        }
                        if (c != ' ') {
                            state = 1;
                        }
                        break;
                    }
                    case 1: {
                        w += font.getWidthPoint(c, fontSize);
                        buf.append(c);
                        if (c == ' ') {
                            lastspace = k;
                        }
                        if (!(w > width)) break;
                        w = 0.0f;
                        if (lastspace >= 0) {
                            k = lastspace;
                            buf.setLength(lastspace - refk);
                            BaseField.trimRight(buf);
                            lines.add(buf.toString());
                            buf.setLength(0);
                            refk = k;
                            lastspace = -1;
                            state = 2;
                            break;
                        }
                        if (buf.length() > 1) {
                            buf.setLength(buf.length() - 1);
                        }
                        lines.add(buf.toString());
                        buf.setLength(0);
                        refk = --k;
                        if (c == ' ') {
                            state = 2;
                        }
                        break;
                    }
                    case 2: {
                        if (c == ' ') break;
                        w = 0.0f;
                        --k;
                        state = 1;
                    }
                }
                ++k;
            }
            BaseField.trimRight(buf);
            lines.add(buf.toString());
            ++ck;
        }
        return lines;
    }

    private void drawBottomFrame(PdfAppearance app) {
        app.moveTo(this.borderWidth, this.borderWidth);
        app.lineTo(this.box.width() - this.borderWidth, this.borderWidth);
        app.lineTo(this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
        app.lineTo(this.box.width() - 2.0f * this.borderWidth, this.box.height() - 2.0f * this.borderWidth);
        app.lineTo(this.box.width() - 2.0f * this.borderWidth, 2.0f * this.borderWidth);
        app.lineTo(2.0f * this.borderWidth, 2.0f * this.borderWidth);
        app.lineTo(this.borderWidth, this.borderWidth);
        app.fill();
    }

    private void drawTopFrame(PdfAppearance app) {
        app.moveTo(this.borderWidth, this.borderWidth);
        app.lineTo(this.borderWidth, this.box.height() - this.borderWidth);
        app.lineTo(this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
        app.lineTo(this.box.width() - 2.0f * this.borderWidth, this.box.height() - 2.0f * this.borderWidth);
        app.lineTo(2.0f * this.borderWidth, this.box.height() - 2.0f * this.borderWidth);
        app.lineTo(2.0f * this.borderWidth, 2.0f * this.borderWidth);
        app.lineTo(this.borderWidth, this.borderWidth);
        app.fill();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    protected PdfAppearance getBorderAppearance() throws IOException, DocumentException {
        PdfAppearance app = new PdfContentByte(this.writer).createAppearance(this.box.width(), this.box.height());
        switch (this.rotation) {
            case 90: {
                app.setMatrix(0.0f, 1.0f, -1.0f, 0.0f, this.box.height(), 0.0f);
                break;
            }
            case 180: {
                app.setMatrix(-1.0f, 0.0f, 0.0f, -1.0f, this.box.width(), this.box.height());
                break;
            }
            case 270: {
                app.setMatrix(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, this.box.width());
            }
        }
        if (this.backgroundColor != null) {
            app.setColorFill(this.backgroundColor);
            app.rectangle(0.0f, 0.0f, this.box.width(), this.box.height());
            app.fill();
        }
        if (this.borderStyle == 4) {
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                app.setColorStroke(this.borderColor);
                app.setLineWidth(this.borderWidth);
                app.moveTo(0.0f, this.borderWidth / 2.0f);
                app.lineTo(this.box.width(), this.borderWidth / 2.0f);
                app.stroke();
            }
        } else if (this.borderStyle == 2) {
            Color actual;
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                app.setColorStroke(this.borderColor);
                app.setLineWidth(this.borderWidth);
                app.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
                app.stroke();
            }
            if ((actual = this.backgroundColor) == null) {
                actual = Color.white;
            }
            app.setGrayFill(1.0f);
            this.drawTopFrame(app);
            app.setColorFill(actual.darker());
            this.drawBottomFrame(app);
        } else if (this.borderStyle == 3) {
            if (this.borderWidth != 0.0f && this.borderColor != null) {
                app.setColorStroke(this.borderColor);
                app.setLineWidth(this.borderWidth);
                app.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
                app.stroke();
            }
            app.setGrayFill(0.5f);
            this.drawTopFrame(app);
            app.setGrayFill(0.75f);
            this.drawBottomFrame(app);
        } else if (this.borderWidth != 0.0f && this.borderColor != null) {
            if (this.borderStyle == 1) {
                app.setLineDash(3.0f, 0.0f);
            }
            app.setColorStroke(this.borderColor);
            app.setLineWidth(this.borderWidth);
            app.rectangle(this.borderWidth / 2.0f, this.borderWidth / 2.0f, this.box.width() - this.borderWidth, this.box.height() - this.borderWidth);
            app.stroke();
            if ((this.options & 0x100) != 0 && this.maxCharacterLength > 1) {
                float step = this.box.width() / (float)this.maxCharacterLength;
                float yb = this.borderWidth / 2.0f;
                float yt = this.box.height() - this.borderWidth / 2.0f;
                int k = 1;
                while (k < this.maxCharacterLength) {
                    float x = step * (float)k;
                    app.moveTo(x, yb);
                    app.lineTo(x, yt);
                    ++k;
                }
                app.stroke();
            }
        }
        return app;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public Rectangle getBox() {
        return this.box;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public BaseFont getFont() {
        return this.font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    protected static ArrayList getHardBreaks(String text) {
        ArrayList<String> arr = new ArrayList<String>();
        char[] cs = text.toCharArray();
        int len = cs.length;
        StringBuffer buf = new StringBuffer();
        int k = 0;
        while (k < len) {
            char c = cs[k];
            if (c == '\r') {
                if (k + 1 < len && cs[k + 1] == '\n') {
                    ++k;
                }
                arr.add(buf.toString());
                buf = new StringBuffer();
            } else if (c == '\n') {
                arr.add(buf.toString());
                buf = new StringBuffer();
            } else {
                buf.append(c);
            }
            ++k;
        }
        arr.add(buf.toString());
        return arr;
    }

    public int getMaxCharacterLength() {
        return this.maxCharacterLength;
    }

    public int getOptions() {
        return this.options;
    }

    protected BaseFont getRealFont() throws IOException, DocumentException {
        if (this.font == null) {
            return BaseFont.createFont("Helvetica", "Cp1252", false);
        }
        return this.font;
    }

    public int getRotation() {
        return this.rotation;
    }

    public String getText() {
        return this.text;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public PdfWriter getWriter() {
        return this.writer;
    }

    public static void moveFields(PdfDictionary from, PdfDictionary to) {
        Iterator i = from.getKeys().iterator();
        while (i.hasNext()) {
            PdfName key = (PdfName)i.next();
            if (!fieldKeys.containsKey(key)) continue;
            if (to != null) {
                to.put(key, from.get(key));
            }
            i.remove();
        }
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setBorderStyle(int borderStyle) {
        this.borderStyle = borderStyle;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
    }

    public void setBox(Rectangle box) {
        this.box = box;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setFont(BaseFont font) {
        this.font = font;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public void setMaxCharacterLength(int maxCharacterLength) {
        this.maxCharacterLength = maxCharacterLength;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public void setRotation(int rotation) {
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("Rotation must be a multiple of 90.");
        }
        if ((rotation %= 360) < 0) {
            rotation += 360;
        }
        this.rotation = rotation;
    }

    public void setRotationFromPage(Rectangle page) {
        this.setRotation(page.getRotation());
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setVisibility(int visibility) {
        this.visibility = visibility;
    }

    public void setWriter(PdfWriter writer) {
        this.writer = writer;
    }

    protected static void trimRight(StringBuffer buf) {
        int len = buf.length();
        while (len != 0) {
            if (buf.charAt(--len) != ' ') {
                return;
            }
            buf.setLength(len);
        }
        return;
    }
}

