/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.DocumentException;
import com.lowagie2.text.pdf.RandomAccessFileOrArray;
import com.lowagie2.text.pdf.TrueTypeFont;
import java.io.IOException;
import java.util.HashMap;

class EnumerateTTC
extends TrueTypeFont {
    protected String[] names;

    EnumerateTTC(byte[] ttcArray) throws DocumentException, IOException {
        this.fileName = "Byte array TTC";
        this.rf = new RandomAccessFileOrArray(ttcArray);
        this.findNames();
    }

    EnumerateTTC(String ttcFile) throws DocumentException, IOException {
        this.fileName = ttcFile;
        this.rf = new RandomAccessFileOrArray(ttcFile);
        this.findNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void findNames() throws DocumentException, IOException {
        this.tables = new HashMap();
        try {
            String mainTag = this.readStandardString(4);
            if (!mainTag.equals("ttcf")) {
                throw new DocumentException(this.fileName + " is not a valid TTC file.");
            }
            this.rf.skipBytes(4);
            int dirCount = this.rf.readInt();
            this.names = new String[dirCount];
            int dirPos = this.rf.getFilePointer();
            int dirIdx = 0;
            while (dirIdx < dirCount) {
                this.tables.clear();
                this.rf.seek(dirPos);
                this.rf.skipBytes(dirIdx * 4);
                this.directoryOffset = this.rf.readInt();
                this.rf.seek(this.directoryOffset);
                if (this.rf.readInt() != 65536) {
                    throw new DocumentException(this.fileName + " is not a valid TTF file.");
                }
                int num_tables = this.rf.readUnsignedShort();
                this.rf.skipBytes(6);
                int k = 0;
                while (k < num_tables) {
                    String tag = this.readStandardString(4);
                    this.rf.skipBytes(4);
                    int[] table_location = new int[]{this.rf.readInt(), this.rf.readInt()};
                    this.tables.put(tag, table_location);
                    ++k;
                }
                this.names[dirIdx] = this.getBaseFont();
                ++dirIdx;
            }
            Object var10_9 = null;
            if (this.rf == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (this.rf == null) throw throwable;
            this.rf.close();
            throw throwable;
        }
        this.rf.close();
    }

    String[] getNames() {
        return this.names;
    }
}

