/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.pdf.PRIndirectReference;
import com.lowagie2.text.pdf.PdfArray;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.text.pdf.PdfString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class PRAcroForm
extends PdfDictionary {
    HashMap fieldByName;
    ArrayList fields;
    PdfReader reader;
    ArrayList stack;

    public PRAcroForm(PdfReader reader) {
        this.reader = reader;
        this.fields = new ArrayList();
        this.fieldByName = new HashMap();
        this.stack = new ArrayList();
    }

    public FieldInformation getField(String name) {
        return (FieldInformation)this.fieldByName.get(name);
    }

    public ArrayList getFields() {
        return this.fields;
    }

    public PRIndirectReference getRefByName(String name) {
        FieldInformation fi = (FieldInformation)this.fieldByName.get(name);
        if (fi == null) {
            return null;
        }
        return fi.getRef();
    }

    protected void iterateFields(PdfArray fieldlist, PRIndirectReference fieldDict, String title) {
        Iterator it = fieldlist.getArrayList().iterator();
        while (it.hasNext()) {
            PdfArray kids;
            boolean isFieldDict;
            PRIndirectReference ref = (PRIndirectReference)it.next();
            PdfDictionary dict = (PdfDictionary)PdfReader.getPdfObjectRelease(ref);
            PRIndirectReference myFieldDict = fieldDict;
            String myTitle = title;
            PdfString tField = (PdfString)dict.get(PdfName.T);
            boolean bl = isFieldDict = tField != null;
            if (isFieldDict) {
                myFieldDict = ref;
                myTitle = title == null ? tField.toString() : title + '.' + tField.toString();
            }
            if ((kids = (PdfArray)dict.get(PdfName.KIDS)) != null) {
                this.pushAttrib(dict);
                this.iterateFields(kids, myFieldDict, myTitle);
                this.stack.remove(this.stack.size() - 1);
                continue;
            }
            if (myFieldDict == null) continue;
            PdfDictionary mergedDict = (PdfDictionary)this.stack.get(this.stack.size() - 1);
            if (isFieldDict) {
                mergedDict = this.mergeAttrib(mergedDict, dict);
            }
            mergedDict.put(PdfName.T, new PdfString(myTitle));
            FieldInformation fi = new FieldInformation(myTitle, mergedDict, myFieldDict);
            this.fields.add(fi);
            this.fieldByName.put(myTitle, fi);
        }
    }

    protected PdfDictionary mergeAttrib(PdfDictionary parent, PdfDictionary child) {
        PdfDictionary targ = new PdfDictionary();
        if (parent != null) {
            targ.putAll(parent);
        }
        Iterator it = child.getKeys().iterator();
        while (it.hasNext()) {
            PdfName key = (PdfName)it.next();
            if (!key.equals(PdfName.DR) && !key.equals(PdfName.DA) && !key.equals(PdfName.Q) && !key.equals(PdfName.FF) && !key.equals(PdfName.DV) && !key.equals(PdfName.V) && !key.equals(PdfName.FT) && !key.equals(PdfName.F)) continue;
            targ.put(key, child.get(key));
        }
        return targ;
    }

    protected void pushAttrib(PdfDictionary dict) {
        PdfDictionary dic = null;
        if (this.stack.size() != 0) {
            dic = (PdfDictionary)this.stack.get(this.stack.size() - 1);
        }
        dic = this.mergeAttrib(dic, dict);
        this.stack.add(dic);
    }

    public void readAcroForm(PdfDictionary root) {
        this.hashMap = root.hashMap;
        this.pushAttrib(root);
        PdfArray fieldlist = (PdfArray)PdfReader.getPdfObjectRelease(root.get(PdfName.FIELDS));
        this.iterateFields(fieldlist, null, null);
    }

    public int size() {
        return this.fields.size();
    }

    public static class FieldInformation {
        PdfDictionary info;
        String name;
        PRIndirectReference ref;

        FieldInformation(String name, PdfDictionary info, PRIndirectReference ref) {
            this.name = name;
            this.info = info;
            this.ref = ref;
        }

        public PdfDictionary getInfo() {
            return this.info;
        }

        public String getName() {
            return this.name;
        }

        public PRIndirectReference getRef() {
            return this.ref;
        }
    }
}

