/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.Font;
import com.lowagie2.text.Image;
import com.lowagie2.text.SplitCharacter;
import com.lowagie2.text.pdf.BaseFont;
import com.lowagie2.text.pdf.HyphenationEvent;
import com.lowagie2.text.pdf.PdfAction;
import com.lowagie2.text.pdf.PdfFont;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;

public class PdfChunk
implements SplitCharacter {
    private static final float ITALIC_ANGLE = 0.21256f;
    protected HashMap attributes = new HashMap();
    protected BaseFont baseFont;
    protected boolean changeLeading = false;
    protected String encoding = "Cp1252";
    protected PdfFont font;
    protected Image image;
    private static final HashMap keysAttributes;
    private static final HashMap keysNoStroke;
    protected boolean newlineSplit;
    protected HashMap noStroke = new HashMap();
    protected float offsetX;
    protected float offsetY;
    private static final char[] singleSpace;
    protected SplitCharacter splitCharacter;
    private static final PdfChunk[] thisChunk;
    protected String value = "";

    static {
        singleSpace = new char[]{' '};
        thisChunk = new PdfChunk[1];
        keysAttributes = new HashMap();
        keysNoStroke = new HashMap();
        keysAttributes.put("ACTION", null);
        keysAttributes.put("UNDERLINE", null);
        keysAttributes.put("REMOTEGOTO", null);
        keysAttributes.put("LOCALGOTO", null);
        keysAttributes.put("LOCALDESTINATION", null);
        keysAttributes.put("GENERICTAG", null);
        keysAttributes.put("NEWPAGE", null);
        keysAttributes.put("IMAGE", null);
        keysAttributes.put("BACKGROUND", null);
        keysAttributes.put("PDFANNOTATION", null);
        keysAttributes.put("SKEW", null);
        keysAttributes.put("HSCALE", null);
        keysNoStroke.put("SUBSUPSCRIPT", null);
        keysNoStroke.put("SPLITCHARACTER", null);
        keysNoStroke.put("HYPHENATION", null);
        keysNoStroke.put("TEXTRENDERMODE", null);
    }

    PdfChunk(Chunk chunk, PdfAction action) {
        Object[][] unders;
        Object[] obj;
        PdfChunk.thisChunk[0] = this;
        this.value = chunk.content();
        Font f = chunk.font();
        float size = f.size();
        if (size == -1.0f) {
            size = 12.0f;
        }
        this.baseFont = f.getBaseFont();
        int style = f.style();
        if (style == -1) {
            style = 0;
        }
        if (this.baseFont == null) {
            this.baseFont = f.getCalculatedBaseFont(false);
        } else {
            if ((style & 1) != 0) {
                this.attributes.put("TEXTRENDERMODE", new Object[]{new Integer(2), new Float(size / 30.0f), null});
            }
            if ((style & 2) != 0) {
                this.attributes.put("SKEW", new float[]{0.0f, 0.21256f});
            }
        }
        this.font = new PdfFont(this.baseFont, size);
        HashMap attr = chunk.getAttributes();
        if (attr != null) {
            Iterator i = attr.keySet().iterator();
            while (i.hasNext()) {
                Object name = i.next();
                if (keysAttributes.containsKey(name)) {
                    this.attributes.put(name, attr.get(name));
                    continue;
                }
                if (!keysNoStroke.containsKey(name)) continue;
                this.noStroke.put(name, attr.get(name));
            }
            if ("".equals(attr.get("GENERICTAG"))) {
                this.attributes.put("GENERICTAG", chunk.content());
            }
        }
        if (f.isUnderlined()) {
            obj = new Object[]{null, new float[]{0.0f, 0.06666667f, 0.0f, -0.33333334f, 0.0f}};
            unders = Chunk.addToArray((Object[][])this.attributes.get("UNDERLINE"), obj);
            this.attributes.put("UNDERLINE", unders);
        }
        if (f.isStrikethru()) {
            obj = new Object[]{null, new float[]{0.0f, 0.06666667f, 0.0f, 0.33333334f, 0.0f}};
            unders = Chunk.addToArray((Object[][])this.attributes.get("UNDERLINE"), obj);
            this.attributes.put("UNDERLINE", unders);
        }
        if (action != null) {
            this.attributes.put("ACTION", action);
        }
        this.noStroke.put("COLOR", f.color());
        this.noStroke.put("ENCODING", this.font.getFont().getEncoding());
        obj = (Object[])this.attributes.get("IMAGE");
        if (obj == null) {
            this.image = null;
        } else {
            this.attributes.remove("HSCALE");
            this.image = (Image)obj[0];
            this.offsetX = ((Float)obj[1]).floatValue();
            this.offsetY = ((Float)obj[2]).floatValue();
            this.changeLeading = (Boolean)obj[3];
        }
        this.font.setImage(this.image);
        Float hs = (Float)this.attributes.get("HSCALE");
        if (hs != null) {
            this.font.setHorizontalScaling(hs.floatValue());
        }
        this.encoding = this.font.getFont().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = this;
        }
    }

    PdfChunk(String string, PdfChunk other) {
        PdfChunk.thisChunk[0] = this;
        this.value = string;
        this.font = other.font;
        this.attributes = other.attributes;
        this.noStroke = other.noStroke;
        this.baseFont = other.baseFont;
        Object[] obj = (Object[])this.attributes.get("IMAGE");
        if (obj == null) {
            this.image = null;
        } else {
            this.image = (Image)obj[0];
            this.offsetX = ((Float)obj[1]).floatValue();
            this.offsetY = ((Float)obj[2]).floatValue();
            this.changeLeading = (Boolean)obj[3];
        }
        this.encoding = this.font.getFont().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = this;
        }
    }

    public boolean changeLeading() {
        return this.changeLeading;
    }

    Color color() {
        return (Color)this.noStroke.get("COLOR");
    }

    PdfFont font() {
        return this.font;
    }

    Object getAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            return this.attributes.get(name);
        }
        return this.noStroke.get(name);
    }

    float getCharWidth(char c) {
        if (PdfChunk.noPrint(c)) {
            return 0.0f;
        }
        return this.font.width(c);
    }

    String getEncoding() {
        return this.encoding;
    }

    Image getImage() {
        return this.image;
    }

    float getImageOffsetX() {
        return this.offsetX;
    }

    float getImageOffsetY() {
        return this.offsetY;
    }

    public float getTextRise() {
        Float f = (Float)this.getAttribute("SUBSUPSCRIPT");
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public char getUnicodeEquivalent(char c) {
        return this.baseFont.getUnicodeEquivalent(c);
    }

    public float getWidthCorrected(float charSpacing, float wordSpacing) {
        if (this.image != null) {
            return this.image.scaledWidth() + charSpacing;
        }
        int numberOfSpaces = 0;
        int idx = -1;
        while ((idx = this.value.indexOf(32, idx + 1)) >= 0) {
            ++numberOfSpaces;
        }
        return this.width() + ((float)this.value.length() * charSpacing + (float)numberOfSpaces * wordSpacing);
    }

    protected int getWord(String text, int start) {
        int len = text.length();
        while (start < len) {
            if (!Character.isLetter(text.charAt(start))) break;
            ++start;
        }
        return start;
    }

    boolean isAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            return true;
        }
        return this.noStroke.containsKey(name);
    }

    boolean isExtSplitCharacter(int start, int current, int end, char[] cc, PdfChunk[] ck) {
        return this.splitCharacter.isSplitCharacter(start, current, end, cc, ck);
    }

    boolean isImage() {
        return this.image != null;
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit;
    }

    boolean isSpecialEncoding() {
        return this.encoding.equals("UnicodeBigUnmarked") || this.encoding.equals("Identity-H");
    }

    public boolean isSplitCharacter(int start, int current, int end, char[] cc, PdfChunk[] ck) {
        char c = ck == null ? cc[current] : ck[Math.min(current, ck.length - 1)].getUnicodeEquivalent(cc[current]);
        if (c <= ' ' || c == '-') {
            return true;
        }
        if (c < '\u2e80') {
            return false;
        }
        return c >= '\u2e80' && c < '\ud7a0' || c >= '\uf900' && c < '\ufb00' || c >= '\ufe30' && c < '\ufe50' || c >= '\uff61' && c < '\uffa0';
    }

    boolean isStroked() {
        return this.attributes.size() > 0;
    }

    int length() {
        return this.value.length();
    }

    public static boolean noPrint(char c) {
        return c >= '\u200b' && c <= '\u200f' || c >= '\u202a' && c <= '\u202e';
    }

    void setImageOffsetX(float offsetX) {
        this.offsetX = offsetX;
    }

    void setImageOffsetY(float offsetY) {
        this.offsetY = offsetY;
    }

    void setValue(String value) {
        this.value = value;
    }

    /*
     * Unable to fully structure code
     */
    PdfChunk split(float width) {
        block19: {
            this.newlineSplit = false;
            if (this.image != null) {
                if (this.image.scaledWidth() > width) {
                    pc = new PdfChunk("\ufffc", this);
                    this.value = "";
                    this.attributes = new HashMap<K, V>();
                    this.image = null;
                    this.font = PdfFont.getDefaultFont();
                    return pc;
                }
                return null;
            }
            hyphenationEvent = (HyphenationEvent)this.noStroke.get("HYPHENATION");
            currentPosition = 0;
            splitPosition = -1;
            currentWidth = 0.0f;
            lastSpace = -1;
            lastSpaceWidth = 0.0f;
            length = this.value.length();
            valueArray = this.value.toCharArray();
            character = '\u0000';
            ft = this.font.getFont();
            if (ft.getFontType() != 2 || ft.getUnicodeEquivalent(' ') == ' ') ** GOTO lbl70
            while (currentPosition < length) {
                cidChar = valueArray[currentPosition];
                character = ft.getUnicodeEquivalent(cidChar);
                if (character == '\n') {
                    this.newlineSplit = true;
                    returnValue = this.value.substring(currentPosition + 1);
                    this.value = this.value.substring(0, currentPosition);
                    if (this.value.length() < 1) {
                        this.value = "\u0001";
                    }
                    pc = new PdfChunk(returnValue, this);
                    return pc;
                }
                currentWidth += this.font.width(cidChar);
                if (character == ' ') {
                    lastSpace = currentPosition + 1;
                    lastSpaceWidth = currentWidth;
                }
                if (!(currentWidth > width)) {
                    if (this.splitCharacter.isSplitCharacter(0, currentPosition, length, valueArray, PdfChunk.thisChunk)) {
                        splitPosition = currentPosition + 1;
                    }
                    ++currentPosition;
                    continue;
                }
                break block19;
            }
            break block19;
lbl-1000:
            // 1 sources

            {
                character = valueArray[currentPosition];
                if (character == '\r' || character == '\n') {
                    this.newlineSplit = true;
                    inc = 1;
                    if (character == '\r' && currentPosition + 1 < length && valueArray[currentPosition + 1] == '\n') {
                        inc = 2;
                    }
                    returnValue = this.value.substring(currentPosition + inc);
                    this.value = this.value.substring(0, currentPosition);
                    if (this.value.length() < 1) {
                        this.value = " ";
                    }
                    pc = new PdfChunk(returnValue, this);
                    return pc;
                }
                currentWidth += this.font.width(character);
                if (character == ' ') {
                    lastSpace = currentPosition + 1;
                    lastSpaceWidth = currentWidth;
                }
                if (currentWidth > width) break block19;
                if (this.splitCharacter.isSplitCharacter(0, currentPosition, length, valueArray, null)) {
                    splitPosition = currentPosition + 1;
                }
                ++currentPosition;
lbl70:
                // 2 sources

                ** while (currentPosition < length)
            }
lbl71:
            // 1 sources

        }
        if (currentPosition == length) {
            return null;
        }
        if (splitPosition < 0) {
            returnValue = this.value;
            this.value = "";
            pc = new PdfChunk(returnValue, this);
            return pc;
        }
        if (lastSpace > splitPosition && this.splitCharacter.isSplitCharacter(0, 0, 1, PdfChunk.singleSpace, null)) {
            splitPosition = lastSpace;
        }
        if (hyphenationEvent != null && lastSpace < currentPosition && (wordIdx = this.getWord(this.value, lastSpace)) > lastSpace) {
            pre = hyphenationEvent.getHyphenatedWordPre(this.value.substring(lastSpace, wordIdx), this.font.getFont(), this.font.size(), width - lastSpaceWidth);
            post = hyphenationEvent.getHyphenatedWordPost();
            if (pre.length() > 0) {
                returnValue = post + this.value.substring(wordIdx);
                this.value = this.trim(this.value.substring(0, lastSpace) + pre);
                pc = new PdfChunk(returnValue, this);
                return pc;
            }
        }
        returnValue = this.value.substring(splitPosition);
        this.value = this.trim(this.value.substring(0, splitPosition));
        pc = new PdfChunk(returnValue, this);
        return pc;
    }

    public String toString() {
        return this.value;
    }

    /*
     * Unable to fully structure code
     */
    String trim(String string) {
        block2: {
            ft = this.font.getFont();
            if (ft.getFontType() != 2 || ft.getUnicodeEquivalent(' ') == ' ') ** GOTO lbl10
            while (string.endsWith("\u0001")) {
                string = string.substring(0, string.length() - 1);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                string = string.substring(0, string.length() - 1);
lbl10:
                // 2 sources

                ** while (string.endsWith((String)" ") || string.endsWith((String)"\t"))
            }
lbl11:
            // 1 sources

        }
        return string;
    }

    public float trimLastSpace() {
        BaseFont ft = this.font.getFont();
        if (ft.getFontType() == 2 && ft.getUnicodeEquivalent(' ') != ' ') {
            if (this.value.length() > 1 && this.value.endsWith("\u0001")) {
                this.value = this.value.substring(0, this.value.length() - 1);
                return this.font.width('\u0001');
            }
        } else if (this.value.length() > 1 && this.value.endsWith(" ")) {
            this.value = this.value.substring(0, this.value.length() - 1);
            return this.font.width(' ');
        }
        return 0.0f;
    }

    PdfChunk truncate(float width) {
        if (this.image != null) {
            if (this.image.scaledWidth() > width) {
                PdfChunk pc = new PdfChunk("", this);
                this.value = "";
                this.attributes.remove("IMAGE");
                this.image = null;
                this.font = PdfFont.getDefaultFont();
                return pc;
            }
            return null;
        }
        int currentPosition = 0;
        float currentWidth = 0.0f;
        if (width < this.font.width()) {
            String returnValue = this.value.substring(1);
            this.value = this.value.substring(0, 1);
            PdfChunk pc = new PdfChunk(returnValue, this);
            return pc;
        }
        int length = this.value.length();
        while (currentPosition < length) {
            char character = this.value.charAt(currentPosition);
            if ((currentWidth += this.font.width(character)) > width) break;
            ++currentPosition;
        }
        if (currentPosition == length) {
            return null;
        }
        if (currentPosition == 0) {
            currentPosition = 1;
        }
        String returnValue = this.value.substring(currentPosition);
        this.value = this.value.substring(0, currentPosition);
        PdfChunk pc = new PdfChunk(returnValue, this);
        return pc;
    }

    float width() {
        return this.font.width(this.value);
    }
}

