/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.DocWriter;
import com.lowagie2.text.Document;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.BadPdfFormatException;
import com.lowagie2.text.pdf.ByteBuffer;
import com.lowagie2.text.pdf.PdfContentByte;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfNumber;
import com.lowagie2.text.pdf.PdfStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

class PdfContents
extends PdfStream {
    static final byte[] RESTORESTATE;
    static final byte[] ROTATE180;
    static final byte[] ROTATE270;
    static final byte[] ROTATE90;
    static final byte[] ROTATEFINAL;
    static final byte[] SAVESTATE;

    static {
        SAVESTATE = DocWriter.getISOBytes("q\n");
        RESTORESTATE = DocWriter.getISOBytes("Q\n");
        ROTATE90 = DocWriter.getISOBytes("0 1 -1 0 ");
        ROTATE180 = DocWriter.getISOBytes("-1 0 0 -1 ");
        ROTATE270 = DocWriter.getISOBytes("0 -1 1 0 ");
        ROTATEFINAL = DocWriter.getISOBytes(" cm\n");
    }

    PdfContents(PdfContentByte under, PdfContentByte content, PdfContentByte text, PdfContentByte secondContent, Rectangle page) throws BadPdfFormatException {
        try {
            OutputStream out = null;
            this.streamBytes = new ByteArrayOutputStream();
            if (Document.compress) {
                this.compressed = true;
                out = new DeflaterOutputStream(this.streamBytes);
            } else {
                out = this.streamBytes;
            }
            int rotation = page.getRotation();
            switch (rotation) {
                case 90: {
                    out.write(ROTATE90);
                    out.write(DocWriter.getISOBytes(ByteBuffer.formatDouble(page.top())));
                    out.write(32);
                    out.write(48);
                    out.write(ROTATEFINAL);
                    break;
                }
                case 180: {
                    out.write(ROTATE180);
                    out.write(DocWriter.getISOBytes(ByteBuffer.formatDouble(page.right())));
                    out.write(32);
                    out.write(DocWriter.getISOBytes(ByteBuffer.formatDouble(page.top())));
                    out.write(ROTATEFINAL);
                    break;
                }
                case 270: {
                    out.write(ROTATE270);
                    out.write(48);
                    out.write(32);
                    out.write(DocWriter.getISOBytes(ByteBuffer.formatDouble(page.right())));
                    out.write(ROTATEFINAL);
                }
            }
            if (under.size() > 0) {
                out.write(SAVESTATE);
                under.getInternalBuffer().writeTo(out);
                out.write(RESTORESTATE);
            }
            if (content.size() > 0) {
                out.write(SAVESTATE);
                content.getInternalBuffer().writeTo(out);
                out.write(RESTORESTATE);
            }
            if (text != null) {
                out.write(SAVESTATE);
                text.getInternalBuffer().writeTo(out);
                out.write(RESTORESTATE);
            }
            if (secondContent.size() > 0) {
                secondContent.getInternalBuffer().writeTo(out);
            }
            out.close();
        }
        catch (Exception e) {
            throw new BadPdfFormatException(e.getMessage());
        }
        this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
        if (this.compressed) {
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        }
    }
}

