/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class PdfDictionary
extends PdfObject {
    public static final PdfName CATALOG;
    public static final PdfName FONT;
    public static final PdfName OUTLINES;
    public static final PdfName PAGE;
    public static final PdfName PAGES;
    private PdfName dictionaryType = null;
    protected HashMap hashMap = new HashMap();

    static {
        FONT = PdfName.FONT;
        OUTLINES = PdfName.OUTLINES;
        PAGE = PdfName.PAGE;
        PAGES = PdfName.PAGES;
        CATALOG = PdfName.CATALOG;
    }

    public PdfDictionary(PdfName type) {
        this();
        this.dictionaryType = type;
        this.put(PdfName.TYPE, this.dictionaryType);
    }

    public PdfDictionary() {
        super(6);
    }

    public boolean contains(PdfName key) {
        return this.hashMap.containsKey(key);
    }

    public PdfObject get(PdfName key) {
        return (PdfObject)this.hashMap.get(key);
    }

    public Set getKeys() {
        return this.hashMap.keySet();
    }

    public boolean isCatalog() {
        return this.dictionaryType.compareTo(CATALOG) == 0;
    }

    public boolean isDictionaryType(PdfName type) {
        return this.dictionaryType.compareTo(type) == 0;
    }

    public boolean isFont() {
        return this.dictionaryType.compareTo(FONT) == 0;
    }

    public boolean isOutlineTree() {
        return this.dictionaryType.compareTo(OUTLINES) == 0;
    }

    public boolean isPage() {
        return this.dictionaryType.compareTo(PAGE) == 0;
    }

    public boolean isPages() {
        return this.dictionaryType.compareTo(PAGES) == 0;
    }

    public void merge(PdfDictionary other) {
        this.hashMap.putAll(other.hashMap);
    }

    public void mergeDifferent(PdfDictionary other) {
        Iterator i = other.hashMap.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (this.hashMap.containsKey(key)) continue;
            this.hashMap.put(key, other.hashMap.get(key));
        }
    }

    public void put(PdfName key, PdfObject value) {
        this.hashMap.put(key, value);
    }

    public void putAll(PdfDictionary dic) {
        this.hashMap.putAll(dic.hashMap);
    }

    public void putDel(PdfName key, PdfObject value) {
        if (value == null) {
            this.hashMap.remove(key);
            return;
        }
        this.hashMap.put(key, value);
    }

    public void putEx(PdfName key, PdfObject value) {
        if (value == null) {
            return;
        }
        this.hashMap.put(key, value);
    }

    public void remove(PdfName key) {
        this.hashMap.remove(key);
    }

    public int size() {
        return this.hashMap.size();
    }

    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        os.write(60);
        os.write(60);
        int type = 0;
        Iterator i = this.hashMap.keySet().iterator();
        while (i.hasNext()) {
            PdfName key = (PdfName)i.next();
            PdfObject value = (PdfObject)this.hashMap.get(key);
            key.toPdf(writer, os);
            type = value.type();
            if (type != 5 && type != 6 && type != 4 && type != 3) {
                os.write(32);
            }
            value.toPdf(writer, os);
        }
        os.write(62);
        os.write(62);
    }

    public String toString() {
        return "Dictionary of type: " + this.get(PdfName.TYPE);
    }
}

