/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.Anchor;
import com.lowagie2.text.Annotation;
import com.lowagie2.text.BadElementException;
import com.lowagie2.text.Cell;
import com.lowagie2.text.Chunk;
import com.lowagie2.text.DocListener;
import com.lowagie2.text.Document;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Element;
import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.Graphic;
import com.lowagie2.text.HeaderFooter;
import com.lowagie2.text.Image;
import com.lowagie2.text.List;
import com.lowagie2.text.ListItem;
import com.lowagie2.text.Meta;
import com.lowagie2.text.Paragraph;
import com.lowagie2.text.Phrase;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.Section;
import com.lowagie2.text.SimpleTable;
import com.lowagie2.text.StringCompare;
import com.lowagie2.text.Table;
import com.lowagie2.text.Watermark;
import com.lowagie2.text.pdf.ColumnText;
import com.lowagie2.text.pdf.MultiColumnText;
import com.lowagie2.text.pdf.PageResources;
import com.lowagie2.text.pdf.PdfAcroForm;
import com.lowagie2.text.pdf.PdfAction;
import com.lowagie2.text.pdf.PdfAnnotation;
import com.lowagie2.text.pdf.PdfArray;
import com.lowagie2.text.pdf.PdfCell;
import com.lowagie2.text.pdf.PdfChunk;
import com.lowagie2.text.pdf.PdfContentByte;
import com.lowagie2.text.pdf.PdfContents;
import com.lowagie2.text.pdf.PdfDate;
import com.lowagie2.text.pdf.PdfDestination;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfEncodings;
import com.lowagie2.text.pdf.PdfException;
import com.lowagie2.text.pdf.PdfFileSpecification;
import com.lowagie2.text.pdf.PdfFont;
import com.lowagie2.text.pdf.PdfFormField;
import com.lowagie2.text.pdf.PdfIndirectReference;
import com.lowagie2.text.pdf.PdfLine;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfNameTree;
import com.lowagie2.text.pdf.PdfNumber;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfOutline;
import com.lowagie2.text.pdf.PdfPTable;
import com.lowagie2.text.pdf.PdfPage;
import com.lowagie2.text.pdf.PdfPageEvent;
import com.lowagie2.text.pdf.PdfPageLabels;
import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.text.pdf.PdfRectangle;
import com.lowagie2.text.pdf.PdfString;
import com.lowagie2.text.pdf.PdfTable;
import com.lowagie2.text.pdf.PdfTextArray;
import com.lowagie2.text.pdf.PdfTransition;
import com.lowagie2.text.pdf.PdfWriter;
import com.lowagie2.text.pdf.PdfXConformanceException;
import com.lowagie2.text.xml.xmp.XmpWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class PdfDocument
extends Document
implements DocListener {
    PdfAcroForm acroForm;
    private PdfDictionary additionalActions;
    private int alignment = 0;
    private ArrayList annotations;
    protected HashMap boxSize;
    private PdfAction currentAction = null;
    private float currentHeight = 0.0f;
    private PdfOutline currentOutline;
    private ArrayList delayedAnnotations;
    private HashMap documentFileAttachment;
    private ArrayList documentJavaScript;
    protected int duration = -1;
    private boolean firstPageEvent = true;
    private PdfContentByte graphics;
    static final String hangingPunctuation = ".,;:'";
    private float imageEnd = -1.0f;
    private float imageIndentLeft = 0.0f;
    private float imageIndentRight = 0.0f;
    private Image imageWait = null;
    private float indentBottom = 0.0f;
    private float indentLeft = 0.0f;
    private float indentRight = 0.0f;
    private float indentTop = 0.0f;
    private PdfInfo info = new PdfInfo();
    private boolean isNewPagePending;
    private boolean isNewpage = false;
    private boolean isParagraph = true;
    private int lastElementType = -1;
    private float leading = 0.0f;
    private PdfLine line = null;
    private ArrayList lines = new ArrayList();
    private float listIndentLeft = 0.0f;
    private TreeMap localDestinations;
    protected int markPoint;
    protected float nextMarginBottom;
    protected float nextMarginLeft;
    protected float nextMarginRight;
    protected float nextMarginTop;
    protected Rectangle nextPageSize = null;
    private PdfAction openActionAction;
    private String openActionName;
    protected PdfDictionary pageAA = null;
    private boolean pageEmpty = true;
    private PdfPageLabels pageLabels;
    protected PageResources pageResources;
    private float paraIndent = 0.0f;
    private PdfOutline rootOutline;
    private boolean strictImageSequence = false;
    private PdfContentByte text;
    private int textEmptySize;
    protected HashMap thisBoxSize = new HashMap();
    private PdfIndirectReference thumb;
    protected PdfTransition transition = null;
    private int viewerPreferences = 0;
    private PdfWriter writer;

    public PdfDocument() throws DocumentException {
        this.boxSize = new HashMap();
        this.delayedAnnotations = new ArrayList();
        this.localDestinations = new TreeMap(new StringCompare());
        this.documentJavaScript = new ArrayList();
        this.documentFileAttachment = new HashMap();
        this.addProducer();
        this.addCreationDate();
    }

    private void add(Image image) throws PdfException, DocumentException {
        if (image.hasAbsolutePosition()) {
            this.graphics.addImage(image);
            this.pageEmpty = false;
            return;
        }
        if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.scaledHeight() < this.indentBottom()) {
            if (!this.strictImageSequence && this.imageWait == null) {
                this.imageWait = image;
                return;
            }
            this.newPage();
            if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.scaledHeight() < this.indentBottom()) {
                this.imageWait = image;
                return;
            }
        }
        this.pageEmpty = false;
        if (image == this.imageWait) {
            this.imageWait = null;
        }
        boolean textwrap = (image.alignment() & 4) == 4 && (image.alignment() & 1) != 1;
        boolean underlying = (image.alignment() & 8) == 8;
        float diff = this.leading / 2.0f;
        if (textwrap) {
            diff += this.leading;
        }
        float lowerleft = this.indentTop() - this.currentHeight - image.scaledHeight() - diff;
        float[] mt = image.matrix();
        float startPosition = this.indentLeft() - mt[4];
        if ((image.alignment() & 2) == 2) {
            startPosition = this.indentRight() - image.scaledWidth() - mt[4];
        }
        if ((image.alignment() & 1) == 1) {
            startPosition = this.indentLeft() + (this.indentRight() - this.indentLeft() - image.scaledWidth()) / 2.0f - mt[4];
        }
        if (image.hasAbsoluteX()) {
            startPosition = image.absoluteX();
        }
        if (textwrap) {
            if (this.imageEnd < 0.0f || this.imageEnd < this.currentHeight + image.scaledHeight() + diff) {
                this.imageEnd = this.currentHeight + image.scaledHeight() + diff;
            }
            if ((image.alignment() & 2) == 2) {
                this.imageIndentRight += image.scaledWidth() + image.indentationLeft();
            } else {
                this.imageIndentLeft += image.scaledWidth() + image.indentationRight();
            }
        } else {
            startPosition = (image.alignment() & 2) == 2 ? (startPosition -= image.indentationRight()) : ((image.alignment() & 1) == 1 ? (startPosition += image.indentationLeft() - image.indentationRight()) : (startPosition += image.indentationLeft()));
        }
        this.graphics.addImage(image, mt[0], mt[1], mt[2], mt[3], startPosition, lowerleft - mt[5]);
        if (!textwrap && !underlying) {
            this.currentHeight += image.scaledHeight() + diff;
            this.flushLines();
            this.text.moveText(0.0f, -(image.scaledHeight() + diff));
            this.newLine();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean add(Element element) throws DocumentException {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        try {
            if (this.isNewPagePending) {
                this.isNewPagePending = false;
                this.newPage();
            }
            switch (element.type()) {
                case 0: {
                    this.info.addkey(((Meta)element).name(), ((Meta)element).content());
                    break;
                }
                case 1: {
                    this.info.addTitle(((Meta)element).content());
                    break;
                }
                case 2: {
                    this.info.addSubject(((Meta)element).content());
                    break;
                }
                case 3: {
                    this.info.addKeywords(((Meta)element).content());
                    break;
                }
                case 4: {
                    this.info.addAuthor(((Meta)element).content());
                    break;
                }
                case 7: {
                    this.info.addCreator(((Meta)element).content());
                    break;
                }
                case 5: {
                    this.info.addProducer();
                    break;
                }
                case 6: {
                    this.info.addCreationDate();
                    break;
                }
                case 10: {
                    PdfChunk overflow;
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    PdfChunk chunk = new PdfChunk((Chunk)element, this.currentAction);
                    while ((overflow = this.line.add(chunk)) != null) {
                        void var3_15;
                        this.carriageReturn();
                        chunk = var3_15;
                    }
                    this.pageEmpty = false;
                    if (!chunk.isAttribute("NEWPAGE")) break;
                    this.newPage();
                    break;
                }
                case 17: {
                    Anchor anchor = (Anchor)element;
                    String url = anchor.reference();
                    this.leading = anchor.leading();
                    if (url != null) {
                        this.currentAction = new PdfAction(url);
                    }
                    element.process(this);
                    this.currentAction = null;
                    break;
                }
                case 29: {
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    Annotation annot = (Annotation)element;
                    PdfAnnotation an = PdfDocument.convertAnnotation(this.writer, annot);
                    this.annotations.add(an);
                    this.pageEmpty = false;
                    break;
                }
                case 11: {
                    this.leading = ((Phrase)element).leading();
                    element.process(this);
                    break;
                }
                case 12: {
                    Paragraph paragraph = (Paragraph)element;
                    float spacingBefore = paragraph.spacingBefore();
                    if (spacingBefore != 0.0f) {
                        this.leading = spacingBefore;
                        this.carriageReturn();
                        if (!this.pageEmpty) {
                            Chunk space = new Chunk(" ");
                            space.process(this);
                            this.carriageReturn();
                        }
                    }
                    this.alignment = paragraph.alignment();
                    this.leading = paragraph.leading();
                    this.carriageReturn();
                    if (this.currentHeight + this.line.height() + this.leading > this.indentTop() - this.indentBottom()) {
                        this.newPage();
                    }
                    this.indentLeft += paragraph.indentationLeft();
                    this.indentRight += paragraph.indentationRight();
                    this.carriageReturn();
                    this.paraIndent += paragraph.indentationLeft();
                    PdfPageEvent pageEvent = this.writer.getPageEvent();
                    if (pageEvent != null && this.isParagraph) {
                        pageEvent.onParagraph(this.writer, this, this.indentTop() - this.currentHeight);
                    }
                    if (paragraph.getKeepTogether()) {
                        Table table = new Table(1, 1);
                        table.setOffset(0.0f);
                        table.setBorder(0);
                        table.setWidth(100.0f);
                        table.setTableFitsPage(true);
                        Cell cell = new Cell(paragraph);
                        cell.setBorder(0);
                        cell.setHorizontalAlignment(paragraph.alignment());
                        table.addCell(cell);
                        this.add(table);
                        break;
                    }
                    element.process(this);
                    this.paraIndent -= paragraph.indentationLeft();
                    float spacingAfter = paragraph.spacingAfter();
                    if (spacingAfter != 0.0f) {
                        this.leading = spacingAfter;
                        this.carriageReturn();
                        if (this.currentHeight + this.line.height() + this.leading < this.indentTop() - this.indentBottom()) {
                            Chunk space = new Chunk(" ");
                            space.process(this);
                            this.carriageReturn();
                        }
                        this.leading = paragraph.leading();
                    }
                    if (pageEvent != null && this.isParagraph) {
                        pageEvent.onParagraphEnd(this.writer, this, this.indentTop() - this.currentHeight);
                    }
                    this.alignment = 0;
                    this.indentLeft -= paragraph.indentationLeft();
                    this.indentRight -= paragraph.indentationRight();
                    this.carriageReturn();
                    break;
                }
                case 13: 
                case 16: {
                    boolean hasTitle;
                    Section section = (Section)element;
                    boolean bl = hasTitle = section.title() != null;
                    if (section.isChapter()) {
                        this.newPage();
                    } else {
                        this.newLine();
                    }
                    if (hasTitle) {
                        PdfOutline outline;
                        float fith = this.indentTop() - this.currentHeight;
                        int rotation = this.pageSize.getRotation();
                        if (rotation == 90 || rotation == 180) {
                            fith = this.pageSize.height() - fith;
                        }
                        PdfDestination destination = new PdfDestination(2, fith);
                        while (this.currentOutline.level() >= section.depth()) {
                            this.currentOutline = this.currentOutline.parent();
                        }
                        this.currentOutline = outline = new PdfOutline(this.currentOutline, destination, section.getBookmarkTitle(), section.isBookmarkOpen());
                    }
                    this.carriageReturn();
                    this.indentLeft += section.indentationLeft();
                    this.indentRight += section.indentationRight();
                    PdfPageEvent pageEvent = this.writer.getPageEvent();
                    if (pageEvent != null) {
                        if (element.type() == 16) {
                            pageEvent.onChapter(this.writer, this, this.indentTop() - this.currentHeight, section.title());
                        } else {
                            pageEvent.onSection(this.writer, this, this.indentTop() - this.currentHeight, section.depth(), section.title());
                        }
                    }
                    if (hasTitle) {
                        this.isParagraph = false;
                        this.add(section.title());
                        this.isParagraph = true;
                    }
                    this.indentLeft += section.indentation();
                    element.process(this);
                    this.indentLeft -= section.indentationLeft() + section.indentation();
                    this.indentRight -= section.indentationRight();
                    if (pageEvent == null) break;
                    if (element.type() == 16) {
                        pageEvent.onChapterEnd(this.writer, this, this.indentTop() - this.currentHeight);
                        break;
                    }
                    pageEvent.onSectionEnd(this.writer, this, this.indentTop() - this.currentHeight);
                    break;
                }
                case 14: {
                    List list = (List)element;
                    this.listIndentLeft += list.indentationLeft();
                    this.indentRight += list.indentationRight();
                    element.process(this);
                    this.listIndentLeft -= list.indentationLeft();
                    this.indentRight -= list.indentationRight();
                    break;
                }
                case 15: {
                    ListItem listItem = (ListItem)element;
                    float spacingBefore = listItem.spacingBefore();
                    if (spacingBefore != 0.0f) {
                        this.leading = spacingBefore;
                        this.carriageReturn();
                        if (!this.pageEmpty) {
                            Chunk space = new Chunk(" ");
                            space.process(this);
                            this.carriageReturn();
                        }
                    }
                    this.alignment = listItem.alignment();
                    this.listIndentLeft += listItem.indentationLeft();
                    this.indentRight += listItem.indentationRight();
                    this.leading = listItem.leading();
                    this.carriageReturn();
                    this.line.setListItem(listItem);
                    element.process(this);
                    float spacingAfter = listItem.spacingAfter();
                    if (spacingAfter != 0.0f) {
                        this.leading = spacingAfter;
                        this.carriageReturn();
                        if (this.currentHeight + this.line.height() + this.leading < this.indentTop() - this.indentBottom()) {
                            Chunk space = new Chunk(" ");
                            space.process(this);
                            this.carriageReturn();
                        }
                        this.leading = listItem.leading();
                    }
                    this.carriageReturn();
                    this.listIndentLeft -= listItem.indentationLeft();
                    this.indentRight -= listItem.indentationRight();
                    break;
                }
                case 30: {
                    Rectangle rectangle = (Rectangle)element;
                    this.graphics.rectangle(rectangle);
                    this.pageEmpty = false;
                    break;
                }
                case 23: {
                    PdfPTable ptable = (PdfPTable)element;
                    if (ptable.size() <= ptable.getHeaderRows()) break;
                    this.ensureNewLine();
                    this.flushLines();
                    this.addPTable(ptable);
                    this.pageEmpty = false;
                    break;
                }
                case 40: {
                    this.ensureNewLine();
                    this.flushLines();
                    MultiColumnText multiText = (MultiColumnText)element;
                    float height = multiText.write(this.writer.getDirectContent(), this, this.indentTop() - this.currentHeight);
                    this.currentHeight += height;
                    this.text.moveText(0.0f, -1.0f * height);
                    this.pageEmpty = false;
                    break;
                }
                case 22: {
                    PdfTable table;
                    if (element instanceof PdfTable) {
                        table = (PdfTable)element;
                        table.updateRowAdditions();
                    } else {
                        if (element instanceof SimpleTable) {
                            PdfPTable ptable = ((SimpleTable)element).createPdfPTable();
                            if (ptable.size() <= ptable.getHeaderRows()) break;
                            this.ensureNewLine();
                            this.flushLines();
                            this.addPTable(ptable);
                            this.pageEmpty = false;
                            break;
                        }
                        if (element instanceof Table) {
                            try {
                                PdfPTable ptable = ((Table)element).createPdfPTable();
                                if (ptable.size() <= ptable.getHeaderRows()) break;
                                this.ensureNewLine();
                                this.flushLines();
                                this.addPTable(ptable);
                                this.pageEmpty = false;
                                break;
                            }
                            catch (BadElementException bee) {
                                float offset = ((Table)element).getOffset();
                                if (Float.isNaN(offset)) {
                                    offset = this.leading;
                                }
                                this.carriageReturn();
                                this.lines.add(new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, offset));
                                this.currentHeight += offset;
                                table = this.getPdfTable((Table)element, false);
                            }
                        } else {
                            return false;
                        }
                    }
                    this.add(table, false);
                    break;
                }
                case 32: 
                case 34: 
                case 35: {
                    this.add((Image)element);
                    break;
                }
                case 39: {
                    Graphic graphic = (Graphic)element;
                    graphic.processAttributes(this.indentLeft(), this.indentBottom(), this.indentRight(), this.indentTop(), this.indentTop() - this.currentHeight);
                    this.graphics.add(graphic);
                    this.pageEmpty = false;
                    break;
                }
                default: {
                    return false;
                }
            }
            this.lastElementType = element.type();
            return true;
        }
        catch (Exception e) {
            throw new DocumentException(e);
        }
    }

    private void add(PdfTable table, boolean onlyFirstPage) throws DocumentException {
        boolean tableHasToFit;
        this.flushLines();
        RenderingContext ctx = new RenderingContext();
        ctx.pagetop = this.indentTop();
        ctx.oldHeight = this.currentHeight;
        ctx.cellGraphics = new PdfContentByte(this.writer);
        ctx.rowspanMap = new HashMap();
        ctx.table = table;
        boolean bl = table.hasToFitPageTable() ? table.bottom() < this.indentBottom() && table.height() < this.top() - this.bottom() : (tableHasToFit = false);
        if (this.pageEmpty) {
            tableHasToFit = false;
        }
        boolean cellsHaveToFit = table.hasToFitPageCells();
        ArrayList<PdfCell> dataCells = table.getCells();
        ArrayList headercells = table.getHeaderCells();
        if (headercells.size() > 0 && (dataCells.size() == 0 || dataCells.get(0) != headercells.get(0))) {
            ArrayList<PdfCell> allCells = new ArrayList<PdfCell>(dataCells.size() + headercells.size());
            allCells.addAll(headercells);
            allCells.addAll(dataCells);
            dataCells = allCells;
        }
        ArrayList<PdfCell> cells = dataCells;
        ArrayList rows = this.extractRows(cells, ctx);
        boolean isContinue = false;
        while (!cells.isEmpty()) {
            PdfCell cell;
            ctx.lostTableBottom = 0.0f;
            boolean cellsShown = false;
            boolean currentGroupNumber = false;
            boolean headerChecked = false;
            float headerHeight = 0.0f;
            Iterator iterator = rows.iterator();
            boolean atLeastOneFits = false;
            while (iterator.hasNext()) {
                ArrayList row = (ArrayList)iterator.next();
                this.analyzeRow(rows, ctx);
                this.renderCells(ctx, row, table.hasToFitPageCells() & atLeastOneFits);
                if (!this.mayBeRemoved(row)) break;
                this.consumeRowspan(row, ctx);
                iterator.remove();
                atLeastOneFits = true;
            }
            cells.clear();
            HashSet<PdfCell> opt = new HashSet<PdfCell>();
            iterator = rows.iterator();
            while (iterator.hasNext()) {
                ArrayList row = (ArrayList)iterator.next();
                Iterator cellIterator = row.iterator();
                while (cellIterator.hasNext()) {
                    cell = (PdfCell)cellIterator.next();
                    if (opt.contains(cell)) continue;
                    cells.add(cell);
                    opt.add(cell);
                }
            }
            tableHasToFit = false;
            Rectangle tablerec = new Rectangle(table);
            tablerec.setBorder(table.border());
            tablerec.setBorderWidth(table.borderWidth());
            tablerec.setBorderColor(table.borderColor());
            tablerec.setBackgroundColor(table.backgroundColor());
            PdfContentByte under = this.writer.getDirectContentUnder();
            under.rectangle(tablerec.rectangle(this.top(), this.indentBottom()));
            under.add(ctx.cellGraphics);
            tablerec.setBackgroundColor(null);
            tablerec = tablerec.rectangle(this.top(), this.indentBottom());
            tablerec.setBorder(table.border());
            under.rectangle(tablerec);
            ctx.cellGraphics = new PdfContentByte(null);
            if (rows.isEmpty()) continue;
            isContinue = true;
            this.graphics.setLineWidth(table.borderWidth());
            if (cellsShown && (table.border() & 2) == 2) {
                Color tColor = table.borderColor();
                if (tColor != null) {
                    this.graphics.setColorStroke(tColor);
                }
                this.graphics.moveTo(table.left(), Math.max(table.bottom(), this.indentBottom()));
                this.graphics.lineTo(table.right(), Math.max(table.bottom(), this.indentBottom()));
                this.graphics.stroke();
                if (tColor != null) {
                    this.graphics.resetRGBColorStroke();
                }
            }
            this.pageEmpty = false;
            float difference = ctx.lostTableBottom;
            this.newPage();
            ++ctx.countPageBreaks;
            float heightCorrection = 0.0f;
            boolean somethingAdded = false;
            if (this.currentHeight > 0.0f) {
                heightCorrection = 6.0f;
                this.currentHeight += heightCorrection;
                somethingAdded = true;
                this.newLine();
                this.flushLines();
                this.indentTop = this.currentHeight - this.leading;
                this.currentHeight = 0.0f;
            } else {
                this.flushLines();
            }
            int size = headercells.size();
            if (size > 0) {
                cell = (PdfCell)headercells.get(0);
                float oldTop = cell.top(0.0f);
                int i = 0;
                while (i < size) {
                    cell = (PdfCell)headercells.get(i);
                    cell.setTop(this.indentTop() - oldTop + cell.top(0.0f));
                    cell.setBottom(this.indentTop() - oldTop + cell.bottom(0.0f));
                    ctx.pagetop = cell.bottom();
                    ctx.cellGraphics.rectangle(cell.rectangle(this.indentTop(), this.indentBottom()));
                    ArrayList images = cell.getImages(this.indentTop(), this.indentBottom());
                    Iterator im = images.iterator();
                    while (im.hasNext()) {
                        cellsShown = true;
                        Image image = (Image)im.next();
                        this.graphics.addImage(image);
                    }
                    this.lines = cell.getLines(this.indentTop(), this.indentBottom());
                    float cellTop = cell.top(this.indentTop());
                    this.text.moveText(0.0f, cellTop - heightCorrection);
                    float cellDisplacement = this.flushLines() - cellTop + heightCorrection;
                    this.text.moveText(0.0f, cellDisplacement);
                    ++i;
                }
                this.currentHeight = this.indentTop() - ctx.pagetop + table.cellspacing();
                this.text.moveText(0.0f, ctx.pagetop - this.indentTop() - this.currentHeight);
            } else if (somethingAdded) {
                ctx.pagetop = this.indentTop();
                this.text.moveText(0.0f, -table.cellspacing());
            }
            ctx.oldHeight = this.currentHeight - heightCorrection;
            size = Math.min(cells.size(), table.columns());
            int i = 0;
            while (i < size) {
                float neededHeight;
                float newBottom;
                cell = (PdfCell)cells.get(i);
                if (cell.top(-table.cellspacing()) > ctx.lostTableBottom && (newBottom = ctx.pagetop - difference + cell.bottom()) > ctx.pagetop - (neededHeight = cell.remainingHeight())) {
                    difference += newBottom - (ctx.pagetop - neededHeight);
                }
                ++i;
            }
            size = cells.size();
            table.setTop(this.indentTop());
            table.setBottom(ctx.pagetop - difference + table.bottom(table.cellspacing()));
            i = 0;
            while (i < size) {
                cell = (PdfCell)cells.get(i);
                float newBottom = ctx.pagetop - difference + cell.bottom();
                float newTop = ctx.pagetop - difference + cell.top(-table.cellspacing());
                if (newTop > this.indentTop() - this.currentHeight) {
                    newTop = this.indentTop() - this.currentHeight;
                }
                cell.setTop(newTop);
                cell.setBottom(newBottom);
                ++i;
            }
            if (onlyFirstPage) break;
        }
        float tableHeight = table.top() - table.bottom();
        if (isContinue) {
            this.currentHeight = tableHeight;
            this.text.moveText(0.0f, -(tableHeight - ctx.oldHeight * 2.0f));
        } else {
            this.currentHeight = ctx.oldHeight + tableHeight;
            this.text.moveText(0.0f, -tableHeight);
        }
        this.pageEmpty = false;
        if (ctx.countPageBreaks > 0) {
            this.isNewPagePending = true;
        }
    }

    public boolean add(Watermark watermark) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.watermark = watermark;
        return true;
    }

    void addAdditionalAction(PdfName actionType, PdfAction action) {
        if (this.additionalActions == null) {
            this.additionalActions = new PdfDictionary();
        }
        if (action == null) {
            this.additionalActions.remove(actionType);
        } else {
            this.additionalActions.put(actionType, action);
        }
        if (this.additionalActions.size() == 0) {
            this.additionalActions = null;
        }
    }

    void addAnnotation(PdfAnnotation annot) {
        this.pageEmpty = false;
        if (annot.isForm()) {
            PdfFormField field = (PdfFormField)annot;
            if (field.getParent() == null) {
                this.addFormFieldRaw(field);
            }
        } else {
            this.annotations.add(annot);
        }
    }

    void addCalculationOrder(PdfFormField formField) {
        this.acroForm.addCalculationOrder(formField);
    }

    void addFileAttachment(String description, PdfFileSpecification fs) throws IOException {
        if (description == null) {
            description = "";
        }
        fs.put(PdfName.DESC, new PdfString(description, "UnicodeBig"));
        if (description.length() == 0) {
            description = "Unnamed";
        }
        String fn = PdfEncodings.convertToString(new PdfString(description, "UnicodeBig").getBytes(), null);
        int k = 0;
        while (this.documentFileAttachment.containsKey(fn)) {
            fn = PdfEncodings.convertToString(new PdfString(description + " " + ++k, "UnicodeBig").getBytes(), null);
        }
        this.documentFileAttachment.put(fn, fs.getReference());
    }

    void addFormFieldRaw(PdfFormField field) {
        this.annotations.add(field);
        ArrayList kids = field.getKids();
        if (kids != null) {
            int k = 0;
            while (k < kids.size()) {
                this.addFormFieldRaw((PdfFormField)kids.get(k));
                ++k;
            }
        }
    }

    void addJavaScript(PdfAction js) {
        if (js.get(PdfName.JS) == null) {
            throw new RuntimeException("Only JavaScript actions are allowed.");
        }
        try {
            this.documentJavaScript.add(this.writer.addToBody(js).getIndirectReference());
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    void addOutline(PdfOutline outline, String name) {
        this.localDestination(name, outline.getPdfDestination());
    }

    void addPTable(PdfPTable ptable) throws DocumentException {
        ColumnText ct = new ColumnText(this.writer.getDirectContent());
        if (this.currentHeight > 0.0f) {
            Paragraph p = new Paragraph();
            p.setLeading(0.0f);
            ct.addElement(p);
            if (ptable.getKeepTogether() && !this.fitsPage(ptable, 0.0f)) {
                this.newPage();
            }
        }
        ct.addElement(ptable);
        boolean he = ptable.isHeadersInEvent();
        ptable.setHeadersInEvent(true);
        int loop = 0;
        while (true) {
            ct.setSimpleColumn(this.indentLeft(), this.indentBottom(), this.indentRight(), this.indentTop() - this.currentHeight);
            int status = ct.go();
            if ((status & 1) != 0) {
                this.text.moveText(0.0f, ct.getYLine() - this.indentTop() + this.currentHeight);
                this.currentHeight = this.indentTop() - ct.getYLine();
                break;
            }
            loop = this.indentTop() - this.currentHeight == ct.getYLine() ? ++loop : 0;
            if (loop == 3) {
                this.add(new Paragraph("ERROR: Infinite table loop"));
                break;
            }
            this.newPage();
        }
        ptable.setHeadersInEvent(he);
    }

    public void addWriter(PdfWriter writer) throws DocumentException {
        if (this.writer == null) {
            this.writer = writer;
            this.acroForm = new PdfAcroForm(writer);
            return;
        }
        throw new DocumentException("You can only add a writer to a PdfDocument once.");
    }

    private void analyzeRow(ArrayList rows, RenderingContext ctx) {
        ctx.maxCellBottom = this.indentBottom();
        int rowIndex = 0;
        ArrayList row = (ArrayList)rows.get(rowIndex);
        int maxRowspan = 1;
        Iterator iterator = row.iterator();
        while (iterator.hasNext()) {
            PdfCell cell = (PdfCell)iterator.next();
            maxRowspan = Math.max(ctx.currentRowspan(cell), maxRowspan);
        }
        boolean useTop = true;
        if ((rowIndex += maxRowspan) == rows.size()) {
            rowIndex = rows.size() - 1;
            useTop = false;
        }
        if (rowIndex < 0 || rowIndex >= rows.size()) {
            return;
        }
        row = (ArrayList)rows.get(rowIndex);
        iterator = row.iterator();
        while (iterator.hasNext()) {
            PdfCell cell = (PdfCell)iterator.next();
            Rectangle cellRect = cell.rectangle(ctx.pagetop, this.indentBottom());
            if (useTop) {
                ctx.maxCellBottom = Math.max(ctx.maxCellBottom, cellRect.top());
                continue;
            }
            if (ctx.currentRowspan(cell) != 1) continue;
            ctx.maxCellBottom = Math.max(ctx.maxCellBottom, cellRect.bottom());
        }
    }

    float bottom(Table table) {
        float h = this.currentHeight > 0.0f ? this.indentTop() - this.currentHeight - 2.0f * this.leading : this.indentTop();
        PdfTable tmp = this.getPdfTable(table, false);
        return tmp.bottom();
    }

    boolean breakTableIfDoesntFit(PdfTable table) throws DocumentException {
        table.updateRowAdditions();
        if (!table.hasToFitPageTable() && table.bottom() <= this.indentBottom) {
            this.add(table, true);
            return true;
        }
        return false;
    }

    void calculateOutlineCount() {
        if (this.rootOutline.getKids().size() == 0) {
            return;
        }
        this.traverseOutlineCount(this.rootOutline);
    }

    private void carriageReturn() throws DocumentException {
        if (this.lines == null) {
            this.lines = new ArrayList();
        }
        if (this.line != null) {
            if (this.currentHeight + this.line.height() + this.leading < this.indentTop() - this.indentBottom()) {
                if (this.line.size() > 0) {
                    this.currentHeight += this.line.height();
                    this.lines.add(this.line);
                    this.pageEmpty = false;
                }
            } else {
                this.newPage();
            }
        }
        if (this.imageEnd > -1.0f && this.currentHeight > this.imageEnd) {
            this.imageEnd = -1.0f;
            this.imageIndentRight = 0.0f;
            this.imageIndentLeft = 0.0f;
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    public void clearTextWrap() throws DocumentException {
        super.clearTextWrap();
        float tmpHeight = this.imageEnd - this.currentHeight;
        if (this.line != null) {
            tmpHeight += this.line.height();
        }
        if (this.imageEnd > -1.0f && tmpHeight > 0.0f) {
            this.carriageReturn();
            this.currentHeight += tmpHeight;
        }
    }

    public void close() {
        if (this.close) {
            return;
        }
        try {
            boolean wasImage = this.imageWait != null;
            this.newPage();
            if (this.imageWait != null || wasImage) {
                this.newPage();
            }
            if (this.annotations.size() > 0) {
                throw new RuntimeException(this.annotations.size() + " annotations had invalid placement pages.");
            }
            PdfPageEvent pageEvent = this.writer.getPageEvent();
            if (pageEvent != null) {
                pageEvent.onCloseDocument(this.writer, this);
            }
            super.close();
            this.writer.addLocalDestinations(this.localDestinations);
            this.calculateOutlineCount();
            this.writeOutlines();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        this.writer.close();
    }

    private void consumeRowspan(ArrayList row, RenderingContext ctx) {
        Iterator iterator = row.iterator();
        while (iterator.hasNext()) {
            PdfCell c = (PdfCell)iterator.next();
            ctx.consumeRowspan(c);
        }
    }

    static PdfAnnotation convertAnnotation(PdfWriter writer, Annotation annot) throws IOException {
        switch (annot.annotationType()) {
            case 1: {
                return new PdfAnnotation(writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((URL)annot.attributes().get(Annotation.URL)));
            }
            case 2: {
                return new PdfAnnotation(writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((String)annot.attributes().get(Annotation.FILE)));
            }
            case 3: {
                return new PdfAnnotation(writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((String)annot.attributes().get(Annotation.FILE), (String)annot.attributes().get(Annotation.DESTINATION)));
            }
            case 7: {
                boolean[] sparams = (boolean[])annot.attributes().get(Annotation.PARAMETERS);
                String fname = (String)annot.attributes().get(Annotation.FILE);
                String mimetype = (String)annot.attributes().get(Annotation.MIMETYPE);
                PdfFileSpecification fs = sparams[0] ? PdfFileSpecification.fileEmbedded(writer, fname, fname, null) : PdfFileSpecification.fileExtern(writer, fname);
                PdfAnnotation ann = PdfAnnotation.createScreen(writer, new Rectangle(annot.llx(), annot.lly(), annot.urx(), annot.ury()), fname, fs, mimetype, sparams[1]);
                return ann;
            }
            case 4: {
                return new PdfAnnotation(writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((String)annot.attributes().get(Annotation.FILE), (Integer)annot.attributes().get(Annotation.PAGE)));
            }
            case 5: {
                return new PdfAnnotation(writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((Integer)annot.attributes().get(Annotation.NAMED)));
            }
            case 6: {
                return new PdfAnnotation(writer, annot.llx(), annot.lly(), annot.urx(), annot.ury(), new PdfAction((String)annot.attributes().get(Annotation.APPLICATION), (String)annot.attributes().get(Annotation.PARAMETERS), (String)annot.attributes().get(Annotation.OPERATION), (String)annot.attributes().get(Annotation.DEFAULTDIR)));
            }
        }
        PdfDocument doc = writer.getPdfDocument();
        if (doc.line == null) {
            return null;
        }
        PdfAnnotation an = new PdfAnnotation(writer, annot.llx(doc.indentRight() - doc.line.widthLeft()), annot.lly(doc.indentTop() - doc.currentHeight), annot.urx(doc.indentRight() - doc.line.widthLeft() + 20.0f), annot.ury(doc.indentTop() - doc.currentHeight - 20.0f), new PdfString(annot.title()), new PdfString(annot.content()));
        return an;
    }

    public byte[] createXmpMetadata() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            XmpWriter xmp = new XmpWriter((OutputStream)baos, this.getInfo());
            xmp.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return baos.toByteArray();
    }

    private void ensureNewLine() {
        try {
            if (this.lastElementType == 11 || this.lastElementType == 10) {
                this.newLine();
                this.flushLines();
            }
        }
        catch (DocumentException ex) {
            throw new ExceptionConverter(ex);
        }
    }

    private ArrayList extractRows(ArrayList cells, RenderingContext ctx) {
        PdfCell previousCell = null;
        ArrayList rows = new ArrayList();
        ArrayList<PdfCell> rowCells = new ArrayList<PdfCell>();
        Iterator iterator = cells.iterator();
        while (iterator.hasNext()) {
            boolean isCurrentCellPartOfRow;
            PdfCell cell = (PdfCell)iterator.next();
            boolean isAdded = false;
            boolean isEndOfRow = !iterator.hasNext();
            boolean bl = isCurrentCellPartOfRow = !iterator.hasNext();
            if (previousCell != null && cell.left() <= previousCell.left()) {
                isEndOfRow = true;
                isCurrentCellPartOfRow = false;
            }
            if (isCurrentCellPartOfRow) {
                rowCells.add(cell);
                isAdded = true;
            }
            if (isEndOfRow) {
                if (!rowCells.isEmpty()) {
                    rows.add(rowCells);
                }
                rowCells = new ArrayList();
            }
            if (!isAdded) {
                rowCells.add(cell);
            }
            previousCell = cell;
        }
        if (!rowCells.isEmpty()) {
            rows.add(rowCells);
        }
        int i = rows.size() - 1;
        while (i >= 0) {
            ArrayList row = (ArrayList)rows.get(i);
            int j = 0;
            while (j < row.size()) {
                PdfCell c = (PdfCell)row.get(j);
                int rowspan = c.rowspan();
                int k = 1;
                while (k < rowspan) {
                    ArrayList spannedRow = (ArrayList)rows.get(i + k);
                    if (spannedRow.size() > j) {
                        spannedRow.add(j, c);
                    }
                    ++k;
                }
                ++j;
            }
            --i;
        }
        return rows;
    }

    boolean fitsPage(PdfPTable table, float margin) {
        if (!table.isLockedWidth()) {
            float totalWidth = (this.indentRight() - this.indentLeft()) * table.getWidthPercentage() / 100.0f;
            table.setTotalWidth(totalWidth);
        }
        this.ensureNewLine();
        return table.getTotalHeight() <= this.indentTop() - this.currentHeight - this.indentBottom() - margin;
    }

    private float flushLines() throws DocumentException {
        if (this.lines == null) {
            return 0.0f;
        }
        boolean newline = false;
        if (this.line != null && this.line.size() > 0) {
            this.lines.add(this.line);
            this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
            newline = true;
        }
        if (this.lines.size() == 0) {
            return 0.0f;
        }
        Object[] currentValues = new Object[2];
        PdfFont currentFont = null;
        float displacement = 0.0f;
        Float lastBaseFactor = new Float(0.0f);
        currentValues[1] = lastBaseFactor;
        Iterator i = this.lines.iterator();
        while (i.hasNext()) {
            PdfLine l = (PdfLine)i.next();
            if (this.isNewpage && newline) {
                newline = false;
                this.text.moveText(l.indentLeft() - this.indentLeft() + this.listIndentLeft + this.paraIndent, -l.height());
            } else {
                this.text.moveText(l.indentLeft() - this.indentLeft() + this.listIndentLeft, -l.height());
            }
            if (l.listSymbol() != null) {
                ColumnText.showTextAligned(this.graphics, 0, new Phrase(l.listSymbol()), this.text.getXTLM() - l.listIndent(), this.text.getYTLM(), 0.0f);
            }
            currentValues[0] = currentFont;
            this.writeLineToContent(l, this.text, this.graphics, currentValues, this.writer.getSpaceCharRatio());
            currentFont = (PdfFont)currentValues[0];
            displacement += l.height();
            if (this.indentLeft() - this.listIndentLeft == l.indentLeft()) continue;
            this.text.moveText(this.indentLeft() - l.indentLeft() - this.listIndentLeft, 0.0f);
        }
        this.lines = new ArrayList();
        return displacement;
    }

    public PdfAcroForm getAcroForm() {
        return this.acroForm;
    }

    Rectangle getBoxSize(String boxName) {
        PdfRectangle r = (PdfRectangle)this.thisBoxSize.get(boxName);
        if (r != null) {
            return r.getRectangle();
        }
        return null;
    }

    PdfCatalog getCatalog(PdfIndirectReference pages) {
        PdfCatalog catalog = this.rootOutline.getKids().size() > 0 ? new PdfCatalog(pages, this.rootOutline.indirectReference(), this.writer) : new PdfCatalog(pages, this.writer);
        if (this.openActionName != null) {
            PdfAction action = this.getLocalGotoAction(this.openActionName);
            catalog.setOpenAction(action);
        } else if (this.openActionAction != null) {
            catalog.setOpenAction(this.openActionAction);
        }
        if (this.additionalActions != null) {
            catalog.setAdditionalActions(this.additionalActions);
        }
        if (this.pageLabels != null) {
            catalog.setPageLabels(this.pageLabels);
        }
        catalog.addNames(this.localDestinations, this.documentJavaScript, this.documentFileAttachment, this.writer);
        catalog.setViewerPreferences(this.viewerPreferences);
        if (this.acroForm.isValid()) {
            try {
                catalog.setAcroForm(this.writer.addToBody(this.acroForm).getIndirectReference());
            }
            catch (IOException e) {
                throw new ExceptionConverter(e);
            }
        }
        return catalog;
    }

    HashMap getDocumentFileAttachment() {
        return this.documentFileAttachment;
    }

    ArrayList getDocumentJavaScript() {
        return this.documentJavaScript;
    }

    PdfInfo getInfo() {
        return this.info;
    }

    PdfAction getLocalGotoAction(String name) {
        PdfAction action;
        Object[] obj = (Object[])this.localDestinations.get(name);
        if (obj == null) {
            obj = new Object[3];
        }
        if (obj[0] == null) {
            if (obj[1] == null) {
                obj[1] = this.writer.getPdfIndirectReference();
            }
            action = new PdfAction((PdfIndirectReference)obj[1]);
            obj[0] = action;
            this.localDestinations.put(name, obj);
        } else {
            action = (PdfAction)obj[0];
        }
        return action;
    }

    int getMarkPoint() {
        return this.markPoint;
    }

    PageResources getPageResources() {
        return this.pageResources;
    }

    PdfTable getPdfTable(Table table, boolean supportRowAdditions) {
        return new PdfTable(table, this.indentLeft(), this.indentRight(), this.indentTop() - this.currentHeight, supportRowAdditions);
    }

    public PdfOutline getRootOutline() {
        return this.rootOutline;
    }

    public float getVerticalPosition(boolean ensureNewLine) {
        if (ensureNewLine) {
            this.ensureNewLine();
        }
        return this.top() - this.currentHeight - this.indentTop;
    }

    void incMarkPoint() {
        ++this.markPoint;
    }

    float indentBottom() {
        return this.bottom(this.indentBottom);
    }

    private float indentLeft() {
        return this.left(this.indentLeft + this.listIndentLeft + this.imageIndentLeft);
    }

    private float indentRight() {
        return this.right(this.indentRight + this.imageIndentRight);
    }

    private float indentTop() {
        return this.top(this.indentTop);
    }

    private void initPage() throws DocumentException {
        float tmpImageIndentRight;
        float tmpImageIndentLeft;
        float tmpListIndentLeft;
        float tmpIndentRight;
        this.markPoint = 0;
        this.annotations = this.delayedAnnotations;
        this.delayedAnnotations = new ArrayList();
        this.pageResources = new PageResources();
        this.writer.resetContent();
        ++this.pageN;
        float oldleading = this.leading;
        int oldAlignment = this.alignment;
        if (this.marginMirroring && (this.getPageNumber() & 1) == 0) {
            this.marginRight = this.nextMarginLeft;
            this.marginLeft = this.nextMarginRight;
        } else {
            this.marginLeft = this.nextMarginLeft;
            this.marginRight = this.nextMarginRight;
        }
        this.marginTop = this.nextMarginTop;
        this.marginBottom = this.nextMarginBottom;
        this.imageEnd = -1.0f;
        this.imageIndentRight = 0.0f;
        this.imageIndentLeft = 0.0f;
        this.graphics = new PdfContentByte(this.writer);
        this.text = new PdfContentByte(this.writer);
        this.text.beginText();
        this.text.moveText(this.left(), this.top());
        this.textEmptySize = this.text.size();
        this.text.reset();
        this.text.beginText();
        this.leading = 16.0f;
        this.indentBottom = 0.0f;
        this.indentTop = 0.0f;
        this.currentHeight = 0.0f;
        this.pageSize = this.nextPageSize;
        this.thisBoxSize = new HashMap(this.boxSize);
        if (this.pageSize.backgroundColor() != null || this.pageSize.hasBorders() || this.pageSize.borderColor() != null) {
            this.add(this.pageSize);
        }
        if (this.watermark != null) {
            float[] mt = this.watermark.matrix();
            this.graphics.addImage(this.watermark, mt[0], mt[1], mt[2], mt[3], this.watermark.offsetX() - mt[4], this.watermark.offsetY() - mt[5]);
        }
        if (this.footer != null) {
            float tmpIndentLeft = this.indentLeft;
            tmpIndentRight = this.indentRight;
            tmpListIndentLeft = this.listIndentLeft;
            tmpImageIndentLeft = this.imageIndentLeft;
            tmpImageIndentRight = this.imageIndentRight;
            this.indentRight = 0.0f;
            this.indentLeft = 0.0f;
            this.listIndentLeft = 0.0f;
            this.imageIndentLeft = 0.0f;
            this.imageIndentRight = 0.0f;
            this.footer.setPageNumber(this.pageN);
            this.leading = this.footer.paragraph().leading();
            this.add(this.footer.paragraph());
            this.indentBottom = this.currentHeight;
            this.text.moveText(this.left(), this.indentBottom());
            this.flushLines();
            this.text.moveText(-this.left(), -this.bottom());
            this.footer.setTop(this.bottom(this.currentHeight));
            this.footer.setBottom(this.bottom() - 0.75f * this.leading);
            this.footer.setLeft(this.left());
            this.footer.setRight(this.right());
            this.graphics.rectangle(this.footer);
            this.indentBottom = this.currentHeight + this.leading * 2.0f;
            this.currentHeight = 0.0f;
            this.indentLeft = tmpIndentLeft;
            this.indentRight = tmpIndentRight;
            this.listIndentLeft = tmpListIndentLeft;
            this.imageIndentLeft = tmpImageIndentLeft;
            this.imageIndentRight = tmpImageIndentRight;
        }
        this.text.moveText(this.left(), this.top());
        if (this.header != null) {
            float tmpIndentLeft = this.indentLeft;
            tmpIndentRight = this.indentRight;
            tmpListIndentLeft = this.listIndentLeft;
            tmpImageIndentLeft = this.imageIndentLeft;
            tmpImageIndentRight = this.imageIndentRight;
            this.indentRight = 0.0f;
            this.indentLeft = 0.0f;
            this.listIndentLeft = 0.0f;
            this.imageIndentLeft = 0.0f;
            this.imageIndentRight = 0.0f;
            this.header.setPageNumber(this.pageN);
            this.leading = this.header.paragraph().leading();
            this.text.moveText(0.0f, this.leading);
            this.add(this.header.paragraph());
            this.newLine();
            this.indentTop = this.currentHeight - this.leading;
            this.header.setTop(this.top() + this.leading);
            this.header.setBottom(this.indentTop() + this.leading * 2.0f / 3.0f);
            this.header.setLeft(this.left());
            this.header.setRight(this.right());
            this.graphics.rectangle(this.header);
            this.flushLines();
            this.currentHeight = 0.0f;
            this.indentLeft = tmpIndentLeft;
            this.indentRight = tmpIndentRight;
            this.listIndentLeft = tmpListIndentLeft;
            this.imageIndentLeft = tmpImageIndentLeft;
            this.imageIndentRight = tmpImageIndentRight;
        }
        this.pageEmpty = true;
        try {
            if (this.imageWait != null) {
                this.add(this.imageWait);
                this.imageWait = null;
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        this.leading = oldleading;
        this.alignment = oldAlignment;
        this.carriageReturn();
        PdfPageEvent pageEvent = this.writer.getPageEvent();
        if (pageEvent != null) {
            if (this.firstPageEvent) {
                pageEvent.onOpenDocument(this.writer, this);
            }
            pageEvent.onStartPage(this.writer, this);
        }
        this.firstPageEvent = false;
    }

    boolean isStrictImageSequence() {
        return this.strictImageSequence;
    }

    boolean localDestination(String name, PdfDestination destination) {
        Object[] obj = (Object[])this.localDestinations.get(name);
        if (obj == null) {
            obj = new Object[3];
        }
        if (obj[2] != null) {
            return false;
        }
        obj[2] = destination;
        this.localDestinations.put(name, obj);
        destination.addPage(this.writer.getCurrentPage());
        return true;
    }

    void localGoto(String name, float llx, float lly, float urx, float ury) {
        PdfAction action = this.getLocalGotoAction(name);
        this.annotations.add(new PdfAnnotation(this.writer, llx, lly, urx, ury, action));
    }

    private boolean mayBeRemoved(ArrayList row) {
        Iterator iterator = row.iterator();
        boolean mayBeRemoved = true;
        while (iterator.hasNext()) {
            PdfCell cell = (PdfCell)iterator.next();
            mayBeRemoved &= cell.mayBeRemoved();
        }
        return mayBeRemoved;
    }

    private void newLine() throws DocumentException {
        this.lastElementType = -1;
        this.carriageReturn();
        if (this.lines != null && this.lines.size() > 0) {
            this.lines.add(this.line);
            this.currentHeight += this.line.height();
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    public boolean newPage() throws DocumentException {
        PdfArray array;
        this.lastElementType = -1;
        this.isNewpage = true;
        if (this.writer.getDirectContent().size() == 0 && this.writer.getDirectContentUnder().size() == 0 && (this.pageEmpty || this.writer != null && this.writer.isPaused())) {
            return false;
        }
        PdfPageEvent pageEvent = this.writer.getPageEvent();
        if (pageEvent != null) {
            pageEvent.onEndPage(this.writer, this);
        }
        super.newPage();
        this.imageIndentLeft = 0.0f;
        this.imageIndentRight = 0.0f;
        this.flushLines();
        this.pageResources.addDefaultColorDiff(this.writer.getDefaultColorspace());
        PdfDictionary resources = this.pageResources.getResources();
        if (this.writer.getPDFXConformance() != 0) {
            if (this.thisBoxSize.containsKey("art") && this.thisBoxSize.containsKey("trim")) {
                throw new PdfXConformanceException("Only one of ArtBox or TrimBox can exist in the page.");
            }
            if (!this.thisBoxSize.containsKey("art") && !this.thisBoxSize.containsKey("trim")) {
                if (this.thisBoxSize.containsKey("crop")) {
                    this.thisBoxSize.put("trim", this.thisBoxSize.get("crop"));
                } else {
                    this.thisBoxSize.put("trim", new PdfRectangle(this.pageSize, this.pageSize.getRotation()));
                }
            }
        }
        int rotation = this.pageSize.getRotation();
        PdfPage page = new PdfPage(new PdfRectangle(this.pageSize, rotation), this.thisBoxSize, resources, rotation);
        if (this.writer.isTagged()) {
            page.put(PdfName.STRUCTPARENTS, new PdfNumber(this.writer.getCurrentPageNumber() - 1));
        }
        if (this.transition != null) {
            page.put(PdfName.TRANS, this.transition.getTransitionDictionary());
            this.transition = null;
        }
        if (this.duration > 0) {
            page.put(PdfName.DUR, new PdfNumber(this.duration));
            this.duration = 0;
        }
        if (this.pageAA != null) {
            try {
                page.put(PdfName.AA, this.writer.addToBody(this.pageAA).getIndirectReference());
            }
            catch (IOException ioe) {
                throw new ExceptionConverter(ioe);
            }
            this.pageAA = null;
        }
        if (this.writer.getUserunit() > 0.0f) {
            page.put(PdfName.USERUNIT, new PdfNumber(this.writer.getUserunit()));
        }
        if (this.annotations.size() > 0 && (array = this.rotateAnnotations()).size() != 0) {
            page.put(PdfName.ANNOTS, array);
        }
        if (this.thumb != null) {
            page.put(PdfName.THUMB, this.thumb);
            this.thumb = null;
        }
        if (!this.open || this.close) {
            throw new PdfException("The document isn't open.");
        }
        if (this.text.size() > this.textEmptySize) {
            this.text.endText();
        } else {
            this.text = null;
        }
        this.writer.add(page, new PdfContents(this.writer.getDirectContentUnder(), this.graphics, this.text, this.writer.getDirectContent(), this.pageSize));
        this.initPage();
        this.isNewpage = false;
        return true;
    }

    public void open() {
        if (!this.open) {
            super.open();
            this.writer.open();
            this.currentOutline = this.rootOutline = new PdfOutline(this.writer);
        }
        try {
            this.initPage();
        }
        catch (DocumentException de) {
            throw new ExceptionConverter(de);
        }
    }

    void outlineTree(PdfOutline outline) throws IOException {
        outline.setIndirectReference(this.writer.getPdfIndirectReference());
        if (outline.parent() != null) {
            outline.put(PdfName.PARENT, outline.parent().indirectReference());
        }
        ArrayList kids = outline.getKids();
        int size = kids.size();
        int k = 0;
        while (k < size) {
            this.outlineTree((PdfOutline)kids.get(k));
            ++k;
        }
        int k2 = 0;
        while (k2 < size) {
            if (k2 > 0) {
                ((PdfOutline)kids.get(k2)).put(PdfName.PREV, ((PdfOutline)kids.get(k2 - 1)).indirectReference());
            }
            if (k2 < size - 1) {
                ((PdfOutline)kids.get(k2)).put(PdfName.NEXT, ((PdfOutline)kids.get(k2 + 1)).indirectReference());
            }
            ++k2;
        }
        if (size > 0) {
            outline.put(PdfName.FIRST, ((PdfOutline)kids.get(0)).indirectReference());
            outline.put(PdfName.LAST, ((PdfOutline)kids.get(size - 1)).indirectReference());
        }
        int k3 = 0;
        while (k3 < size) {
            PdfOutline kid = (PdfOutline)kids.get(k3);
            this.writer.addToBody((PdfObject)kid, kid.indirectReference());
            ++k3;
        }
    }

    void remoteGoto(String filename, int page, float llx, float lly, float urx, float ury) {
        this.writer.addAnnotation(new PdfAnnotation(this.writer, llx, lly, urx, ury, new PdfAction(filename, page)));
    }

    void remoteGoto(String filename, String name, float llx, float lly, float urx, float ury) {
        this.annotations.add(new PdfAnnotation(this.writer, llx, lly, urx, ury, new PdfAction(filename, name)));
    }

    public void removeWatermark() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        this.watermark = null;
    }

    private void renderCells(RenderingContext ctx, java.util.List cells, boolean hasToFit) throws DocumentException {
        PdfCell cell;
        Iterator iterator;
        if (hasToFit) {
            iterator = cells.iterator();
            while (iterator.hasNext()) {
                cell = (PdfCell)iterator.next();
                if (cell.isHeader() || !(cell.bottom() < this.indentBottom())) continue;
                return;
            }
        }
        iterator = cells.iterator();
        while (iterator.hasNext()) {
            cell = (PdfCell)iterator.next();
            if (ctx.isCellRenderedOnPage(cell, this.getPageNumber())) continue;
            float correction = 0.0f;
            if (ctx.numCellRendered(cell) >= 1) {
                correction = 1.0f;
            }
            this.lines = cell.getLines(ctx.pagetop, this.indentBottom() - correction);
            if (this.lines != null && this.lines.size() > 0) {
                float cellTop = cell.top(ctx.pagetop - ctx.oldHeight);
                this.text.moveText(0.0f, cellTop);
                float cellDisplacement = this.flushLines() - cellTop;
                this.text.moveText(0.0f, cellDisplacement);
                if (ctx.oldHeight + cellDisplacement > this.currentHeight) {
                    this.currentHeight = ctx.oldHeight + cellDisplacement;
                }
                ctx.cellRendered(cell, this.getPageNumber());
            }
            float indentBottom = Math.max(cell.bottom(), this.indentBottom());
            Rectangle tableRect = ctx.table.rectangle(ctx.pagetop, this.indentBottom());
            indentBottom = Math.max(tableRect.bottom(), indentBottom);
            Rectangle cellRect = cell.rectangle(tableRect.top(), indentBottom);
            if (cellRect.height() > 0.0f) {
                ctx.lostTableBottom = indentBottom;
                ctx.cellGraphics.rectangle(cellRect);
            }
            ArrayList images = cell.getImages(ctx.pagetop, this.indentBottom());
            Iterator i = images.iterator();
            while (i.hasNext()) {
                Image image = (Image)i.next();
                this.graphics.addImage(image);
            }
        }
    }

    public void resetFooter() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetFooter();
    }

    public void resetHeader() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetHeader();
    }

    public void resetPageCount() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetPageCount();
    }

    protected PdfArray rotateAnnotations() {
        PdfArray array = new PdfArray();
        int rotation = this.pageSize.getRotation() % 360;
        int currentPage = this.writer.getCurrentPageNumber();
        int k = 0;
        while (k < this.annotations.size()) {
            PdfAnnotation dic = (PdfAnnotation)this.annotations.get(k);
            int page = dic.getPlaceInPage();
            if (page > currentPage) {
                this.delayedAnnotations.add(dic);
            } else {
                if (dic.isForm()) {
                    PdfFormField field;
                    HashMap templates;
                    if (!dic.isUsed() && (templates = dic.getTemplates()) != null) {
                        this.acroForm.addFieldTemplates(templates);
                    }
                    if ((field = (PdfFormField)dic).getParent() == null) {
                        this.acroForm.addDocumentField(field.getIndirectReference());
                    }
                }
                if (dic.isAnnotation()) {
                    PdfRectangle rect;
                    array.add(dic.getIndirectReference());
                    if (!dic.isUsed() && (rect = (PdfRectangle)dic.get(PdfName.RECT)) != null) {
                        switch (rotation) {
                            case 90: {
                                dic.put(PdfName.RECT, new PdfRectangle(this.pageSize.top() - rect.bottom(), rect.left(), this.pageSize.top() - rect.top(), rect.right()));
                                break;
                            }
                            case 180: {
                                dic.put(PdfName.RECT, new PdfRectangle(this.pageSize.right() - rect.left(), this.pageSize.top() - rect.bottom(), this.pageSize.right() - rect.right(), this.pageSize.top() - rect.top()));
                                break;
                            }
                            case 270: {
                                dic.put(PdfName.RECT, new PdfRectangle(rect.bottom(), this.pageSize.right() - rect.left(), rect.top(), this.pageSize.right() - rect.right()));
                            }
                        }
                    }
                }
                if (!dic.isUsed()) {
                    dic.setUsed();
                    try {
                        this.writer.addToBody((PdfObject)dic, dic.getIndirectReference());
                    }
                    catch (IOException e) {
                        throw new ExceptionConverter(e);
                    }
                }
            }
            ++k;
        }
        return array;
    }

    void setAction(PdfAction action, float llx, float lly, float urx, float ury) {
        this.writer.addAnnotation(new PdfAnnotation(this.writer, llx, lly, urx, ury, action));
    }

    void setBoxSize(String boxName, Rectangle size) {
        if (size == null) {
            this.boxSize.remove(boxName);
        } else {
            this.boxSize.put(boxName, new PdfRectangle(size));
        }
    }

    void setCropBoxSize(Rectangle crop) {
        this.setBoxSize("crop", crop);
    }

    void setDuration(int seconds) {
        this.duration = seconds > 0 ? seconds : -1;
    }

    public void setFooter(HeaderFooter footer) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setFooter(footer);
    }

    public void setHeader(HeaderFooter header) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setHeader(header);
    }

    public boolean setMarginMirroring(boolean MarginMirroring) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        return super.setMarginMirroring(MarginMirroring);
    }

    public boolean setMargins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.nextMarginLeft = marginLeft;
        this.nextMarginRight = marginRight;
        this.nextMarginTop = marginTop;
        this.nextMarginBottom = marginBottom;
        return true;
    }

    void setOpenAction(PdfAction action) {
        this.openActionAction = action;
        this.openActionName = null;
    }

    void setOpenAction(String name) {
        this.openActionName = name;
        this.openActionAction = null;
    }

    void setPageAction(PdfName actionType, PdfAction action) {
        if (this.pageAA == null) {
            this.pageAA = new PdfDictionary();
        }
        this.pageAA.put(actionType, action);
    }

    public void setPageCount(int pageN) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setPageCount(pageN);
    }

    void setPageEmpty(boolean pageEmpty) {
        this.pageEmpty = pageEmpty;
    }

    void setPageLabels(PdfPageLabels pageLabels) {
        this.pageLabels = pageLabels;
    }

    public boolean setPageSize(Rectangle pageSize) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.nextPageSize = new Rectangle(pageSize);
        return true;
    }

    void setSigFlags(int f) {
        this.acroForm.setSigFlags(f);
    }

    void setStrictImageSequence(boolean strictImageSequence) {
        this.strictImageSequence = strictImageSequence;
    }

    void setThumbnail(Image image) throws PdfException, DocumentException {
        this.thumb = this.writer.getImageReference(this.writer.addDirectImageSimple(image));
    }

    void setTransition(PdfTransition transition) {
        this.transition = transition;
    }

    public void setViewerPreferences(int preferences) {
        this.viewerPreferences |= preferences;
    }

    void traverseOutlineCount(PdfOutline outline) {
        ArrayList kids = outline.getKids();
        PdfOutline parent = outline.parent();
        if (kids.size() == 0) {
            if (parent != null) {
                parent.setCount(parent.getCount() + 1);
            }
        } else {
            int k = 0;
            while (k < kids.size()) {
                this.traverseOutlineCount((PdfOutline)kids.get(k));
                ++k;
            }
            if (parent != null) {
                if (outline.isOpen()) {
                    parent.setCount(outline.getCount() + parent.getCount() + 1);
                } else {
                    parent.setCount(parent.getCount() + 1);
                    outline.setCount(-outline.getCount());
                }
            }
        }
    }

    void writeLineToContent(PdfLine line, PdfContentByte text, PdfContentByte graphics, Object[] currentValues, float ratio) throws DocumentException {
        float xMarker;
        boolean isJustified;
        PdfFont currentFont = (PdfFont)currentValues[0];
        float lastBaseFactor = ((Float)currentValues[1]).floatValue();
        float hangingCorrection = 0.0f;
        float hScale = 1.0f;
        float lastHScale = Float.NaN;
        float baseWordSpacing = 0.0f;
        float baseCharacterSpacing = 0.0f;
        int numberOfSpaces = line.numberOfSpaces();
        int lineLen = line.toString().length();
        boolean bl = isJustified = line.hasToBeJustified() && (numberOfSpaces != 0 || lineLen > 1);
        if (isJustified) {
            if (line.isNewlineSplit() && line.widthLeft() >= lastBaseFactor * (ratio * (float)numberOfSpaces + (float)lineLen - 1.0f)) {
                if (line.isRTL()) {
                    text.moveText(line.widthLeft() - lastBaseFactor * (ratio * (float)numberOfSpaces + (float)lineLen - 1.0f), 0.0f);
                }
                baseWordSpacing = ratio * lastBaseFactor;
                baseCharacterSpacing = lastBaseFactor;
            } else {
                char c;
                String s;
                float width = line.widthLeft();
                PdfChunk last = line.getChunk(line.size() - 1);
                if (last != null && (s = last.toString()).length() > 0 && hangingPunctuation.indexOf(c = s.charAt(s.length() - 1)) >= 0) {
                    float oldWidth = width;
                    hangingCorrection = (width += last.font().width(c) * 0.4f) - oldWidth;
                }
                float baseFactor = width / (ratio * (float)numberOfSpaces + (float)lineLen - 1.0f);
                baseWordSpacing = ratio * baseFactor;
                baseCharacterSpacing = baseFactor;
                lastBaseFactor = baseFactor;
            }
        }
        int lastChunkStroke = line.getLastStrokeChunk();
        int chunkStrokeIdx = 0;
        float baseXMarker = xMarker = text.getXTLM();
        float yMarker = text.getYTLM();
        boolean adjustMatrix = false;
        Iterator j = line.iterator();
        while (j.hasNext()) {
            PdfChunk chunk = (PdfChunk)j.next();
            Color color = chunk.color();
            hScale = 1.0f;
            if (chunkStrokeIdx <= lastChunkStroke) {
                float width = isJustified ? chunk.getWidthCorrected(baseCharacterSpacing, baseWordSpacing) : chunk.width();
                if (chunk.isStroked()) {
                    float descender;
                    float ascender;
                    float subtract;
                    PdfChunk nextChunk = line.getChunk(chunkStrokeIdx + 1);
                    if (chunk.isAttribute("BACKGROUND")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("BACKGROUND")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        float fontSize = chunk.font().size();
                        ascender = chunk.font().getFont().getFontDescriptor(1, fontSize);
                        descender = chunk.font().getFont().getFontDescriptor(3, fontSize);
                        Object[] bgr = (Object[])chunk.getAttribute("BACKGROUND");
                        graphics.setColorFill((Color)bgr[0]);
                        float[] extra = (float[])bgr[1];
                        graphics.rectangle(xMarker - extra[0], yMarker + descender - extra[1] + chunk.getTextRise(), width - subtract + extra[0] + extra[2], ascender - descender + extra[1] + extra[3]);
                        graphics.fill();
                        graphics.setGrayFill(0.0f);
                    }
                    if (chunk.isAttribute("UNDERLINE")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("UNDERLINE")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        Object[][] unders = (Object[][])chunk.getAttribute("UNDERLINE");
                        Color scolor = null;
                        int k = 0;
                        while (k < unders.length) {
                            Object[] obj = unders[k];
                            scolor = (Color)obj[0];
                            float[] ps = (float[])obj[1];
                            if (scolor == null) {
                                scolor = color;
                            }
                            if (scolor != null) {
                                graphics.setColorStroke(scolor);
                            }
                            float fsize = chunk.font().size();
                            graphics.setLineWidth(ps[0] + fsize * ps[1]);
                            float shift = ps[2] + fsize * ps[3];
                            int cap2 = (int)ps[4];
                            if (cap2 != 0) {
                                graphics.setLineCap(cap2);
                            }
                            graphics.moveTo(xMarker, yMarker + shift);
                            graphics.lineTo(xMarker + width - subtract, yMarker + shift);
                            graphics.stroke();
                            if (scolor != null) {
                                graphics.resetGrayStroke();
                            }
                            if (cap2 != 0) {
                                graphics.setLineCap(0);
                            }
                            ++k;
                        }
                        graphics.setLineWidth(1.0f);
                    }
                    if (chunk.isAttribute("ACTION")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("ACTION")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        text.addAnnotation(new PdfAnnotation(this.writer, xMarker, yMarker, xMarker + width - subtract, yMarker + chunk.font().size(), (PdfAction)chunk.getAttribute("ACTION")));
                    }
                    if (chunk.isAttribute("REMOTEGOTO")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("REMOTEGOTO")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        Object[] obj = (Object[])chunk.getAttribute("REMOTEGOTO");
                        String filename = (String)obj[0];
                        if (obj[1] instanceof String) {
                            this.remoteGoto(filename, (String)obj[1], xMarker, yMarker, xMarker + width - subtract, yMarker + chunk.font().size());
                        } else {
                            this.remoteGoto(filename, (Integer)obj[1], xMarker, yMarker, xMarker + width - subtract, yMarker + chunk.font().size());
                        }
                    }
                    if (chunk.isAttribute("LOCALGOTO")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("LOCALGOTO")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        this.localGoto((String)chunk.getAttribute("LOCALGOTO"), xMarker, yMarker, xMarker + width - subtract, yMarker + chunk.font().size());
                    }
                    if (chunk.isAttribute("LOCALDESTINATION")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("LOCALDESTINATION")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        this.localDestination((String)chunk.getAttribute("LOCALDESTINATION"), new PdfDestination(0, xMarker, yMarker + chunk.font().size(), 0.0f));
                    }
                    if (chunk.isAttribute("GENERICTAG")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("GENERICTAG")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        Rectangle rect = new Rectangle(xMarker, yMarker, xMarker + width - subtract, yMarker + chunk.font().size());
                        PdfPageEvent pev = this.writer.getPageEvent();
                        if (pev != null) {
                            pev.onGenericTag(this.writer, this, rect, (String)chunk.getAttribute("GENERICTAG"));
                        }
                    }
                    if (chunk.isAttribute("PDFANNOTATION")) {
                        subtract = lastBaseFactor;
                        if (nextChunk != null && nextChunk.isAttribute("PDFANNOTATION")) {
                            subtract = 0.0f;
                        }
                        if (nextChunk == null) {
                            subtract += hangingCorrection;
                        }
                        float fontSize = chunk.font().size();
                        ascender = chunk.font().getFont().getFontDescriptor(1, fontSize);
                        descender = chunk.font().getFont().getFontDescriptor(3, fontSize);
                        PdfAnnotation annot = PdfFormField.shallowDuplicate((PdfAnnotation)chunk.getAttribute("PDFANNOTATION"));
                        annot.put(PdfName.RECT, new PdfRectangle(xMarker, yMarker + descender, xMarker + width - subtract, yMarker + ascender));
                        text.addAnnotation(annot);
                    }
                    float[] params = (float[])chunk.getAttribute("SKEW");
                    Float hs = (Float)chunk.getAttribute("HSCALE");
                    if (params != null || hs != null) {
                        float b = 0.0f;
                        float c = 0.0f;
                        if (params != null) {
                            b = params[0];
                            c = params[1];
                        }
                        if (hs != null) {
                            hScale = hs.floatValue();
                        }
                        text.setTextMatrix(hScale, b, c, 1.0f, xMarker, yMarker);
                    }
                    if (chunk.isImage()) {
                        Image image = chunk.getImage();
                        float[] matrix = image.matrix();
                        matrix[4] = xMarker + chunk.getImageOffsetX() - matrix[4];
                        matrix[5] = yMarker + chunk.getImageOffsetY() - matrix[5];
                        graphics.addImage(image, matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
                        text.moveText(xMarker + lastBaseFactor + image.scaledWidth() - text.getXTLM(), 0.0f);
                    }
                }
                xMarker += width;
                ++chunkStrokeIdx;
            }
            if (chunk.font().compareTo(currentFont) != 0) {
                currentFont = chunk.font();
                text.setFontAndSize(currentFont.getFont(), currentFont.size());
            }
            float rise = 0.0f;
            Object[] textRender = (Object[])chunk.getAttribute("TEXTRENDERMODE");
            int tr = 0;
            float strokeWidth = 1.0f;
            Color strokeColor = null;
            Float fr = (Float)chunk.getAttribute("SUBSUPSCRIPT");
            if (textRender != null) {
                tr = (Integer)textRender[0] & 3;
                if (tr != 0) {
                    text.setTextRenderingMode(tr);
                }
                if (tr == 1 || tr == 2) {
                    strokeWidth = ((Float)textRender[1]).floatValue();
                    if (strokeWidth != 1.0f) {
                        text.setLineWidth(strokeWidth);
                    }
                    if ((strokeColor = (Color)textRender[2]) == null) {
                        strokeColor = color;
                    }
                    if (strokeColor != null) {
                        text.setColorStroke(strokeColor);
                    }
                }
            }
            if (fr != null) {
                rise = fr.floatValue();
            }
            if (color != null) {
                text.setColorFill(color);
            }
            if (rise != 0.0f) {
                text.setTextRise(rise);
            }
            if (chunk.isImage()) {
                adjustMatrix = true;
            } else if (isJustified && numberOfSpaces > 0 && chunk.isSpecialEncoding()) {
                String s;
                int idx;
                if (hScale != lastHScale) {
                    lastHScale = hScale;
                    text.setWordSpacing(baseWordSpacing / hScale);
                    text.setCharacterSpacing(baseCharacterSpacing / hScale);
                }
                if ((idx = (s = chunk.toString()).indexOf(32)) < 0) {
                    text.showText(chunk.toString());
                } else {
                    float spaceCorrection = -baseWordSpacing * 1000.0f / chunk.font.size() / hScale;
                    PdfTextArray textArray = new PdfTextArray(s.substring(0, idx));
                    int lastIdx = idx;
                    while ((idx = s.indexOf(32, lastIdx + 1)) >= 0) {
                        textArray.add(spaceCorrection);
                        textArray.add(s.substring(lastIdx, idx));
                        lastIdx = idx;
                    }
                    textArray.add(spaceCorrection);
                    textArray.add(s.substring(lastIdx));
                    text.showText(textArray);
                }
            } else {
                if (isJustified && hScale != lastHScale) {
                    lastHScale = hScale;
                    text.setWordSpacing(baseWordSpacing / hScale);
                    text.setCharacterSpacing(baseCharacterSpacing / hScale);
                }
                text.showText(chunk.toString());
            }
            if (rise != 0.0f) {
                text.setTextRise(0.0f);
            }
            if (color != null) {
                text.resetRGBColorFill();
            }
            if (tr != 0) {
                text.setTextRenderingMode(0);
            }
            if (strokeColor != null) {
                text.resetRGBColorStroke();
            }
            if (strokeWidth != 1.0f) {
                text.setLineWidth(1.0f);
            }
            if (!chunk.isAttribute("SKEW") && !chunk.isAttribute("HSCALE")) continue;
            adjustMatrix = true;
            text.setTextMatrix(xMarker, yMarker);
        }
        if (isJustified) {
            text.setWordSpacing(0.0f);
            text.setCharacterSpacing(0.0f);
            if (line.isNewlineSplit()) {
                lastBaseFactor = 0.0f;
            }
        }
        if (adjustMatrix) {
            text.moveText(baseXMarker - text.getXTLM(), 0.0f);
        }
        currentValues[0] = currentFont;
        currentValues[1] = new Float(lastBaseFactor);
    }

    void writeOutlines() throws IOException {
        if (this.rootOutline.getKids().size() == 0) {
            return;
        }
        this.outlineTree(this.rootOutline);
        this.writer.addToBody((PdfObject)this.rootOutline, this.rootOutline.indirectReference());
    }

    private static class RenderingContext {
        PdfContentByte cellGraphics = null;
        int countPageBreaks = 0;
        float lostTableBottom;
        float maxCellBottom;
        float maxCellHeight;
        float oldHeight = -1.0f;
        Map pageMap = new HashMap();
        float pagetop = -1.0f;
        Map rowspanMap;
        public PdfTable table;

        private RenderingContext() {
        }

        public int cellRendered(PdfCell cell, int pageNumber) {
            Integer i = (Integer)this.pageMap.get(cell);
            i = i == null ? new Integer(1) : new Integer(i + 1);
            this.pageMap.put(cell, i);
            Integer pageInteger = new Integer(pageNumber);
            HashSet<PdfCell> set = (HashSet<PdfCell>)this.pageMap.get(pageInteger);
            if (set == null) {
                set = new HashSet<PdfCell>();
                this.pageMap.put(pageInteger, set);
            }
            set.add(cell);
            return i;
        }

        public int consumeRowspan(PdfCell c) {
            if (c.rowspan() == 1) {
                return 1;
            }
            Integer i = (Integer)this.rowspanMap.get(c);
            if (i == null) {
                i = new Integer(c.rowspan());
            }
            i = new Integer(i - 1);
            this.rowspanMap.put(c, i);
            if (i < 1) {
                return 1;
            }
            return i;
        }

        public int currentRowspan(PdfCell c) {
            Integer i = (Integer)this.rowspanMap.get(c);
            if (i == null) {
                return c.rowspan();
            }
            return i;
        }

        public boolean isCellRenderedOnPage(PdfCell cell, int pageNumber) {
            Integer pageInteger = new Integer(pageNumber);
            Set set = (Set)this.pageMap.get(pageInteger);
            if (set != null) {
                return set.contains(cell);
            }
            return false;
        }

        public int numCellRendered(PdfCell cell) {
            Integer i = (Integer)this.pageMap.get(cell);
            if (i == null) {
                i = new Integer(0);
            }
            return i;
        }
    }

    static class PdfCatalog
    extends PdfDictionary {
        PdfWriter writer;

        PdfCatalog(PdfIndirectReference pages, PdfIndirectReference outlines, PdfWriter writer) {
            super(PdfDictionary.CATALOG);
            this.writer = writer;
            this.put(PdfName.PAGES, pages);
            this.put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
            this.put(PdfName.OUTLINES, outlines);
        }

        PdfCatalog(PdfIndirectReference pages, PdfWriter writer) {
            super(PdfDictionary.CATALOG);
            this.writer = writer;
            this.put(PdfName.PAGES, pages);
        }

        void addNames(TreeMap localDestinations, ArrayList documentJavaScript, HashMap documentFileAttachment, PdfWriter writer) {
            if (localDestinations.size() == 0 && documentJavaScript.size() == 0 && documentFileAttachment.size() == 0) {
                return;
            }
            try {
                PdfDictionary names = new PdfDictionary();
                if (localDestinations.size() > 0) {
                    PdfArray ar = new PdfArray();
                    Iterator i = localDestinations.keySet().iterator();
                    while (i.hasNext()) {
                        String name = (String)i.next();
                        Object[] obj = (Object[])localDestinations.get(name);
                        PdfIndirectReference ref = (PdfIndirectReference)obj[1];
                        ar.add(new PdfString(name));
                        ar.add(ref);
                    }
                    PdfDictionary dests = new PdfDictionary();
                    dests.put(PdfName.NAMES, ar);
                    names.put(PdfName.DESTS, writer.addToBody(dests).getIndirectReference());
                }
                if (documentJavaScript.size() > 0) {
                    String[] s = new String[documentJavaScript.size()];
                    int k = 0;
                    while (k < s.length) {
                        s[k] = Integer.toHexString(k);
                        ++k;
                    }
                    Arrays.sort(s, new StringCompare());
                    PdfArray ar = new PdfArray();
                    int k2 = 0;
                    while (k2 < s.length) {
                        ar.add(new PdfString(s[k2]));
                        ar.add((PdfIndirectReference)documentJavaScript.get(k2));
                        ++k2;
                    }
                    PdfDictionary js = new PdfDictionary();
                    js.put(PdfName.NAMES, ar);
                    names.put(PdfName.JAVASCRIPT, writer.addToBody(js).getIndirectReference());
                }
                if (documentFileAttachment.size() > 0) {
                    names.put(PdfName.EMBEDDEDFILES, writer.addToBody(PdfNameTree.writeTree(documentFileAttachment, writer)).getIndirectReference());
                }
                this.put(PdfName.NAMES, writer.addToBody(names).getIndirectReference());
            }
            catch (IOException e) {
                throw new ExceptionConverter(e);
            }
        }

        void setAcroForm(PdfObject fields) {
            this.put(PdfName.ACROFORM, fields);
        }

        void setAdditionalActions(PdfDictionary actions) {
            try {
                this.put(PdfName.AA, this.writer.addToBody(actions).getIndirectReference());
            }
            catch (Exception e) {
                new ExceptionConverter(e);
            }
        }

        void setOpenAction(PdfAction action) {
            this.put(PdfName.OPENACTION, action);
        }

        void setPageLabels(PdfPageLabels pageLabels) {
            this.put(PdfName.PAGELABELS, pageLabels.getDictionary());
        }

        void setViewerPreferences(int preferences) {
            PdfReader.setViewerPreferences(preferences, this);
        }
    }

    public static class PdfInfo
    extends PdfDictionary {
        PdfInfo(String author, String title, String subject) {
            this();
            this.addTitle(title);
            this.addSubject(subject);
            this.addAuthor(author);
        }

        PdfInfo() {
            this.addProducer();
            this.addCreationDate();
        }

        void addAuthor(String author) {
            this.put(PdfName.AUTHOR, new PdfString(author, "UnicodeBig"));
        }

        void addCreationDate() {
            PdfDate date = new PdfDate();
            this.put(PdfName.CREATIONDATE, date);
            this.put(PdfName.MODDATE, date);
        }

        void addCreator(String creator) {
            this.put(PdfName.CREATOR, new PdfString(creator, "UnicodeBig"));
        }

        void addKeywords(String keywords) {
            this.put(PdfName.KEYWORDS, new PdfString(keywords, "UnicodeBig"));
        }

        void addProducer() {
            this.put(PdfName.PRODUCER, new PdfString(Document.getVersion()));
        }

        void addSubject(String subject) {
            this.put(PdfName.SUBJECT, new PdfString(subject, "UnicodeBig"));
        }

        void addTitle(String title) {
            this.put(PdfName.TITLE, new PdfString(title, "UnicodeBig"));
        }

        void addkey(String key, String value) {
            if (key.equals("Producer") || key.equals("CreationDate")) {
                return;
            }
            this.put(new PdfName(key), new PdfString(value, "UnicodeBig"));
        }
    }
}

