/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.pdf.ByteBuffer;
import com.lowagie2.text.pdf.PdfContentByte;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfLiteral;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfNumber;
import com.lowagie2.text.pdf.PdfObject;
import java.security.MessageDigest;

public class PdfEncryption {
    byte[] documentID;
    byte[] extra;
    byte[] key;
    int keySize;
    MessageDigest md5;
    byte[] mkey;
    byte[] ownerKey;
    static final byte[] pad = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    int permissions;
    static long seq = System.currentTimeMillis();
    byte[] state = new byte[256];
    byte[] userKey;
    int x;
    int y;

    public PdfEncryption(PdfEncryption enc) {
        this();
        this.mkey = (byte[])enc.mkey.clone();
        this.ownerKey = (byte[])enc.ownerKey.clone();
        this.userKey = (byte[])enc.userKey.clone();
        this.permissions = enc.permissions;
        if (enc.documentID != null) {
            this.documentID = (byte[])enc.documentID.clone();
        }
    }

    public PdfEncryption() {
        this.extra = new byte[5];
        this.ownerKey = new byte[32];
        this.userKey = new byte[32];
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    private byte[] computeOwnerKey(byte[] userPad, byte[] ownerPad, int keylength, int revision) {
        byte[] ownerKey = new byte[32];
        byte[] digest = this.md5.digest(ownerPad);
        if (revision == 3) {
            byte[] mkey = new byte[keylength / 8];
            int k = 0;
            while (k < 50) {
                System.arraycopy(this.md5.digest(digest), 0, digest, 0, mkey.length);
                ++k;
            }
            System.arraycopy(userPad, 0, ownerKey, 0, 32);
            int i = 0;
            while (i < 20) {
                int j = 0;
                while (j < mkey.length) {
                    mkey[j] = (byte)(digest[j] ^ i);
                    ++j;
                }
                this.prepareRC4Key(mkey);
                this.encryptRC4(ownerKey);
                ++i;
            }
        } else {
            this.prepareRC4Key(digest, 0, 5);
            this.encryptRC4(userPad, ownerKey);
        }
        return ownerKey;
    }

    public static byte[] createDocumentId() {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        long time = System.currentTimeMillis();
        long mem = Runtime.getRuntime().freeMemory();
        String s = time + "+" + mem + "+" + seq++;
        return md5.digest(s.getBytes());
    }

    public static PdfObject createInfoId(byte[] id) {
        ByteBuffer buf = new ByteBuffer(90);
        buf.append('[').append('<');
        int k = 0;
        while (k < 16) {
            buf.appendHex(id[k]);
            ++k;
        }
        buf.append('>').append('<');
        id = PdfEncryption.createDocumentId();
        int k2 = 0;
        while (k2 < 16) {
            buf.appendHex(id[k2]);
            ++k2;
        }
        buf.append('>').append(']');
        return new PdfLiteral(buf.toByteArray());
    }

    public void encryptRC4(byte[] data) {
        this.encryptRC4(data, 0, data.length, data);
    }

    public void encryptRC4(byte[] dataIn, byte[] dataOut) {
        this.encryptRC4(dataIn, 0, dataIn.length, dataOut);
    }

    public void encryptRC4(byte[] data, int off, int len) {
        this.encryptRC4(data, off, len, data);
    }

    public void encryptRC4(byte[] dataIn, int off, int len, byte[] dataOut) {
        int length = len + off;
        int k = off;
        while (k < length) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.state[this.x] + this.y & 0xFF;
            byte tmp = this.state[this.x];
            this.state[this.x] = this.state[this.y];
            this.state[this.y] = tmp;
            dataOut[k] = (byte)(dataIn[k] ^ this.state[this.state[this.x] + this.state[this.y] & 0xFF]);
            ++k;
        }
    }

    public PdfDictionary getEncryptionDictionary() {
        PdfDictionary dic = new PdfDictionary();
        dic.put(PdfName.FILTER, PdfName.STANDARD);
        dic.put(PdfName.O, new PdfLiteral(PdfContentByte.escapeString(this.ownerKey)));
        dic.put(PdfName.U, new PdfLiteral(PdfContentByte.escapeString(this.userKey)));
        dic.put(PdfName.P, new PdfNumber(this.permissions));
        if (this.mkey.length > 5) {
            dic.put(PdfName.V, new PdfNumber(2));
            dic.put(PdfName.R, new PdfNumber(3));
            dic.put(PdfName.LENGTH, new PdfNumber(128));
        } else {
            dic.put(PdfName.V, new PdfNumber(1));
            dic.put(PdfName.R, new PdfNumber(2));
        }
        return dic;
    }

    public PdfObject getFileID() {
        return PdfEncryption.createInfoId(this.documentID);
    }

    private byte[] padPassword(byte[] userPassword) {
        byte[] userPad = new byte[32];
        if (userPassword == null) {
            System.arraycopy(pad, 0, userPad, 0, 32);
        } else {
            System.arraycopy(userPassword, 0, userPad, 0, Math.min(userPassword.length, 32));
            if (userPassword.length < 32) {
                System.arraycopy(pad, 0, userPad, userPassword.length, 32 - userPassword.length);
            }
        }
        return userPad;
    }

    public void prepareKey() {
        this.prepareRC4Key(this.key, 0, this.keySize);
    }

    public void prepareRC4Key(byte[] key, int off, int len) {
        int index1 = 0;
        int index2 = 0;
        int k = 0;
        while (k < 256) {
            this.state[k] = (byte)k;
            ++k;
        }
        this.x = 0;
        this.y = 0;
        int k2 = 0;
        while (k2 < 256) {
            index2 = key[index1 + off] + this.state[k2] + index2 & 0xFF;
            byte tmp = this.state[k2];
            this.state[k2] = this.state[index2];
            this.state[index2] = tmp;
            index1 = (index1 + 1) % len;
            ++k2;
        }
    }

    public void prepareRC4Key(byte[] key) {
        this.prepareRC4Key(key, 0, key.length);
    }

    public void setHashKey(int number, int generation) {
        this.md5.reset();
        this.extra[0] = (byte)number;
        this.extra[1] = (byte)(number >> 8);
        this.extra[2] = (byte)(number >> 16);
        this.extra[3] = (byte)generation;
        this.extra[4] = (byte)(generation >> 8);
        this.md5.update(this.mkey);
        this.key = this.md5.digest(this.extra);
        this.keySize = this.mkey.length + 5;
        if (this.keySize > 16) {
            this.keySize = 16;
        }
    }

    public void setupAllKeys(byte[] userPassword, byte[] ownerPassword, int permissions, boolean strength128Bits) {
        this.setupAllKeys(userPassword, ownerPassword, permissions, strength128Bits ? 128 : 40, strength128Bits ? 3 : 2);
    }

    public void setupAllKeys(byte[] userPassword, byte[] ownerPassword, int permissions, int keylength, int revision) {
        if (ownerPassword == null || ownerPassword.length == 0) {
            ownerPassword = this.md5.digest(PdfEncryption.createDocumentId());
        }
        permissions |= revision == 3 ? -3904 : -64;
        byte[] userPad = this.padPassword(userPassword);
        byte[] ownerPad = this.padPassword(ownerPassword);
        this.ownerKey = this.computeOwnerKey(userPad, ownerPad, keylength, revision);
        this.documentID = PdfEncryption.createDocumentId();
        this.setupByUserPad(this.documentID, userPad, this.ownerKey, permissions &= 0xFFFFFFFC, keylength, revision);
    }

    private void setupByOwnerPad(byte[] documentID, byte[] ownerPad, byte[] userKey, byte[] ownerKey, int permissions, int keylength, int revision) {
        byte[] userPad = this.computeOwnerKey(ownerKey, ownerPad, keylength, revision);
        this.setupGlobalEncryptionKey(documentID, userPad, ownerKey, permissions, keylength, revision);
        this.setupUserKey(revision);
    }

    public void setupByOwnerPassword(byte[] documentID, byte[] ownerPassword, byte[] userKey, byte[] ownerKey, int permissions, int keylength, int revision) {
        this.setupByOwnerPad(documentID, this.padPassword(ownerPassword), userKey, ownerKey, permissions, keylength, revision);
    }

    public void setupByOwnerPassword(byte[] documentID, byte[] ownerPassword, byte[] userKey, byte[] ownerKey, int permissions, boolean strength128Bits) {
        this.setupByOwnerPassword(documentID, ownerPassword, userKey, ownerKey, permissions, strength128Bits ? 128 : 40, strength128Bits ? 3 : 2);
    }

    private void setupByUserPad(byte[] documentID, byte[] userPad, byte[] ownerKey, int permissions, int keylength, int revision) {
        this.setupGlobalEncryptionKey(documentID, userPad, ownerKey, permissions, keylength, revision);
        this.setupUserKey(revision);
    }

    public void setupByUserPassword(byte[] documentID, byte[] userPassword, byte[] ownerKey, int permissions, int keylength, int revision) {
        this.setupByUserPad(documentID, this.padPassword(userPassword), ownerKey, permissions, keylength, revision);
    }

    public void setupByUserPassword(byte[] documentID, byte[] userPassword, byte[] ownerKey, int permissions, boolean strength128Bits) {
        this.setupByUserPassword(documentID, userPassword, ownerKey, permissions, strength128Bits ? 128 : 40, strength128Bits ? 3 : 2);
    }

    private void setupGlobalEncryptionKey(byte[] documentID, byte[] userPad, byte[] ownerKey, int permissions, int keylength, int revision) {
        this.documentID = documentID;
        this.ownerKey = ownerKey;
        this.permissions = permissions;
        this.mkey = new byte[keylength / 8];
        this.md5.reset();
        this.md5.update(userPad);
        this.md5.update(ownerKey);
        byte[] ext = new byte[]{(byte)permissions, (byte)(permissions >> 8), (byte)(permissions >> 16), (byte)(permissions >> 24)};
        this.md5.update(ext, 0, 4);
        if (documentID != null) {
            this.md5.update(documentID);
        }
        byte[] digest = new byte[this.mkey.length];
        System.arraycopy(this.md5.digest(), 0, digest, 0, this.mkey.length);
        if (revision == 3) {
            int k = 0;
            while (k < 50) {
                System.arraycopy(this.md5.digest(digest), 0, digest, 0, this.mkey.length);
                ++k;
            }
        }
        System.arraycopy(digest, 0, this.mkey, 0, this.mkey.length);
    }

    private void setupUserKey(int revision) {
        if (revision == 3) {
            this.md5.update(pad);
            byte[] digest = this.md5.digest(this.documentID);
            System.arraycopy(digest, 0, this.userKey, 0, 16);
            int k = 16;
            while (k < 32) {
                this.userKey[k] = 0;
                ++k;
            }
            int i = 0;
            while (i < 20) {
                int j = 0;
                while (j < this.mkey.length) {
                    digest[j] = (byte)(this.mkey[j] ^ i);
                    ++j;
                }
                this.prepareRC4Key(digest, 0, this.mkey.length);
                this.encryptRC4(this.userKey, 0, 16);
                ++i;
            }
        } else {
            this.prepareRC4Key(this.mkey);
            this.encryptRC4(pad, this.userKey);
        }
    }
}

