/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.pdf.BaseFont;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfIndirectReference;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfNumber;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfStream;
import com.lowagie2.text.pdf.PdfString;
import com.lowagie2.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;

public class PdfFileSpecification
extends PdfDictionary {
    protected PdfIndirectReference ref;
    protected PdfWriter writer;

    public PdfFileSpecification() {
        super(PdfName.FILESPEC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static PdfFileSpecification fileEmbedded(PdfWriter writer, String filePath, String fileDisplay, byte[] fileStore, boolean compress) throws IOException {
        fs = new PdfFileSpecification();
        fs.writer = writer;
        fs.put(PdfName.F, new PdfString(fileDisplay));
        in = null;
        try {
            refFileLength = writer.getPdfIndirectReference();
            if (fileStore == null) {
                file = new File(filePath);
                if (file.canRead()) {
                    in = new FileInputStream(filePath);
                } else if (filePath.startsWith("file:/") || filePath.startsWith("http://") || filePath.startsWith("https://") || filePath.startsWith("jar:")) {
                    in = new URL(filePath).openStream();
                } else {
                    in = BaseFont.getResourceStream(filePath);
                    if (in == null) {
                        throw new IOException(filePath + " not found as file or resource.");
                    }
                }
                stream = new PdfStream(in, writer);
            } else {
                stream = new PdfStream(fileStore);
            }
            stream.put(PdfName.TYPE, PdfName.EMBEDDEDFILE);
            if (compress) {
                stream.flateCompress();
            }
            stream.put(PdfName.PARAMS, refFileLength);
            ref = writer.addToBody(stream).getIndirectReference();
            if (fileStore == null) {
                stream.writeLength();
            }
            params = new PdfDictionary();
            params.put(PdfName.SIZE, new PdfNumber(stream.getRawLength()));
            writer.addToBody((PdfObject)params, refFileLength);
            var12_11 = null;
            ** if (in == null) goto lbl-1000
        }
        catch (Throwable var11_15) {
            var12_12 = null;
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                }
            }
            throw var11_15;
        }
lbl-1000:
        // 1 sources

        {
            try {
                in.close();
            }
            catch (Exception e) {
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        f = new PdfDictionary();
        f.put(PdfName.F, ref);
        fs.put(PdfName.EF, f);
        return fs;
    }

    public static PdfFileSpecification fileEmbedded(PdfWriter writer, String filePath, String fileDisplay, byte[] fileStore) throws IOException {
        return PdfFileSpecification.fileEmbedded(writer, filePath, fileDisplay, fileStore, true);
    }

    public static PdfFileSpecification fileExtern(PdfWriter writer, String filePath) {
        PdfFileSpecification fs = new PdfFileSpecification();
        fs.writer = writer;
        fs.put(PdfName.F, new PdfString(filePath));
        return fs;
    }

    public PdfIndirectReference getReference() throws IOException {
        if (this.ref != null) {
            return this.ref;
        }
        this.ref = this.writer.addToBody(this).getIndirectReference();
        return this.ref;
    }

    public void setMultiByteFileName(byte[] fileName) {
        this.put(PdfName.F, new PdfString(fileName).setHexWriting(true));
    }

    public static PdfFileSpecification url(PdfWriter writer, String url) {
        PdfFileSpecification fs = new PdfFileSpecification();
        fs.writer = writer;
        fs.put(PdfName.FS, PdfName.URL);
        fs.put(PdfName.F, new PdfString(url));
        return fs;
    }
}

