/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.pdf.PdfException;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfNumber;
import com.lowagie2.text.pdf.PdfStream;
import java.awt.color.ICC_Profile;

class PdfICCBased
extends PdfStream {
    protected int NumberOfComponents;

    PdfICCBased(ICC_Profile profile) {
        try {
            this.NumberOfComponents = profile.getNumComponents();
            switch (this.NumberOfComponents) {
                case 1: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICEGRAY);
                    break;
                }
                case 3: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICERGB);
                    break;
                }
                case 4: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICECMYK);
                    break;
                }
                default: {
                    throw new PdfException(this.NumberOfComponents + " component(s) is not supported in PDF1.4");
                }
            }
            this.put(PdfName.N, new PdfNumber(this.NumberOfComponents));
            this.bytes = profile.getData();
            this.flateCompress();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }
}

