/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.StringCompare;
import com.lowagie2.text.pdf.PdfArray;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfEncodings;
import com.lowagie2.text.pdf.PdfIndirectReference;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.text.pdf.PdfString;
import com.lowagie2.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class PdfNameTree {
    private static final int leafSize = 64;
    private static final StringCompare stringCompare = new StringCompare();

    private static void iterateItems(PdfDictionary dic, HashMap items) {
        block3: {
            PdfArray nn;
            block2: {
                nn = (PdfArray)PdfReader.getPdfObjectRelease(dic.get(PdfName.NAMES));
                if (nn == null) break block2;
                ArrayList arr = nn.getArrayList();
                int k = 0;
                while (k < arr.size()) {
                    PdfString s = (PdfString)PdfReader.getPdfObjectRelease((PdfObject)arr.get(k++));
                    items.put(PdfEncodings.convertToString(s.getBytes(), null), arr.get(k));
                    ++k;
                }
                break block3;
            }
            nn = (PdfArray)PdfReader.getPdfObjectRelease(dic.get(PdfName.KIDS));
            if (nn == null) break block3;
            ArrayList arr = nn.getArrayList();
            int k = 0;
            while (k < arr.size()) {
                PdfDictionary kid = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)arr.get(k));
                PdfNameTree.iterateItems(kid, items);
                ++k;
            }
        }
    }

    public static HashMap readTree(PdfDictionary dic) {
        HashMap items = new HashMap();
        if (dic != null) {
            PdfNameTree.iterateItems(dic, items);
        }
        return items;
    }

    public static PdfDictionary writeTree(HashMap items, PdfWriter writer) throws IOException {
        if (items.size() == 0) {
            return null;
        }
        String[] names = new String[items.size()];
        names = items.keySet().toArray(names);
        Arrays.sort(names, stringCompare);
        if (names.length <= 64) {
            PdfDictionary dic = new PdfDictionary();
            PdfArray ar = new PdfArray();
            int k = 0;
            while (k < names.length) {
                ar.add(new PdfString(names[k], null));
                ar.add((PdfObject)items.get(names[k]));
                ++k;
            }
            dic.put(PdfName.NAMES, ar);
            return dic;
        }
        int skip = 64;
        PdfIndirectReference[] kids = new PdfIndirectReference[(names.length + 64 - 1) / 64];
        int k = 0;
        while (k < kids.length) {
            int offset = k * 64;
            int end = Math.min(offset + 64, names.length);
            PdfDictionary dic = new PdfDictionary();
            PdfArray arr = new PdfArray();
            arr.add(new PdfString(names[offset], null));
            arr.add(new PdfString(names[end - 1], null));
            dic.put(PdfName.LIMITS, arr);
            arr = new PdfArray();
            while (offset < end) {
                arr.add(new PdfString(names[offset], null));
                arr.add((PdfObject)items.get(names[offset]));
                ++offset;
            }
            dic.put(PdfName.NAMES, arr);
            kids[k] = writer.addToBody(dic).getIndirectReference();
            ++k;
        }
        int top = kids.length;
        while (true) {
            if (top <= 64) {
                PdfArray arr = new PdfArray();
                int k2 = 0;
                while (k2 < top) {
                    arr.add(kids[k2]);
                    ++k2;
                }
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.KIDS, arr);
                return dic;
            }
            int tt = (names.length + (skip *= 64) - 1) / skip;
            int k3 = 0;
            while (k3 < tt) {
                int offset = k3 * 64;
                int end = Math.min(offset + 64, top);
                PdfDictionary dic = new PdfDictionary();
                PdfArray arr = new PdfArray();
                arr.add(new PdfString(names[k3 * skip], null));
                arr.add(new PdfString(names[Math.min((k3 + 1) * skip, names.length) - 1], null));
                dic.put(PdfName.LIMITS, arr);
                arr = new PdfArray();
                while (offset < end) {
                    arr.add(kids[offset]);
                    ++offset;
                }
                dic.put(PdfName.KIDS, arr);
                kids[k3] = writer.addToBody(dic).getIndirectReference();
                ++k3;
            }
            top = tt;
        }
    }
}

