/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.Element;
import com.lowagie2.text.Image;
import com.lowagie2.text.Phrase;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.ColumnText;
import com.lowagie2.text.pdf.PdfPCellEvent;
import com.lowagie2.text.pdf.PdfPTable;
import com.lowagie2.text.pdf.events.PdfPCellEventForwarder;

public class PdfPCell
extends Rectangle {
    private PdfPCellEvent cellEvent;
    private int colspan = 1;
    private ColumnText column = new ColumnText(null);
    private float fixedHeight = 0.0f;
    private Image image;
    private float minimumHeight;
    private boolean noWrap = false;
    private float paddingBottom = 2.0f;
    private float paddingLeft = 2.0f;
    private float paddingRight = 2.0f;
    private float paddingTop = 2.0f;
    protected Phrase phrase;
    private int rotation;
    private PdfPTable table;
    private boolean useBorderPadding = false;
    private boolean useDescender;
    private int verticalAlignment = 4;

    public PdfPCell(PdfPCell cell) {
        super(cell.llx, cell.lly, cell.urx, cell.ury);
        this.cloneNonPositionParameters(cell);
        this.verticalAlignment = cell.verticalAlignment;
        this.paddingLeft = cell.paddingLeft;
        this.paddingRight = cell.paddingRight;
        this.paddingTop = cell.paddingTop;
        this.paddingBottom = cell.paddingBottom;
        this.phrase = cell.phrase;
        this.fixedHeight = cell.fixedHeight;
        this.minimumHeight = cell.minimumHeight;
        this.noWrap = cell.noWrap;
        this.colspan = cell.colspan;
        if (cell.table != null) {
            this.table = new PdfPTable(cell.table);
        }
        this.image = Image.getInstance(cell.image);
        this.cellEvent = cell.cellEvent;
        this.useDescender = cell.useDescender;
        this.column = ColumnText.duplicate(cell.column);
        this.useBorderPadding = cell.useBorderPadding;
        this.rotation = cell.rotation;
    }

    public PdfPCell(PdfPTable table) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.column.setLeading(0.0f, 1.0f);
        this.setPadding(0.0f);
        this.table = table;
        table.setWidthPercentage(100.0f);
        table.setExtendLastRow(true);
        this.column.addElement(table);
    }

    public PdfPCell(Image image, boolean fit) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        if (fit) {
            this.borderWidth = 0.5f;
            this.border = 15;
            this.image = image;
            this.column.setLeading(0.0f, 1.0f);
            this.setPadding(this.borderWidth / 2.0f);
        } else {
            this.borderWidth = 0.5f;
            this.border = 15;
            this.phrase = new Phrase(new Chunk(image, 0.0f, 0.0f));
            this.column.addText(this.phrase);
            this.column.setLeading(0.0f, 1.0f);
            this.setPadding(0.0f);
        }
    }

    public PdfPCell(Image image) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.phrase = new Phrase(new Chunk(image, 0.0f, 0.0f));
        this.column.addText(this.phrase);
        this.column.setLeading(0.0f, 1.0f);
        this.setPadding(0.0f);
    }

    public PdfPCell(Phrase phrase) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.phrase = phrase;
        this.column.addText(this.phrase);
        this.column.setLeading(0.0f, 1.0f);
    }

    public PdfPCell() {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.column.setLeading(0.0f, 1.0f);
    }

    public void addElement(Element element) {
        if (this.table != null) {
            this.table = null;
            this.column.setText(null);
        }
        this.column.addElement(element);
    }

    public int getArabicOptions() {
        return this.column.getArabicOptions();
    }

    public PdfPCellEvent getCellEvent() {
        return this.cellEvent;
    }

    public int getColspan() {
        return this.colspan;
    }

    public ColumnText getColumn() {
        return this.column;
    }

    public float getEffectivePaddingBottom() {
        return this.paddingBottom + (this.isUseBorderPadding() ? this.getBorderWidthBottom() / (this.isUseVariableBorders() ? 1.0f : 2.0f) : 0.0f);
    }

    public float getEffectivePaddingLeft() {
        return this.paddingLeft + (this.isUseBorderPadding() ? this.getBorderWidthLeft() / (this.isUseVariableBorders() ? 1.0f : 2.0f) : 0.0f);
    }

    public float getEffectivePaddingRight() {
        return this.paddingRight + (this.isUseBorderPadding() ? this.getBorderWidthRight() / (this.isUseVariableBorders() ? 1.0f : 2.0f) : 0.0f);
    }

    public float getEffectivePaddingTop() {
        return this.paddingTop + (this.isUseBorderPadding() ? this.getBorderWidthTop() / (this.isUseVariableBorders() ? 1.0f : 2.0f) : 0.0f);
    }

    public float getExtraParagraphSpace() {
        return this.column.getExtraParagraphSpace();
    }

    public float getFixedHeight() {
        return this.fixedHeight;
    }

    public float getFollowingIndent() {
        return this.column.getFollowingIndent();
    }

    public int getHorizontalAlignment() {
        return this.column.getAlignment();
    }

    public Image getImage() {
        return this.image;
    }

    public float getIndent() {
        return this.column.getIndent();
    }

    public float getLeading() {
        return this.column.getLeading();
    }

    public float getMinimumHeight() {
        return this.minimumHeight;
    }

    public float getMultipliedLeading() {
        return this.column.getMultipliedLeading();
    }

    public float getPaddingBottom() {
        return this.paddingBottom;
    }

    public float getPaddingLeft() {
        return this.paddingLeft;
    }

    public float getPaddingRight() {
        return this.paddingRight;
    }

    public float getPaddingTop() {
        return this.paddingTop;
    }

    public Phrase getPhrase() {
        return this.phrase;
    }

    public float getRightIndent() {
        return this.column.getRightIndent();
    }

    public int getRotation() {
        return this.rotation;
    }

    public int getRunDirection() {
        return this.column.getRunDirection();
    }

    public float getSpaceCharRatio() {
        return this.column.getSpaceCharRatio();
    }

    PdfPTable getTable() {
        return this.table;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public boolean isNoWrap() {
        return this.noWrap;
    }

    public boolean isUseAscender() {
        return this.column.isUseAscender();
    }

    public boolean isUseBorderPadding() {
        return this.useBorderPadding;
    }

    public boolean isUseDescender() {
        return this.useDescender;
    }

    public void setArabicOptions(int arabicOptions) {
        this.column.setArabicOptions(arabicOptions);
    }

    public void setCellEvent(PdfPCellEvent event) {
        if (event == null) {
            this.cellEvent = null;
        } else if (this.cellEvent == null) {
            this.cellEvent = event;
        } else if (this.cellEvent instanceof PdfPCellEventForwarder) {
            ((PdfPCellEventForwarder)this.cellEvent).addCellEvent(event);
        } else {
            PdfPCellEventForwarder forward = new PdfPCellEventForwarder();
            forward.addCellEvent(this.cellEvent);
            forward.addCellEvent(event);
            this.cellEvent = forward;
        }
    }

    public void setColspan(int colspan) {
        this.colspan = colspan;
    }

    public void setColumn(ColumnText column) {
        this.column = column;
    }

    public void setExtraParagraphSpace(float extraParagraphSpace) {
        this.column.setExtraParagraphSpace(extraParagraphSpace);
    }

    public void setFixedHeight(float fixedHeight) {
        this.fixedHeight = fixedHeight;
        this.minimumHeight = 0.0f;
    }

    public void setFollowingIndent(float indent) {
        this.column.setFollowingIndent(indent);
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.column.setAlignment(horizontalAlignment);
    }

    public void setImage(Image image) {
        this.column.setText(null);
        this.table = null;
        this.image = image;
    }

    public void setIndent(float indent) {
        this.column.setIndent(indent);
    }

    public void setLeading(float fixedLeading, float multipliedLeading) {
        this.column.setLeading(fixedLeading, multipliedLeading);
    }

    public void setMinimumHeight(float minimumHeight) {
        this.minimumHeight = minimumHeight;
        this.fixedHeight = 0.0f;
    }

    public void setNoWrap(boolean noWrap) {
        this.noWrap = noWrap;
    }

    public void setPadding(float padding) {
        this.paddingBottom = padding;
        this.paddingTop = padding;
        this.paddingLeft = padding;
        this.paddingRight = padding;
    }

    public void setPaddingBottom(float paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public void setPaddingLeft(float paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public void setPaddingRight(float paddingRight) {
        this.paddingRight = paddingRight;
    }

    public void setPaddingTop(float paddingTop) {
        this.paddingTop = paddingTop;
    }

    public void setPhrase(Phrase phrase) {
        this.table = null;
        this.image = null;
        this.phrase = phrase;
        this.column.setText(this.phrase);
    }

    public void setRightIndent(float indent) {
        this.column.setRightIndent(indent);
    }

    public void setRotation(int rotation) {
        if ((rotation %= 360) < 0) {
            rotation += 360;
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("Rotation must be a multiple of 90.");
        }
        this.rotation = rotation;
    }

    public void setRunDirection(int runDirection) {
        this.column.setRunDirection(runDirection);
    }

    public void setSpaceCharRatio(float spaceCharRatio) {
        this.column.setSpaceCharRatio(spaceCharRatio);
    }

    void setTable(PdfPTable table) {
        this.table = table;
        this.column.setText(null);
        this.image = null;
        if (table != null) {
            table.setExtendLastRow(this.verticalAlignment == 4);
            this.column.addElement(table);
            table.setWidthPercentage(100.0f);
        }
    }

    public void setUseAscender(boolean use) {
        this.column.setUseAscender(use);
    }

    public void setUseBorderPadding(boolean use) {
        this.useBorderPadding = use;
    }

    public void setUseDescender(boolean useDescender) {
        this.useDescender = useDescender;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        if (this.table != null) {
            this.table.setExtendLastRow(verticalAlignment == 4);
        }
        this.verticalAlignment = verticalAlignment;
    }
}

