/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Image;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.PdfContentByte;
import com.lowagie2.text.pdf.PdfPattern;
import com.lowagie2.text.pdf.PdfSpotColor;
import com.lowagie2.text.pdf.PdfTemplate;
import com.lowagie2.text.pdf.PdfWriter;
import java.awt.Color;

public class PdfPatternPainter
extends PdfTemplate {
    protected Color defaultColor;
    protected boolean stencil = false;
    protected float xstep;
    protected float ystep;

    PdfPatternPainter(PdfWriter wr, Color defaultColor) {
        this(wr);
        this.stencil = true;
        this.defaultColor = defaultColor == null ? Color.gray : defaultColor;
    }

    PdfPatternPainter(PdfWriter wr) {
        super(wr);
        this.type = 3;
    }

    private PdfPatternPainter() {
        super(null);
        this.type = 3;
    }

    public void addImage(Image image, float a, float b, float c, float d, float e, float f) throws DocumentException {
        if (this.stencil && !image.isMask()) {
            this.checkNoColor();
        }
        super.addImage(image, a, b, c, d, e, f);
    }

    void checkNoColor() {
        if (this.stencil) {
            throw new RuntimeException("Colors are not allowed in uncolored tile patterns.");
        }
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public PdfContentByte getDuplicate() {
        PdfPatternPainter tpl = new PdfPatternPainter();
        tpl.writer = this.writer;
        tpl.pdf = this.pdf;
        tpl.thisReference = this.thisReference;
        tpl.pageResources = this.pageResources;
        tpl.bBox = new Rectangle(this.bBox);
        tpl.xstep = this.xstep;
        tpl.ystep = this.ystep;
        tpl.matrix = this.matrix;
        tpl.stencil = this.stencil;
        tpl.defaultColor = this.defaultColor;
        return tpl;
    }

    PdfPattern getPattern() {
        return new PdfPattern(this);
    }

    public float getXStep() {
        return this.xstep;
    }

    public float getYStep() {
        return this.ystep;
    }

    public boolean isStencil() {
        return this.stencil;
    }

    public void resetCMYKColorFill() {
        this.checkNoColor();
        super.resetCMYKColorFill();
    }

    public void resetCMYKColorStroke() {
        this.checkNoColor();
        super.resetCMYKColorStroke();
    }

    public void resetGrayFill() {
        this.checkNoColor();
        super.resetGrayFill();
    }

    public void resetGrayStroke() {
        this.checkNoColor();
        super.resetGrayStroke();
    }

    public void resetRGBColorFill() {
        this.checkNoColor();
        super.resetRGBColorFill();
    }

    public void resetRGBColorStroke() {
        this.checkNoColor();
        super.resetRGBColorStroke();
    }

    public void setCMYKColorFill(int cyan, int magenta, int yellow, int black) {
        this.checkNoColor();
        super.setCMYKColorFill(cyan, magenta, yellow, black);
    }

    public void setCMYKColorFillF(float cyan, float magenta, float yellow, float black) {
        this.checkNoColor();
        super.setCMYKColorFillF(cyan, magenta, yellow, black);
    }

    public void setCMYKColorStroke(int cyan, int magenta, int yellow, int black) {
        this.checkNoColor();
        super.setCMYKColorStroke(cyan, magenta, yellow, black);
    }

    public void setCMYKColorStrokeF(float cyan, float magenta, float yellow, float black) {
        this.checkNoColor();
        super.setCMYKColorStrokeF(cyan, magenta, yellow, black);
    }

    public void setColorFill(PdfSpotColor sp, float tint) {
        this.checkNoColor();
        super.setColorFill(sp, tint);
    }

    public void setColorFill(Color color) {
        this.checkNoColor();
        super.setColorFill(color);
    }

    public void setColorStroke(PdfSpotColor sp, float tint) {
        this.checkNoColor();
        super.setColorStroke(sp, tint);
    }

    public void setColorStroke(Color color) {
        this.checkNoColor();
        super.setColorStroke(color);
    }

    public void setGrayFill(float gray) {
        this.checkNoColor();
        super.setGrayFill(gray);
    }

    public void setGrayStroke(float gray) {
        this.checkNoColor();
        super.setGrayStroke(gray);
    }

    public void setPatternFill(PdfPatternPainter p, Color color, float tint) {
        this.checkNoColor();
        super.setPatternFill(p, color, tint);
    }

    public void setPatternFill(PdfPatternPainter p) {
        this.checkNoColor();
        super.setPatternFill(p);
    }

    public void setPatternMatrix(float a, float b, float c, float d, float e, float f) {
        this.setMatrix(a, b, c, d, e, f);
    }

    public void setPatternStroke(PdfPatternPainter p) {
        this.checkNoColor();
        super.setPatternStroke(p);
    }

    public void setPatternStroke(PdfPatternPainter p, Color color, float tint) {
        this.checkNoColor();
        super.setPatternStroke(p, color, tint);
    }

    public void setRGBColorFill(int red, int green, int blue) {
        this.checkNoColor();
        super.setRGBColorFill(red, green, blue);
    }

    public void setRGBColorFillF(float red, float green, float blue) {
        this.checkNoColor();
        super.setRGBColorFillF(red, green, blue);
    }

    public void setRGBColorStroke(int red, int green, int blue) {
        this.checkNoColor();
        super.setRGBColorStroke(red, green, blue);
    }

    public void setRGBColorStrokeF(float red, float green, float blue) {
        this.checkNoColor();
        super.setRGBColorStrokeF(red, green, blue);
    }

    public void setXStep(float xstep) {
        this.xstep = xstep;
    }

    public void setYStep(float ystep) {
        this.ystep = ystep;
    }
}

