/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.DocWriter;
import com.lowagie2.text.Document;
import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.pdf.OutputStreamCounter;
import com.lowagie2.text.pdf.PdfArray;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfEncryption;
import com.lowagie2.text.pdf.PdfEncryptionStream;
import com.lowagie2.text.pdf.PdfIndirectReference;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfNumber;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PdfStream
extends PdfDictionary {
    static final byte[] ENDSTREAM;
    static final int SIZESTREAM;
    static final byte[] STARTSTREAM;
    protected boolean compressed = false;
    protected InputStream inputStream;
    protected int inputStreamLength = -1;
    protected int rawLength;
    protected PdfIndirectReference ref;
    protected ByteArrayOutputStream streamBytes = null;
    protected PdfWriter writer;

    static {
        STARTSTREAM = DocWriter.getISOBytes("stream\n");
        ENDSTREAM = DocWriter.getISOBytes("\nendstream");
        SIZESTREAM = STARTSTREAM.length + ENDSTREAM.length;
    }

    protected PdfStream() {
        this.type = 7;
    }

    public PdfStream(InputStream inputStream, PdfWriter writer) {
        this.type = 7;
        this.inputStream = inputStream;
        this.writer = writer;
        this.ref = writer.getPdfIndirectReference();
        this.put(PdfName.LENGTH, this.ref);
    }

    public PdfStream(byte[] bytes) {
        this.type = 7;
        this.bytes = bytes;
        this.rawLength = bytes.length;
        this.put(PdfName.LENGTH, new PdfNumber(bytes.length));
    }

    public void flateCompress() {
        if (!Document.compress) {
            return;
        }
        if (this.compressed) {
            return;
        }
        if (this.inputStream != null) {
            this.compressed = true;
            return;
        }
        PdfObject filter = this.get(PdfName.FILTER);
        if (filter != null) {
            if (filter.isName() && ((PdfName)filter).compareTo(PdfName.FLATEDECODE) == 0) {
                return;
            }
            if (filter.isArray() && ((PdfArray)filter).contains(PdfName.FLATEDECODE)) {
                return;
            }
            throw new RuntimeException("Stream could not be compressed: filter is not a name or array.");
        }
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DeflaterOutputStream zip = new DeflaterOutputStream(stream);
            if (this.streamBytes != null) {
                this.streamBytes.writeTo(zip);
            } else {
                zip.write(this.bytes);
            }
            zip.close();
            this.streamBytes = stream;
            this.bytes = null;
            this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
            if (filter == null) {
                this.put(PdfName.FILTER, PdfName.FLATEDECODE);
            } else {
                PdfArray filters = new PdfArray(filter);
                filters.add(PdfName.FLATEDECODE);
                this.put(PdfName.FILTER, filters);
            }
            this.compressed = true;
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    public int getRawLength() {
        return this.rawLength;
    }

    protected void superToPdf(PdfWriter writer, OutputStream os) throws IOException {
        super.toPdf(writer, os);
    }

    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        if (this.inputStream != null && this.compressed) {
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        }
        this.superToPdf(writer, os);
        os.write(STARTSTREAM);
        PdfEncryption crypto = null;
        if (writer != null) {
            crypto = writer.getEncryption();
        }
        if (crypto != null) {
            crypto.prepareKey();
        }
        if (this.inputStream != null) {
            int n;
            this.rawLength = 0;
            DeflaterOutputStream def = null;
            OutputStreamCounter osc = new OutputStreamCounter(os);
            OutputStream fout = osc;
            if (crypto != null) {
                fout = new PdfEncryptionStream(fout, crypto);
            }
            if (this.compressed) {
                def = new DeflaterOutputStream(fout, new Deflater(9), 32768);
                fout = def;
            }
            byte[] buf = new byte[65536];
            while ((n = this.inputStream.read(buf)) > 0) {
                fout.write(buf, 0, n);
                this.rawLength += n;
            }
            if (def != null) {
                def.finish();
            }
            this.inputStreamLength = osc.getCounter();
        } else if (crypto == null) {
            if (this.streamBytes != null) {
                this.streamBytes.writeTo(os);
            } else {
                os.write(this.bytes);
            }
        } else {
            byte[] b;
            if (this.streamBytes != null) {
                b = this.streamBytes.toByteArray();
                crypto.encryptRC4(b);
            } else {
                b = new byte[this.bytes.length];
                crypto.encryptRC4(this.bytes, b);
            }
            os.write(b);
        }
        os.write(ENDSTREAM);
    }

    public void writeContent(OutputStream os) throws IOException {
        if (this.streamBytes != null) {
            this.streamBytes.writeTo(os);
        } else if (this.bytes != null) {
            os.write(this.bytes);
        }
    }

    public void writeLength() throws IOException {
        if (this.inputStream == null) {
            throw new UnsupportedOperationException("writeLength() can only be called in a contructed PdfStream(InputStream,PdfWriter).");
        }
        if (this.inputStreamLength == -1) {
            throw new IOException("writeLength() can only be called after output of the stream body.");
        }
        this.writer.addToBody((PdfObject)new PdfNumber(this.inputStreamLength), this.ref, false);
    }
}

