/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.DocumentException;
import com.lowagie2.text.pdf.BaseFont;
import com.lowagie2.text.pdf.CFFFontSubset;
import com.lowagie2.text.pdf.PdfArray;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfEncodings;
import com.lowagie2.text.pdf.PdfIndirectObject;
import com.lowagie2.text.pdf.PdfIndirectReference;
import com.lowagie2.text.pdf.PdfLiteral;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfNumber;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfStream;
import com.lowagie2.text.pdf.PdfString;
import com.lowagie2.text.pdf.PdfWriter;
import com.lowagie2.text.pdf.RandomAccessFileOrArray;
import com.lowagie2.text.pdf.TrueTypeFont;
import com.lowagie2.text.pdf.TrueTypeFontSubSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

class TrueTypeFontUnicode
extends TrueTypeFont
implements Comparator {
    boolean vertical = false;

    TrueTypeFontUnicode(String ttFile, String enc, boolean emb, byte[] ttfAfm) throws DocumentException, IOException {
        String nameBase = BaseFont.getBaseName(ttFile);
        String ttcName = TrueTypeFont.getTTCName(nameBase);
        if (nameBase.length() < ttFile.length()) {
            this.style = ttFile.substring(nameBase.length());
        }
        this.encoding = enc;
        this.embedded = emb;
        this.fileName = ttcName;
        this.ttcIndex = "";
        if (ttcName.length() < nameBase.length()) {
            this.ttcIndex = nameBase.substring(ttcName.length() + 1);
        }
        this.fontType = 3;
        if ((this.fileName.toLowerCase().endsWith(".ttf") || this.fileName.toLowerCase().endsWith(".otf") || this.fileName.toLowerCase().endsWith(".ttc")) && (enc.equals("Identity-H") || enc.equals("Identity-V")) && emb) {
            this.process(ttfAfm);
            if (this.os_2.fsType == 2) {
                throw new DocumentException(this.fileName + this.style + " cannot be embedded due to licensing restrictions.");
            }
            if (this.cmap31 == null && !this.fontSpecific || this.cmap10 == null && this.fontSpecific) {
                this.directTextToByte = true;
            }
            if (this.fontSpecific) {
                this.fontSpecific = false;
                String tempEncoding = this.encoding;
                this.encoding = "";
                this.createEncoding();
                this.encoding = tempEncoding;
                this.fontSpecific = true;
            }
        } else {
            throw new DocumentException(this.fileName + " " + this.style + " is not a TTF font file.");
        }
        this.vertical = enc.endsWith("V");
    }

    public boolean charExists(char c) {
        HashMap map = null;
        map = this.fontSpecific ? this.cmap10 : this.cmap31;
        if (map == null) {
            return false;
        }
        if (this.fontSpecific) {
            if ((c & 0xFF00) == 0 || (c & 0xFF00) == 61440) {
                return map.get(new Integer(c & 0xFF)) != null;
            }
            return false;
        }
        return map.get(new Integer(c)) != null;
    }

    public int compare(Object o1, Object o2) {
        int m1 = ((int[])o1)[0];
        int m2 = ((int[])o2)[0];
        if (m1 < m2) {
            return -1;
        }
        if (m1 == m2) {
            return 0;
        }
        return 1;
    }

    byte[] convertToBytes(String text) {
        return null;
    }

    private PdfDictionary getCIDFontType2(PdfIndirectReference fontDescriptor, String subsetPrefix, Object[] metrics) {
        PdfDictionary dic = new PdfDictionary(PdfName.FONT);
        if (this.cff) {
            dic.put(PdfName.SUBTYPE, PdfName.CIDFONTTYPE0);
            dic.put(PdfName.BASEFONT, new PdfName(subsetPrefix + this.fontName + "-" + this.encoding));
        } else {
            dic.put(PdfName.SUBTYPE, PdfName.CIDFONTTYPE2);
            dic.put(PdfName.BASEFONT, new PdfName(subsetPrefix + this.fontName));
        }
        dic.put(PdfName.FONTDESCRIPTOR, fontDescriptor);
        if (!this.cff) {
            dic.put(PdfName.CIDTOGIDMAP, PdfName.IDENTITY);
        }
        PdfDictionary cdic = new PdfDictionary();
        cdic.put(PdfName.REGISTRY, new PdfString("Adobe"));
        cdic.put(PdfName.ORDERING, new PdfString("Identity"));
        cdic.put(PdfName.SUPPLEMENT, new PdfNumber(0));
        dic.put(PdfName.CIDSYSTEMINFO, cdic);
        if (!this.vertical) {
            dic.put(PdfName.DW, new PdfNumber(1000));
            StringBuffer buf = new StringBuffer("[");
            int lastNumber = -10;
            boolean firstTime = true;
            int k = 0;
            while (k < metrics.length) {
                int[] metric = (int[])metrics[k];
                if (metric[1] != 1000) {
                    int m = metric[0];
                    if (m == lastNumber + 1) {
                        buf.append(" ").append(metric[1]);
                    } else {
                        if (!firstTime) {
                            buf.append("]");
                        }
                        firstTime = false;
                        buf.append(m).append("[").append(metric[1]);
                    }
                    lastNumber = m;
                }
                ++k;
            }
            if (buf.length() > 1) {
                buf.append("]]");
                dic.put(PdfName.W, new PdfLiteral(buf.toString()));
            }
        }
        return dic;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int[] getCharBBox(char c) {
        if (this.bboxes == null) {
            return null;
        }
        HashMap map = null;
        map = this.fontSpecific ? this.cmap10 : this.cmap31;
        if (map == null) {
            return null;
        }
        int[] m = null;
        if (this.fontSpecific) {
            if ((c & 0xFF00) != 0 && (c & 0xFF00) != 61440) return null;
            m = (int[])map.get(new Integer(c & 0xFF));
        } else {
            m = (int[])map.get(new Integer(c));
        }
        if (m != null) return this.bboxes[m[0]];
        return null;
    }

    private PdfDictionary getFontBaseType(PdfIndirectReference descendant, String subsetPrefix, PdfIndirectReference toUnicode) {
        PdfDictionary dic = new PdfDictionary(PdfName.FONT);
        dic.put(PdfName.SUBTYPE, PdfName.TYPE0);
        if (this.cff) {
            dic.put(PdfName.BASEFONT, new PdfName(subsetPrefix + this.fontName + "-" + this.encoding));
        } else {
            dic.put(PdfName.BASEFONT, new PdfName(subsetPrefix + this.fontName));
        }
        dic.put(PdfName.ENCODING, new PdfName(this.encoding));
        dic.put(PdfName.DESCENDANTFONTS, new PdfArray(descendant));
        if (toUnicode != null) {
            dic.put(PdfName.TOUNICODE, toUnicode);
        }
        return dic;
    }

    private PdfStream getToUnicode(Object[] metrics) throws DocumentException {
        if (metrics.length == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer("/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n<< /Registry (Adobe)\n/Ordering (UCS)\n/Supplement 0\n>> def\n/CMapName /Adobe-Identity-UCS def\n/CMapType 2 def\n1 begincodespacerange\n<0000><FFFF>\nendcodespacerange\n");
        int size = 0;
        int k = 0;
        while (k < metrics.length) {
            if (size == 0) {
                if (k != 0) {
                    buf.append("endbfrange\n");
                }
                size = Math.min(100, metrics.length - k);
                buf.append(size).append(" beginbfrange\n");
            }
            --size;
            int[] metric = (int[])metrics[k];
            String fromTo = TrueTypeFontUnicode.toHex(metric[0]);
            buf.append(fromTo).append(fromTo).append(TrueTypeFontUnicode.toHex(metric[2])).append("\n");
            ++k;
        }
        buf.append("endbfrange\nendcmap\nCMapName currentdict /CMap defineresource pop\nend end\n");
        String s = buf.toString();
        PdfStream stream = new PdfStream(PdfEncodings.convertToBytes(s, null));
        stream.flateCompress();
        return stream;
    }

    public int getWidth(String text) {
        if (this.vertical) {
            return text.length() * 1000;
        }
        int total = 0;
        if (this.fontSpecific) {
            char[] cc = text.toCharArray();
            int len = cc.length;
            int k = 0;
            while (k < len) {
                char c = cc[k];
                if ((c & 0xFF00) == 0 || (c & 0xFF00) == 61440) {
                    total += this.getRawWidth(c & 0xFF, null);
                }
                ++k;
            }
        } else {
            int len = text.length();
            int k = 0;
            while (k < len) {
                total += this.getRawWidth(text.charAt(k), this.encoding);
                ++k;
            }
        }
        return total;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setCharAdvance(char c, int advance) {
        HashMap map = null;
        map = this.fontSpecific ? this.cmap10 : this.cmap31;
        if (map == null) {
            return false;
        }
        int[] m = null;
        if (this.fontSpecific) {
            if ((c & 0xFF00) != 0 && (c & 0xFF00) != 61440) return false;
            m = (int[])map.get(new Integer(c & 0xFF));
        } else {
            m = (int[])map.get(new Integer(c));
        }
        if (m == null) {
            return false;
        }
        m[1] = advance;
        return true;
    }

    static String toHex(int n) {
        String s = Integer.toHexString(n);
        return "<0000".substring(0, 5 - s.length()) + s + ">";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFont(PdfWriter writer, PdfIndirectReference ref, Object[] params) throws DocumentException, IOException {
        PdfIndirectObject obj;
        PdfDictionary pobj;
        PdfIndirectReference ind_font;
        Object[] metrics;
        block11: {
            byte[] b;
            HashMap longTag;
            block10: {
                longTag = (HashMap)params[0];
                this.addRangeUni(longTag, true, this.subset);
                metrics = longTag.values().toArray();
                Arrays.sort(metrics, this);
                ind_font = null;
                pobj = null;
                obj = null;
                if (!this.cff) break block10;
                RandomAccessFileOrArray rf2 = new RandomAccessFileOrArray(this.rf);
                byte[] b2 = new byte[this.cffLength];
                try {
                    rf2.reOpen();
                    rf2.seek(this.cffOffset);
                    rf2.readFully(b2);
                    Object var12_11 = null;
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    try {
                        rf2.close();
                    }
                    catch (Exception e) {
                    }
                    throw throwable;
                }
                try {
                    rf2.close();
                }
                catch (Exception e) {
                }
                if (this.subset || this.subsetRanges != null) {
                    CFFFontSubset cff = new CFFFontSubset(new RandomAccessFileOrArray(b2), longTag);
                    b2 = cff.Process(cff.getNames()[0]);
                }
                pobj = new BaseFont.StreamFont(b2, "CIDFontType0C");
                obj = writer.addToBody(pobj);
                ind_font = obj.getIndirectReference();
                break block11;
            }
            if (this.subset || this.directoryOffset != 0) {
                TrueTypeFontSubSet sb = new TrueTypeFontSubSet(this.fileName, new RandomAccessFileOrArray(this.rf), longTag, this.directoryOffset, false, false);
                b = sb.process();
            } else {
                b = this.getFullFont();
            }
            int[] lengths = new int[]{b.length};
            pobj = new BaseFont.StreamFont(b, lengths);
            obj = writer.addToBody(pobj);
            ind_font = obj.getIndirectReference();
        }
        String subsetPrefix = "";
        if (this.subset) {
            subsetPrefix = BaseFont.createSubsetPrefix();
        }
        PdfDictionary dic = this.getFontDescriptor(ind_font, subsetPrefix);
        obj = writer.addToBody(dic);
        ind_font = obj.getIndirectReference();
        pobj = this.getCIDFontType2(ind_font, subsetPrefix, metrics);
        obj = writer.addToBody(pobj);
        ind_font = obj.getIndirectReference();
        pobj = this.getToUnicode(metrics);
        PdfIndirectReference toUnicodeRef = null;
        if (pobj != null) {
            obj = writer.addToBody(pobj);
            toUnicodeRef = obj.getIndirectReference();
        }
        pobj = this.getFontBaseType(ind_font, subsetPrefix, toUnicodeRef);
        writer.addToBody((PdfObject)pobj, ref);
    }
}

