/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf;

import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Image;
import com.lowagie2.text.pdf.PageResources;
import com.lowagie2.text.pdf.PdfContentByte;
import com.lowagie2.text.pdf.PdfWriter;

public class Type3Glyph
extends PdfContentByte {
    private boolean colorized;
    private PageResources pageResources;

    Type3Glyph(PdfWriter writer, PageResources pageResources, float wx, float llx, float lly, float urx, float ury, boolean colorized) {
        super(writer);
        this.pageResources = pageResources;
        this.colorized = colorized;
        if (colorized) {
            this.content.append(wx).append(" 0 d0\n");
        } else {
            this.content.append(wx).append(" 0 ").append(llx).append(' ').append(lly).append(' ').append(urx).append(' ').append(ury).append(" d1\n");
        }
    }

    private Type3Glyph() {
        super(null);
    }

    public void addImage(Image image, float a, float b, float c, float d, float e, float f, boolean inlineImage) throws DocumentException {
        if (!this.colorized && (!image.isMask() || image.bpc() != 1 && image.bpc() <= 255)) {
            throw new DocumentException("Not colorized Typed3 fonts only accept mask images.");
        }
        super.addImage(image, a, b, c, d, e, f, inlineImage);
    }

    public PdfContentByte getDuplicate() {
        Type3Glyph dup = new Type3Glyph();
        dup.writer = this.writer;
        dup.pdf = this.pdf;
        dup.pageResources = this.pageResources;
        dup.colorized = this.colorized;
        return dup;
    }

    PageResources getPageResources() {
        return this.pageResources;
    }
}

