/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.pdf.events;

import com.lowagie2.text.Document;
import com.lowagie2.text.Paragraph;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.PdfPageEvent;
import com.lowagie2.text.pdf.PdfWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfPageEventForwarder
implements PdfPageEvent {
    protected ArrayList events = new ArrayList();

    public void addPageEvent(PdfPageEvent event) {
        this.events.add(event);
    }

    public void onChapter(PdfWriter writer, Document document, float paragraphPosition, Paragraph title) {
        Iterator i = this.events.iterator();
        while (i.hasNext()) {
            PdfPageEvent event = (PdfPageEvent)i.next();
            event.onChapter(writer, document, paragraphPosition, title);
        }
    }

    public void onChapterEnd(PdfWriter writer, Document document, float position) {
        Iterator i = this.events.iterator();
        while (i.hasNext()) {
            PdfPageEvent event = (PdfPageEvent)i.next();
            event.onChapterEnd(writer, document, position);
        }
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        Iterator i = this.events.iterator();
        while (i.hasNext()) {
            PdfPageEvent event = (PdfPageEvent)i.next();
            event.onCloseDocument(writer, document);
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        Iterator i = this.events.iterator();
        while (i.hasNext()) {
            PdfPageEvent event = (PdfPageEvent)i.next();
            event.onEndPage(writer, document);
        }
    }

    public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {
        Iterator i = this.events.iterator();
        while (i.hasNext()) {
            PdfPageEvent event = (PdfPageEvent)i.next();
            event.onGenericTag(writer, document, rect, text);
        }
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        Iterator i = this.events.iterator();
        while (i.hasNext()) {
            PdfPageEvent event = (PdfPageEvent)i.next();
            event.onOpenDocument(writer, document);
        }
    }

    public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {
        Iterator i = this.events.iterator();
        while (i.hasNext()) {
            PdfPageEvent event = (PdfPageEvent)i.next();
            event.onParagraph(writer, document, paragraphPosition);
        }
    }

    public void onParagraphEnd(PdfWriter writer, Document document, float paragraphPosition) {
        Iterator i = this.events.iterator();
        while (i.hasNext()) {
            PdfPageEvent event = (PdfPageEvent)i.next();
            event.onParagraphEnd(writer, document, paragraphPosition);
        }
    }

    public void onSection(PdfWriter writer, Document document, float paragraphPosition, int depth, Paragraph title) {
        Iterator i = this.events.iterator();
        while (i.hasNext()) {
            PdfPageEvent event = (PdfPageEvent)i.next();
            event.onSection(writer, document, paragraphPosition, depth, title);
        }
    }

    public void onSectionEnd(PdfWriter writer, Document document, float position) {
        Iterator i = this.events.iterator();
        while (i.hasNext()) {
            PdfPageEvent event = (PdfPageEvent)i.next();
            event.onSectionEnd(writer, document, position);
        }
    }

    public void onStartPage(PdfWriter writer, Document document) {
        Iterator i = this.events.iterator();
        while (i.hasNext()) {
            PdfPageEvent event = (PdfPageEvent)i.next();
            event.onStartPage(writer, document);
        }
    }
}

