/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf;

import com.lowagie2.text.Cell;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Element;
import com.lowagie2.text.Row;
import com.lowagie2.text.Table;
import com.lowagie2.text.rtf.RtfCell;
import com.lowagie2.text.rtf.RtfTable;
import com.lowagie2.text.rtf.RtfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfRow {
    private Color borderColor = null;
    private float borderWidth = 0.0f;
    private int borders = 0;
    private int cellpadding = 115;
    private ArrayList cells = new ArrayList();
    private int cellspacing = 14;
    private static final byte[] graphLeft;
    private RtfTable mainTable = null;
    private Row origRow = null;
    private static final byte[] rowAlignCenter;
    private static final byte[] rowAlignLeft;
    private static final byte[] rowAlignRight;
    private static final byte[] rowAutofit;
    private static final byte[] rowBegin;
    private static final byte[] rowBorderBottom;
    private static final byte[] rowBorderInlineHorizontal;
    private static final byte[] rowBorderInlineVertical;
    private static final byte[] rowBorderLeft;
    private static final byte[] rowBorderRight;
    private static final byte[] rowBorderTop;
    private static final byte[] rowEnd;
    private static final byte[] rowHeader;
    private static final byte[] rowKeep;
    private static final byte[] rowPaddingLeft;
    private static final byte[] rowPaddingLeftStyle;
    private static final byte[] rowPaddingRight;
    private static final byte[] rowPaddingRightStyle;
    private static final byte[] rowSpacingBottom;
    private static final byte[] rowSpacingBottomStyle;
    private static final byte[] rowSpacingLeft;
    private static final byte[] rowSpacingLeftStyle;
    private static final byte[] rowSpacingRight;
    private static final byte[] rowSpacingRightStyle;
    private static final byte[] rowSpacingTop;
    private static final byte[] rowSpacingTopStyle;
    private static final byte[] rowWidth;
    private static final byte[] rowWidthStyle;
    public static final byte[] tableBorder;
    public static final byte[] tableBorderColor;
    public static final byte[] tableBorderWidth;
    private int width = 100;
    private RtfWriter writer = null;

    static {
        tableBorder = "brdrs".getBytes();
        tableBorderWidth = "brdrw".getBytes();
        tableBorderColor = "brdrcf".getBytes();
        rowBegin = "trowd".getBytes();
        rowEnd = "row".getBytes();
        rowAutofit = "trautofit1".getBytes();
        graphLeft = "trgaph".getBytes();
        rowBorderLeft = "trbrdrl".getBytes();
        rowBorderRight = "trbrdrr".getBytes();
        rowBorderTop = "trbrdrt".getBytes();
        rowBorderBottom = "trbrdrb".getBytes();
        rowBorderInlineHorizontal = "trbrdrh".getBytes();
        rowBorderInlineVertical = "trbrdrv".getBytes();
        rowSpacingLeft = "trspdl".getBytes();
        rowSpacingRight = "trspdr".getBytes();
        rowSpacingTop = "trspdt".getBytes();
        rowSpacingBottom = "trspdb".getBytes();
        rowSpacingLeftStyle = "trspdfl3".getBytes();
        rowSpacingRightStyle = "trspdfr3".getBytes();
        rowSpacingTopStyle = "trspdft3".getBytes();
        rowSpacingBottomStyle = "trspdfb3".getBytes();
        rowPaddingLeft = "trpaddl".getBytes();
        rowPaddingRight = "trpaddr".getBytes();
        rowPaddingLeftStyle = "trpaddfl3".getBytes();
        rowPaddingRightStyle = "trpaddfr3".getBytes();
        rowWidthStyle = "trftsWidth3".getBytes();
        rowWidth = "trwWidth".getBytes();
        rowHeader = "trhdr".getBytes();
        rowKeep = "trkeep".getBytes();
        rowAlignLeft = "trql".getBytes();
        rowAlignCenter = "trqc".getBytes();
        rowAlignRight = "trqr".getBytes();
    }

    public RtfRow(RtfWriter writer, RtfTable mainTable) {
        this.writer = writer;
        this.mainTable = mainTable;
    }

    public boolean importRow(Row row, float[] propWidths, int tableWidth, int pageWidth, int cellpadding, int cellspacing, int borders, Color borderColor, float borderWidth, int y) {
        this.origRow = row;
        this.width = pageWidth / 100 * tableWidth;
        this.cellpadding = cellpadding;
        this.cellspacing = cellspacing;
        this.borders = borders;
        this.borderColor = borderColor;
        this.borderWidth = borderWidth;
        if (this.borderWidth > 2.0f) {
            this.borderWidth = 2.0f;
        }
        int cellLeft = 0;
        int i = 0;
        while (i < row.columns()) {
            RtfCell rtfCell;
            Element cell = (Element)row.getCell(i);
            int cellWidth = (int)((float)(this.width / 100) * propWidths[i]);
            if (cell != null) {
                if (cell.type() == 20) {
                    rtfCell = (RtfCell)this.cells.get(i);
                    cellLeft = rtfCell.importCell((Cell)cell, cellLeft, cellWidth, i, y, cellpadding);
                }
            } else {
                rtfCell = (RtfCell)this.cells.get(i);
                cellLeft = rtfCell.importCell(null, cellLeft, cellWidth, i, y, cellpadding);
            }
            ++i;
        }
        int columns = row.columns();
        int i2 = 0;
        while (i2 < columns) {
            RtfCell firstCell = (RtfCell)this.cells.get(i2);
            Cell cell = firstCell.getStore();
            int cols = 0;
            if (cell != null) {
                cols = cell.colspan();
            }
            if (cols > 1) {
                RtfCell lastCell = (RtfCell)this.cells.get(i2 + cols - 1);
                firstCell.setCellRight(lastCell.getCellRight());
                int width = firstCell.getCellWidth();
                int j = i2 + 1;
                while (j < i2 + cols) {
                    RtfCell cCell = (RtfCell)this.cells.get(j);
                    width += cCell.getCellWidth();
                    ++j;
                }
                firstCell.setCellWidth(width);
                i2 += cols - 1;
            }
            ++i2;
        }
        return true;
    }

    public void pregenerateRows(int columns) {
        int i = 0;
        while (i < columns) {
            RtfCell rtfCell = new RtfCell(this.writer, this.mainTable);
            this.cells.add(rtfCell);
            ++i;
        }
    }

    public void setMerge(int x, int mergeType, RtfCell mergeCell) {
        RtfCell cell = (RtfCell)this.cells.get(x);
        cell.setMerge(mergeType, mergeCell);
    }

    private void writeBorder(ByteArrayOutputStream os, byte[] borderType) throws IOException {
        os.write(92);
        os.write(borderType);
        os.write(92);
        os.write(tableBorder);
        os.write(92);
        os.write(tableBorderWidth);
        this.writeInt(os, (int)((double)this.borderWidth * 20.0));
        os.write(92);
        os.write(tableBorderColor);
        if (this.borderColor == null) {
            this.writeInt(os, this.writer.addColor(new Color(0, 0, 0)));
        } else {
            this.writeInt(os, this.writer.addColor(this.borderColor));
        }
        os.write(10);
    }

    private void writeInt(ByteArrayOutputStream out, int i) throws IOException {
        out.write(Integer.toString(i).getBytes());
    }

    public boolean writeRow(ByteArrayOutputStream os, int rowNum, Table table) throws DocumentException, IOException {
        RtfCell cell;
        os.write(92);
        os.write(rowBegin);
        os.write(10);
        os.write(92);
        os.write(rowWidthStyle);
        os.write(92);
        os.write(rowWidth);
        this.writeInt(os, this.width);
        if (this.mainTable.getOriginalTable().hasToFitPageCells()) {
            os.write(92);
            os.write(rowKeep);
        }
        if (rowNum < table.firstDataRow()) {
            os.write(92);
            os.write(rowHeader);
        }
        os.write(92);
        switch (this.origRow.horizontalAlignment()) {
            case 0: {
                os.write(rowAlignLeft);
                break;
            }
            case 1: {
                os.write(rowAlignCenter);
                break;
            }
            case 2: {
                os.write(rowAlignRight);
                break;
            }
            default: {
                os.write(rowAlignLeft);
            }
        }
        os.write(92);
        os.write(graphLeft);
        this.writeInt(os, 10);
        if ((this.borders & 4) == 4 && this.borderWidth > 0.0f) {
            this.writeBorder(os, rowBorderLeft);
        }
        if ((this.borders & 1) == 1 && this.borderWidth > 0.0f) {
            this.writeBorder(os, rowBorderTop);
        }
        if ((this.borders & 2) == 2 && this.borderWidth > 0.0f) {
            this.writeBorder(os, rowBorderBottom);
        }
        if ((this.borders & 8) == 8 && this.borderWidth > 0.0f) {
            this.writeBorder(os, rowBorderRight);
        }
        if ((this.borders & 0xF) == 15 && this.borderWidth > 0.0f) {
            this.writeBorder(os, rowBorderInlineHorizontal);
            this.writeBorder(os, rowBorderInlineVertical);
        }
        if (this.cellspacing > 0) {
            os.write(92);
            os.write(rowSpacingLeft);
            this.writeInt(os, this.cellspacing / 2);
            os.write(92);
            os.write(rowSpacingLeftStyle);
            os.write(92);
            os.write(rowSpacingTop);
            this.writeInt(os, this.cellspacing / 2);
            os.write(92);
            os.write(rowSpacingTopStyle);
            os.write(92);
            os.write(rowSpacingBottom);
            this.writeInt(os, this.cellspacing / 2);
            os.write(92);
            os.write(rowSpacingBottomStyle);
            os.write(92);
            os.write(rowSpacingRight);
            this.writeInt(os, this.cellspacing / 2);
            os.write(92);
            os.write(rowSpacingRightStyle);
        }
        os.write(92);
        os.write(rowPaddingLeft);
        this.writeInt(os, this.cellpadding / 2);
        os.write(92);
        os.write(rowPaddingRight);
        this.writeInt(os, this.cellpadding / 2);
        os.write(92);
        os.write(rowPaddingLeftStyle);
        os.write(92);
        os.write(rowPaddingRightStyle);
        os.write(10);
        Iterator cellIterator = this.cells.iterator();
        while (cellIterator.hasNext()) {
            cell = (RtfCell)cellIterator.next();
            cell.writeCellSettings(os);
        }
        os.write(92);
        os.write("intbl".getBytes());
        cellIterator = this.cells.iterator();
        while (cellIterator.hasNext()) {
            cell = (RtfCell)cellIterator.next();
            cell.writeCellContent(os);
        }
        os.write(32);
        os.write(92);
        os.write(rowEnd);
        return true;
    }
}

