/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf;

import com.lowagie2.text.Anchor;
import com.lowagie2.text.Annotation;
import com.lowagie2.text.Chunk;
import com.lowagie2.text.DocListener;
import com.lowagie2.text.DocWriter;
import com.lowagie2.text.Document;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Element;
import com.lowagie2.text.Font;
import com.lowagie2.text.HeaderFooter;
import com.lowagie2.text.Image;
import com.lowagie2.text.List;
import com.lowagie2.text.ListItem;
import com.lowagie2.text.Meta;
import com.lowagie2.text.PageSize;
import com.lowagie2.text.Paragraph;
import com.lowagie2.text.Phrase;
import com.lowagie2.text.Rectangle;
import com.lowagie2.text.Section;
import com.lowagie2.text.SimpleTable;
import com.lowagie2.text.Table;
import com.lowagie2.text.pdf.codec.wmf.MetaDo;
import com.lowagie2.text.rtf.RtfCell;
import com.lowagie2.text.rtf.RtfField;
import com.lowagie2.text.rtf.RtfHeaderFooter;
import com.lowagie2.text.rtf.RtfHeaderFooters;
import com.lowagie2.text.rtf.RtfPageNumber;
import com.lowagie2.text.rtf.RtfTOC;
import com.lowagie2.text.rtf.RtfTOCEntry;
import com.lowagie2.text.rtf.RtfTable;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;

public class RtfWriter
extends DocWriter
implements DocListener {
    public static final double TWIPSFACTOR = 20.0;
    public static final byte[] alignCenter;
    public static final byte[] alignJustify;
    public static final byte[] alignLeft;
    public static final byte[] alignRight;
    private static final byte[] annotation;
    private static final byte[] annotationAuthor;
    private static final byte[] annotationID;
    private static final byte[] ansi;
    private static final byte[] ansiCodepage;
    protected static final byte bold = 98;
    public static final byte closeGroup = 125;
    private static final byte[] colorBlue;
    private static final byte[] colorGreen;
    private ArrayList colorList;
    private static final byte[] colorRed;
    private static final byte[] colorTable;
    private static final byte commaDelimiter = 59;
    private ByteArrayOutputStream content = null;
    private int currentListID = 1;
    private static final byte[] day;
    private static final byte[] defaultFont;
    protected static final byte delimiter = 32;
    private static final byte[] docBegin;
    private static final byte[] endSuperSub;
    public static final byte escape = 92;
    private static final byte[] extendedEscape;
    private static final byte[] facingPages;
    protected static final byte[] field;
    protected static final byte[] fieldContent;
    protected static final byte[] fieldDisplay;
    protected static final byte[] fieldHyperlink;
    protected static final byte[] fieldPage;
    private static final byte[] firstIndent;
    private static final byte[] fontArial;
    private static final byte[] fontCharset;
    protected static final byte[] fontColor;
    private static final byte[] fontCourier;
    private ArrayList fontList = new ArrayList();
    private static final byte[] fontModern;
    protected static final byte fontNumber = 102;
    private static final byte[] fontRoman;
    protected static final byte[] fontSize;
    private static final byte[] fontSwiss;
    private static final byte[] fontSymbol;
    private static final byte[] fontTable;
    private static final byte[] fontTech;
    private static final byte[] fontTimesNewRoman;
    private static final byte[] fontWindings;
    private HeaderFooter footer = null;
    private static final byte[] footerBegin;
    private static final byte[] footerfBegin;
    private static final byte[] footerlBegin;
    private static final byte[] footerrBegin;
    private boolean hasTitlePage = false;
    private HeaderFooter header = null;
    private static final byte[] headerBegin;
    private static final byte[] headerfBegin;
    private static final byte[] headerlBegin;
    private static final byte[] headerrBegin;
    private static final byte[] hour;
    private static final byte[] hybridList;
    private boolean inHeaderFooter = false;
    private boolean inTable = false;
    private ByteArrayOutputStream info = null;
    private static final byte[] infoBegin;
    protected static final byte italic = 105;
    private boolean landscape = false;
    private static final byte[] landscapeTag1;
    private static final byte[] landscapeTag2;
    private static final byte[] listBegin;
    private static final byte[] listBulletOld;
    private static final byte[] listCurrentLevel;
    private static final byte[] listDefinition;
    private static final byte[] listID;
    private ArrayList listIds = null;
    private static final byte[] listIndent;
    private int listLevel = 0;
    private static final byte[] listLevelAlignNew;
    private static final byte[] listLevelAlignOld;
    private static final byte[] listLevelDefinition;
    private static final byte[] listLevelNumbers;
    private static final byte[] listLevelNumbersDefinition;
    private static final byte[] listLevelStartAt;
    private static final byte[] listLevelTextDefinition;
    private static final byte[] listLevelTextLength;
    private static final byte[] listLevelTextStyleBullet;
    private static final byte[] listLevelTextStyleNumbers;
    private static final byte[] listLevelTypeNew;
    private static final byte[] listLevelTypeOld;
    private static final byte[] listOverride;
    private static final byte[] listOverrideCount;
    private static final byte[] listTemplateID;
    private static final byte[] listTextOld;
    private ByteArrayOutputStream listoverride = null;
    private static final byte[] listoverridetableGroup;
    private ByteArrayOutputStream listtable = null;
    private static final byte[] listtableGroup;
    private int marginBottom = 1440;
    private int marginLeft = 1800;
    private int marginRight = 1800;
    private int marginTop = 1440;
    private int maxListLevel = 0;
    private static final byte[] metaAuthor;
    private static final byte[] metaCreationDate;
    private static final byte[] metaKeywords;
    private static final byte[] metaProducer;
    private static final byte[] metaSubject;
    private static final byte[] metaTitle;
    private static final byte[] minute;
    private static final byte[] month;
    private static final byte[] newPage;
    public static final byte openGroup = 123;
    private int pageHeight = 16838;
    private int pageWidth = 11906;
    public static final byte[] paragraph;
    public static final byte[] paragraphDefaults;
    private static final byte[] picture;
    private static final byte[] pictureBMP;
    private static final byte[] pictureGroup;
    private static final byte[] pictureHeight;
    private static final byte[] pictureJPEG;
    private static final byte[] picturePNG;
    private static final byte[] pictureScaleX;
    private static final byte[] pictureScaleY;
    private static final byte[] pictureWMF;
    private static final byte[] pictureWidth;
    private static final byte[] rightIndent;
    private static final byte[] rtfMarginBottom;
    private static final byte[] rtfMarginLeft;
    private static final byte[] rtfMarginRight;
    private static final byte[] rtfMarginTop;
    private static final byte[] rtfPaperHeight;
    private static final byte[] rtfPaperWidth;
    private static final byte[] second;
    private static final byte[] section;
    private static final byte[] sectionDefaults;
    public static final byte[] sectionPageHeight;
    public static final byte[] sectionPageWidth;
    private static final byte[] startSub;
    private static final byte[] startSuper;
    protected static final byte[] strikethrough;
    private static final byte[] tab;
    private static final byte[] tabStop;
    private static final byte[] titlePage;
    protected static final byte[] underline;
    private boolean writeTOC = false;
    private static final byte[] year;

    static {
        extendedEscape = "\\*\\".getBytes();
        docBegin = "rtf1".getBytes();
        ansi = "ansi".getBytes();
        ansiCodepage = "ansicpg".getBytes();
        fontTable = "fonttbl".getBytes();
        fontSize = "fs".getBytes();
        fontColor = "cf".getBytes();
        fontModern = "fmodern".getBytes();
        fontSwiss = "fswiss".getBytes();
        fontRoman = "froman".getBytes();
        fontTech = "ftech".getBytes();
        fontCharset = "fcharset".getBytes();
        fontCourier = "Courier".getBytes();
        fontArial = "Arial".getBytes();
        fontSymbol = "Symbol".getBytes();
        fontTimesNewRoman = "Times New Roman".getBytes();
        fontWindings = "Windings".getBytes();
        defaultFont = "deff".getBytes();
        firstIndent = "fi".getBytes();
        listIndent = "li".getBytes();
        rightIndent = "ri".getBytes();
        sectionDefaults = "sectd".getBytes();
        section = "sect".getBytes();
        paragraphDefaults = "pard".getBytes();
        paragraph = "par".getBytes();
        sectionPageWidth = "pgwsxn".getBytes();
        sectionPageHeight = "pghsxn".getBytes();
        listtableGroup = "listtable".getBytes();
        listoverridetableGroup = "listoverridetable".getBytes();
        listDefinition = "list".getBytes();
        listTemplateID = "listtemplateid".getBytes();
        hybridList = "hybrid".getBytes();
        listLevelDefinition = "listlevel".getBytes();
        listLevelTypeOld = "levelnfc".getBytes();
        listLevelTypeNew = "levelnfcn".getBytes();
        listLevelAlignOld = "leveljc".getBytes();
        listLevelAlignNew = "leveljcn".getBytes();
        listLevelStartAt = "levelstartat".getBytes();
        listLevelTextDefinition = "leveltext".getBytes();
        listLevelTextLength = "'0".getBytes();
        listLevelTextStyleNumbers = "'00.".getBytes();
        listLevelTextStyleBullet = "u-3913 ?".getBytes();
        listLevelNumbersDefinition = "levelnumbers".getBytes();
        listLevelNumbers = "\\'0".getBytes();
        tabStop = "tx".getBytes();
        listBegin = "ls".getBytes();
        listCurrentLevel = "ilvl".getBytes();
        listTextOld = "listtext".getBytes();
        tab = "tab".getBytes();
        listBulletOld = "'b7".getBytes();
        listID = "listid".getBytes();
        listOverride = "listoverride".getBytes();
        listOverrideCount = "listoverridecount".getBytes();
        underline = "ul".getBytes();
        strikethrough = "strike".getBytes();
        alignLeft = "ql".getBytes();
        alignCenter = "qc".getBytes();
        alignRight = "qr".getBytes();
        alignJustify = "qj".getBytes();
        colorTable = "colortbl".getBytes();
        colorRed = "red".getBytes();
        colorGreen = "green".getBytes();
        colorBlue = "blue".getBytes();
        infoBegin = "info".getBytes();
        metaAuthor = "author".getBytes();
        metaSubject = "subject".getBytes();
        metaKeywords = "keywords".getBytes();
        metaTitle = "title".getBytes();
        metaProducer = "operator".getBytes();
        metaCreationDate = "creationdate".getBytes();
        year = "yr".getBytes();
        month = "mo".getBytes();
        day = "dy".getBytes();
        hour = "hr".getBytes();
        minute = "min".getBytes();
        second = "sec".getBytes();
        startSuper = "super".getBytes();
        startSub = "sub".getBytes();
        endSuperSub = "nosupersub".getBytes();
        titlePage = "titlepg".getBytes();
        facingPages = "facingp".getBytes();
        headerBegin = "header".getBytes();
        footerBegin = "footer".getBytes();
        headerlBegin = "headerl".getBytes();
        footerlBegin = "footerl".getBytes();
        headerrBegin = "headerr".getBytes();
        footerrBegin = "footerr".getBytes();
        headerfBegin = "headerf".getBytes();
        footerfBegin = "footerf".getBytes();
        rtfPaperWidth = "paperw".getBytes();
        rtfPaperHeight = "paperh".getBytes();
        rtfMarginLeft = "margl".getBytes();
        rtfMarginRight = "margr".getBytes();
        rtfMarginTop = "margt".getBytes();
        rtfMarginBottom = "margb".getBytes();
        newPage = "page".getBytes();
        landscapeTag1 = "landscape".getBytes();
        landscapeTag2 = "lndscpsxn".getBytes();
        annotationID = "atnid".getBytes();
        annotationAuthor = "atnauthor".getBytes();
        annotation = "annotation".getBytes();
        pictureGroup = "shppict".getBytes();
        picture = "pict".getBytes();
        picturePNG = "pngblip".getBytes();
        pictureJPEG = "jpegblip".getBytes();
        pictureBMP = "dibitmap0".getBytes();
        pictureWMF = "wmetafile8".getBytes();
        pictureWidth = "picw".getBytes();
        pictureHeight = "pich".getBytes();
        pictureScaleX = "picscalex".getBytes();
        pictureScaleY = "picscaley".getBytes();
        field = "field".getBytes();
        fieldContent = "fldinst".getBytes();
        fieldPage = "PAGE".getBytes();
        fieldHyperlink = "HYPERLINK".getBytes();
        fieldDisplay = "fldrslt".getBytes();
    }

    protected RtfWriter(Document doc, OutputStream os) {
        super(doc, os);
        this.colorList = new ArrayList();
        this.document.addDocListener(this);
        this.initDefaults();
    }

    public boolean add(Element element) throws DocumentException {
        if (this.pause) {
            return false;
        }
        return this.addElement(element, this.content);
    }

    protected int addColor(Color newColor) {
        int cn = 0;
        if (newColor == null) {
            return cn;
        }
        cn = this.colorList.indexOf(newColor);
        if (cn == -1) {
            this.colorList.add(newColor);
            return this.colorList.size() - 1;
        }
        return cn;
    }

    protected boolean addElement(Element element, ByteArrayOutputStream out) throws DocumentException {
        try {
            switch (element.type()) {
                case 10: {
                    this.writeChunk((Chunk)element, out);
                    break;
                }
                case 12: {
                    this.writeParagraph((Paragraph)element, out);
                    break;
                }
                case 17: {
                    this.writeAnchor((Anchor)element, out);
                    break;
                }
                case 11: {
                    this.writePhrase((Phrase)element, out);
                    break;
                }
                case 13: 
                case 16: {
                    this.writeSection((Section)element, out);
                    break;
                }
                case 14: {
                    this.writeList((List)element, out);
                    break;
                }
                case 22: {
                    try {
                        this.writeTable((Table)element, out);
                    }
                    catch (ClassCastException cce) {
                        this.writeTable(((SimpleTable)element).createTable(), out);
                    }
                    break;
                }
                case 29: {
                    this.writeAnnotation((Annotation)element, out);
                    break;
                }
                case 32: 
                case 34: 
                case 35: {
                    Image img = (Image)element;
                    this.writeImage(img, out);
                    break;
                }
                case 4: {
                    this.writeMeta(metaAuthor, (Meta)element);
                    break;
                }
                case 2: {
                    this.writeMeta(metaSubject, (Meta)element);
                    break;
                }
                case 3: {
                    this.writeMeta(metaKeywords, (Meta)element);
                    break;
                }
                case 1: {
                    this.writeMeta(metaTitle, (Meta)element);
                    break;
                }
                case 5: {
                    this.writeMeta(metaProducer, (Meta)element);
                    break;
                }
                case 6: {
                    this.writeMeta(metaCreationDate, (Meta)element);
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected int addFont(Font newFont) {
        int fn = -1;
        int i = 0;
        while (i < this.fontList.size()) {
            if (newFont.getFamilyname().equals(((Font)this.fontList.get(i)).getFamilyname())) {
                fn = i;
            }
            ++i;
        }
        if (fn == -1) {
            this.fontList.add(newFont);
            return this.fontList.size() - 1;
        }
        return fn;
    }

    private void addHeaderFooterFontColor(HeaderFooter hf) {
        if (hf instanceof RtfHeaderFooter) {
            RtfHeaderFooter rhf = (RtfHeaderFooter)hf;
            if (rhf.content() instanceof Chunk) {
                this.addFont(((Chunk)rhf.content()).font());
                this.addColor(((Chunk)rhf.content()).font().color());
            } else if (rhf.content() instanceof Phrase) {
                this.addFont(((Phrase)rhf.content()).font());
                this.addColor(((Phrase)rhf.content()).font().color());
            }
        }
        if (hf.getBefore() != null) {
            this.addFont(hf.getBefore().font());
            this.addColor(hf.getBefore().font().color());
        }
        if (hf.getAfter() != null) {
            this.addFont(hf.getAfter().font());
            this.addColor(hf.getAfter().font().color());
        }
    }

    public void close() {
        this.writeDocument();
        super.close();
    }

    public static final String filterSpecialChar(String str, boolean useHex) {
        int length = str.length();
        char z = 'z';
        StringBuffer ret = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            char ch = str.charAt(i);
            if (ch == '\\') {
                ret.append("\\\\");
            } else if (ch == '\n') {
                ret.append("\\par ");
            } else if (ch > z) {
                if (useHex) {
                    ret.append("\\'").append(Long.toHexString(ch));
                } else {
                    ret.append("\\u").append((long)ch).append('?');
                }
            } else {
                ret.append(ch);
            }
            ++i;
        }
        String s = ret.toString();
        if (s.indexOf("$newpage$") >= 0) {
            String before = s.substring(0, s.indexOf("$newpage$"));
            String after = s.substring(s.indexOf("$newpage$") + 9);
            ret = new StringBuffer(before);
            ret.append("\\page\\par ");
            ret.append(after);
            return ret.toString();
        }
        return s;
    }

    public boolean getGeneratingTOCEntries() {
        return this.writeTOC;
    }

    public boolean getHasTitlePage() {
        return this.hasTitlePage;
    }

    public static RtfWriter getInstance(Document document, OutputStream os) {
        return new RtfWriter(document, os);
    }

    public boolean getLandscape() {
        return this.landscape;
    }

    private int getRandomInt() {
        boolean ok = false;
        Integer newInt = null;
        Integer oldInt = null;
        while (!ok) {
            newInt = new Integer((int)(Math.random() * 2.147483647E9));
            ok = true;
            int i = 0;
            while (i < this.listIds.size()) {
                oldInt = (Integer)this.listIds.get(i);
                if (oldInt.equals(newInt)) {
                    ok = true;
                }
                ++i;
            }
        }
        this.listIds.add(newInt);
        return newInt;
    }

    private void initDefaults() {
        this.fontList.clear();
        this.colorList.clear();
        this.info = new ByteArrayOutputStream();
        this.content = new ByteArrayOutputStream();
        this.listtable = new ByteArrayOutputStream();
        this.listoverride = new ByteArrayOutputStream();
        this.document.addProducer();
        this.document.addCreationDate();
        this.addFont(new Font(2, 10.0f, 0));
        this.addColor(new Color(0, 0, 0));
        this.addColor(new Color(255, 255, 255));
        this.listIds = new ArrayList();
        try {
            this.listtable.write(123);
            this.listtable.write(extendedEscape);
            this.listtable.write(listtableGroup);
            this.listtable.write(10);
            this.listoverride.write(123);
            this.listoverride.write(extendedEscape);
            this.listoverride.write(listoverridetableGroup);
            this.listoverride.write(10);
        }
        catch (IOException e) {
            System.err.println("InitDefaultsError" + e);
        }
    }

    public boolean newPage() throws DocumentException {
        try {
            this.content.write(92);
            this.content.write(newPage);
            this.content.write(92);
            this.content.write(paragraph);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void open() {
        super.open();
    }

    private boolean parseFormat(Rectangle pageSize, boolean rotate) {
        if (rotate) {
            pageSize = pageSize.rotate();
        }
        if (this.rectEquals(pageSize, PageSize.A3)) {
            this.pageWidth = 16837;
            this.pageHeight = 23811;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.A4)) {
            this.pageWidth = 11907;
            this.pageHeight = 16840;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.A5)) {
            this.pageWidth = 8391;
            this.pageHeight = 11907;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.A6)) {
            this.pageWidth = 5959;
            this.pageHeight = 8420;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.B4)) {
            this.pageWidth = 14570;
            this.pageHeight = 20636;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.B5)) {
            this.pageWidth = 10319;
            this.pageHeight = 14572;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.HALFLETTER)) {
            this.pageWidth = 7927;
            this.pageHeight = 12247;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.LETTER)) {
            this.pageWidth = 12242;
            this.pageHeight = 15842;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.LEGAL)) {
            this.pageWidth = 12252;
            this.pageHeight = 20163;
            this.landscape = rotate;
            return true;
        }
        if (!rotate && this.parseFormat(pageSize, true)) {
            int x = this.pageWidth;
            this.pageWidth = this.pageHeight;
            this.pageHeight = x;
            return true;
        }
        return false;
    }

    private void processHeaderFooter(HeaderFooter hf) {
        if (hf != null) {
            if (hf instanceof RtfHeaderFooters) {
                RtfHeaderFooters rhf = (RtfHeaderFooters)hf;
                if (rhf.get(0) != null) {
                    this.addHeaderFooterFontColor(rhf.get(0));
                }
                if (rhf.get(1) != null) {
                    this.addHeaderFooterFontColor(rhf.get(1));
                }
                if (rhf.get(2) != null) {
                    this.addHeaderFooterFontColor(rhf.get(2));
                }
                if (rhf.get(3) != null) {
                    this.addHeaderFooterFontColor(rhf.get(3));
                }
            } else {
                this.addHeaderFooterFontColor(hf);
            }
        }
    }

    private boolean rectEquals(Rectangle rect1, Rectangle rect2) {
        return rect1.width() == rect2.width() && rect1.height() == rect2.height();
    }

    public void resetFooter() {
        this.setFooter(null);
    }

    public void resetHeader() {
        this.setHeader(null);
    }

    public void setFooter(HeaderFooter footer) {
        this.footer = footer;
        this.processHeaderFooter(this.footer);
    }

    public void setGenerateTOCEntries(boolean writeTOC) {
        this.writeTOC = writeTOC;
    }

    public void setHasTitlePage(boolean hasTitlePage) {
        this.hasTitlePage = hasTitlePage;
    }

    public void setHeader(HeaderFooter header) {
        this.header = header;
        this.processHeaderFooter(this.header);
    }

    public void setLandscape(boolean landscape) {
        this.landscape = landscape;
    }

    public boolean setMarginMirroring(boolean MarginMirroring) {
        return false;
    }

    public boolean setMargins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this.marginLeft = (int)((double)marginLeft * 20.0);
        this.marginRight = (int)((double)marginRight * 20.0);
        this.marginTop = (int)((double)marginTop * 20.0);
        this.marginBottom = (int)((double)marginBottom * 20.0);
        return true;
    }

    public boolean setPageSize(Rectangle pageSize) {
        if (!this.parseFormat(pageSize, false)) {
            this.pageWidth = (int)((double)pageSize.width() * 20.0);
            this.pageHeight = (int)((double)pageSize.height() * 20.0);
            this.landscape = this.pageWidth > this.pageHeight;
        }
        return true;
    }

    private void writeAnchor(Anchor anchor, ByteArrayOutputStream out) throws IOException {
        if (anchor.url() != null) {
            out.write(123);
            out.write(92);
            out.write(field);
            out.write(123);
            out.write(extendedEscape);
            out.write(fieldContent);
            out.write(123);
            out.write(fieldHyperlink);
            out.write(32);
            out.write(anchor.url().toString().getBytes());
            out.write(125);
            out.write(125);
            out.write(123);
            out.write(92);
            out.write(fieldDisplay);
            out.write(32);
            this.writePhrase(anchor, out);
            out.write(125);
            out.write(125);
        } else {
            this.writePhrase(anchor, out);
        }
    }

    private void writeAnnotation(Annotation annotationElement, ByteArrayOutputStream out) throws IOException {
        int id = this.getRandomInt();
        out.write(123);
        out.write(extendedEscape);
        out.write(annotationID);
        out.write(32);
        RtfWriter.writeInt(out, id);
        out.write(125);
        out.write(123);
        out.write(extendedEscape);
        out.write(annotationAuthor);
        out.write(32);
        out.write(annotationElement.title().getBytes());
        out.write(125);
        out.write(123);
        out.write(extendedEscape);
        out.write(annotation);
        out.write(92);
        out.write(paragraphDefaults);
        out.write(32);
        out.write(annotationElement.content().getBytes());
        out.write(125);
    }

    private void writeChunk(Chunk chunk, ByteArrayOutputStream out) throws IOException, DocumentException {
        if (chunk instanceof RtfField) {
            ((RtfField)((Object)chunk)).write(this, out);
        } else if (chunk.getImage() != null) {
            this.writeImage(chunk.getImage(), out);
        } else {
            this.writeInitialFontSignature(out, chunk);
            out.write(RtfWriter.filterSpecialChar(chunk.content(), false).getBytes());
            this.writeFinishingFontSignature(out, chunk);
        }
    }

    private void writeColorList() throws IOException {
        Color color = null;
        this.os.write(123);
        this.os.write(92);
        this.os.write(colorTable);
        int i = 0;
        while (i < this.colorList.size()) {
            color = (Color)this.colorList.get(i);
            this.os.write(92);
            this.os.write(colorRed);
            RtfWriter.writeInt(this.os, color.getRed());
            this.os.write(92);
            this.os.write(colorGreen);
            RtfWriter.writeInt(this.os, color.getGreen());
            this.os.write(92);
            this.os.write(colorBlue);
            RtfWriter.writeInt(this.os, color.getBlue());
            this.os.write(59);
            ++i;
        }
        this.os.write(125);
    }

    private boolean writeDocument() {
        try {
            this.writeDocumentIntro();
            this.writeFontList();
            this.os.write(10);
            this.writeColorList();
            this.os.write(10);
            this.writeList();
            this.os.write(10);
            this.writeInfoGroup();
            this.os.write(10);
            this.writeDocumentFormat();
            this.os.write(10);
            ByteArrayOutputStream hf = new ByteArrayOutputStream();
            this.writeSectionDefaults(hf);
            hf.writeTo(this.os);
            this.content.writeTo(this.os);
            this.os.write(125);
            return true;
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return false;
        }
    }

    private void writeDocumentFormat() throws IOException {
        this.os.write(92);
        this.os.write(rtfPaperWidth);
        RtfWriter.writeInt(this.os, this.pageWidth);
        this.os.write(92);
        this.os.write(rtfPaperHeight);
        RtfWriter.writeInt(this.os, this.pageHeight);
        this.os.write(92);
        this.os.write(rtfMarginLeft);
        RtfWriter.writeInt(this.os, this.marginLeft);
        this.os.write(92);
        this.os.write(rtfMarginRight);
        RtfWriter.writeInt(this.os, this.marginRight);
        this.os.write(92);
        this.os.write(rtfMarginTop);
        RtfWriter.writeInt(this.os, this.marginTop);
        this.os.write(92);
        this.os.write(rtfMarginBottom);
        RtfWriter.writeInt(this.os, this.marginBottom);
    }

    private void writeDocumentIntro() throws IOException {
        this.os.write(123);
        this.os.write(92);
        this.os.write(docBegin);
        this.os.write(92);
        this.os.write(ansi);
        this.os.write(92);
        this.os.write(ansiCodepage);
        RtfWriter.writeInt(this.os, 1252);
        this.os.write(10);
        this.os.write(92);
        this.os.write(defaultFont);
        RtfWriter.writeInt(this.os, 0);
    }

    protected void writeFinishingFontSignature(OutputStream out, Chunk chunk) throws IOException {
        Float f;
        Font font = chunk.font();
        if (font.isBold()) {
            out.write(92);
            out.write(98);
            RtfWriter.writeInt(out, 0);
        }
        if (font.isItalic()) {
            out.write(92);
            out.write(105);
            RtfWriter.writeInt(out, 0);
        }
        if (font.isUnderlined()) {
            out.write(92);
            out.write(underline);
            RtfWriter.writeInt(out, 0);
        }
        if (font.isStrikethru()) {
            out.write(92);
            out.write(strikethrough);
            RtfWriter.writeInt(out, 0);
        }
        if (chunk.getAttributes() != null && (f = (Float)chunk.getAttributes().get("SUBSUPSCRIPT")) != null && f.floatValue() != 0.0f) {
            out.write(92);
            out.write(endSuperSub);
        }
    }

    private void writeFontList() throws IOException {
        this.os.write(123);
        this.os.write(92);
        this.os.write(fontTable);
        int i = 0;
        while (i < this.fontList.size()) {
            Font fnt = (Font)this.fontList.get(i);
            this.os.write(123);
            this.os.write(92);
            this.os.write(102);
            RtfWriter.writeInt(this.os, i);
            this.os.write(92);
            switch (Font.getFamilyIndex(fnt.getFamilyname())) {
                case 0: {
                    this.os.write(fontModern);
                    this.os.write(92);
                    this.os.write(fontCharset);
                    RtfWriter.writeInt(this.os, 0);
                    this.os.write(32);
                    this.os.write(fontCourier);
                    break;
                }
                case 1: {
                    this.os.write(fontSwiss);
                    this.os.write(92);
                    this.os.write(fontCharset);
                    RtfWriter.writeInt(this.os, 0);
                    this.os.write(32);
                    this.os.write(fontArial);
                    break;
                }
                case 3: {
                    this.os.write(fontRoman);
                    this.os.write(92);
                    this.os.write(fontCharset);
                    RtfWriter.writeInt(this.os, 2);
                    this.os.write(32);
                    this.os.write(fontSymbol);
                    break;
                }
                case 2: {
                    this.os.write(fontRoman);
                    this.os.write(92);
                    this.os.write(fontCharset);
                    RtfWriter.writeInt(this.os, 0);
                    this.os.write(32);
                    this.os.write(fontTimesNewRoman);
                    break;
                }
                case 4: {
                    this.os.write(fontTech);
                    this.os.write(92);
                    this.os.write(fontCharset);
                    RtfWriter.writeInt(this.os, 0);
                    this.os.write(32);
                    this.os.write(fontWindings);
                    break;
                }
                default: {
                    this.os.write(fontRoman);
                    this.os.write(92);
                    this.os.write(fontCharset);
                    RtfWriter.writeInt(this.os, 0);
                    this.os.write(32);
                    this.os.write(RtfWriter.filterSpecialChar(fnt.getFamilyname(), true).getBytes());
                }
            }
            this.os.write(59);
            this.os.write(125);
            ++i;
        }
        this.os.write(125);
    }

    private void writeFormatedDateTime(String date) throws IOException {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        ParsePosition pp = new ParsePosition(0);
        Date d = sdf.parse(date, pp);
        if (d == null) {
            d = new Date();
        }
        cal.setTime(d);
        this.info.write(92);
        this.info.write(year);
        RtfWriter.writeInt(this.info, cal.get(1));
        this.info.write(92);
        this.info.write(month);
        RtfWriter.writeInt(this.info, cal.get(2));
        this.info.write(92);
        this.info.write(day);
        RtfWriter.writeInt(this.info, cal.get(5));
        this.info.write(92);
        this.info.write(hour);
        RtfWriter.writeInt(this.info, cal.get(11));
        this.info.write(92);
        this.info.write(minute);
        RtfWriter.writeInt(this.info, cal.get(12));
        this.info.write(92);
        this.info.write(second);
        RtfWriter.writeInt(this.info, cal.get(13));
    }

    private void writeHeaderFooter(HeaderFooter headerFooter, byte[] hfType, ByteArrayOutputStream target) throws IOException {
        this.inHeaderFooter = true;
        try {
            target.write(123);
            target.write(92);
            target.write(hfType);
            target.write(32);
            if (headerFooter != null) {
                if (headerFooter instanceof RtfHeaderFooter && ((RtfHeaderFooter)headerFooter).content() != null) {
                    this.addElement(((RtfHeaderFooter)headerFooter).content(), target);
                } else {
                    Paragraph par = new Paragraph();
                    par.setAlignment(headerFooter.alignment());
                    if (headerFooter.getBefore() != null) {
                        par.add(headerFooter.getBefore());
                    }
                    if (headerFooter.isNumbered()) {
                        par.add(new RtfPageNumber("", headerFooter.getBefore().font()));
                    }
                    if (headerFooter.getAfter() != null) {
                        par.add(headerFooter.getAfter());
                    }
                    this.addElement(par, target);
                }
            }
            target.write(125);
        }
        catch (DocumentException e) {
            throw new IOException("DocumentException - " + e.getMessage());
        }
        this.inHeaderFooter = false;
    }

    public void writeHeadersFooters(ByteArrayOutputStream os) throws IOException {
        HeaderFooter hf;
        RtfHeaderFooters rtfHf;
        if (this.footer instanceof RtfHeaderFooters) {
            rtfHf = (RtfHeaderFooters)this.footer;
            hf = rtfHf.get(0);
            if (hf != null) {
                this.writeHeaderFooter(hf, footerBegin, os);
            }
            if ((hf = rtfHf.get(1)) != null) {
                this.writeHeaderFooter(hf, footerlBegin, os);
            }
            if ((hf = rtfHf.get(2)) != null) {
                this.writeHeaderFooter(hf, footerrBegin, os);
            }
            if ((hf = rtfHf.get(3)) != null) {
                this.writeHeaderFooter(hf, footerfBegin, os);
            }
        } else {
            this.writeHeaderFooter(this.footer, footerBegin, os);
        }
        if (this.header instanceof RtfHeaderFooters) {
            rtfHf = (RtfHeaderFooters)this.header;
            hf = rtfHf.get(0);
            if (hf != null) {
                this.writeHeaderFooter(hf, headerBegin, os);
            }
            if ((hf = rtfHf.get(1)) != null) {
                this.writeHeaderFooter(hf, headerlBegin, os);
            }
            if ((hf = rtfHf.get(2)) != null) {
                this.writeHeaderFooter(hf, headerrBegin, os);
            }
            if ((hf = rtfHf.get(3)) != null) {
                this.writeHeaderFooter(hf, headerfBegin, os);
            }
        } else {
            this.writeHeaderFooter(this.header, headerBegin, os);
        }
    }

    private void writeImage(Image image, ByteArrayOutputStream out) throws IOException, DocumentException {
        InputStream imgIn;
        int type = image.getOriginalType();
        if (type != 1 && type != 4 && type != 2 && type != 6) {
            throw new DocumentException("Only BMP, PNG, WMF and JPEG images are supported by the RTF Writer");
        }
        switch (image.alignment()) {
            case 0: {
                out.write(92);
                out.write(alignLeft);
                break;
            }
            case 2: {
                out.write(92);
                out.write(alignRight);
                break;
            }
            case 1: {
                out.write(92);
                out.write(alignCenter);
                break;
            }
            case 3: {
                out.write(92);
                out.write(alignJustify);
            }
        }
        out.write(123);
        out.write(extendedEscape);
        out.write(pictureGroup);
        out.write(123);
        out.write(92);
        out.write(picture);
        out.write(92);
        switch (type) {
            case 1: {
                out.write(pictureJPEG);
                break;
            }
            case 2: {
                out.write(picturePNG);
                break;
            }
            case 4: 
            case 6: {
                out.write(pictureWMF);
            }
        }
        out.write(92);
        out.write(pictureWidth);
        RtfWriter.writeInt(out, (int)((double)image.plainWidth() * 20.0));
        out.write(92);
        out.write(pictureHeight);
        RtfWriter.writeInt(out, (int)((double)image.plainHeight() * 20.0));
        if (image.width() > 0.0f) {
            out.write(92);
            out.write(pictureScaleX);
            RtfWriter.writeInt(out, (int)(100.0f / image.width() * image.plainWidth()));
        }
        if (image.height() > 0.0f) {
            out.write(92);
            out.write(pictureScaleY);
            RtfWriter.writeInt(out, (int)(100.0f / image.height() * image.plainHeight()));
        }
        out.write(32);
        if (type == 4) {
            imgIn = new ByteArrayInputStream(MetaDo.wrapBMP(image));
        } else {
            imgIn = image.getOriginalData() == null ? image.url().openStream() : new ByteArrayInputStream(image.getOriginalData());
            if (type == 6) {
                long skipLength = 22L;
                while (skipLength > 0L) {
                    skipLength -= imgIn.skip(skipLength);
                }
            }
        }
        int buffer = -1;
        int count = 0;
        out.write(10);
        while ((buffer = imgIn.read()) != -1) {
            String helperStr = Integer.toHexString(buffer);
            if (helperStr.length() < 2) {
                helperStr = "0" + helperStr;
            }
            out.write(helperStr.getBytes());
            if (++count != 64) continue;
            out.write(10);
            count = 0;
        }
        imgIn.close();
        out.write(125);
        out.write(125);
        out.write(10);
    }

    private void writeInfoGroup() throws IOException {
        this.os.write(123);
        this.os.write(92);
        this.os.write(infoBegin);
        this.info.writeTo(this.os);
        this.os.write(125);
    }

    protected void writeInitialFontSignature(OutputStream out, Chunk chunk) throws IOException {
        Float f;
        Font font = chunk.font();
        out.write(92);
        out.write(102);
        if (!font.getFamilyname().equalsIgnoreCase("unknown")) {
            RtfWriter.writeInt(out, this.addFont(font));
        } else {
            RtfWriter.writeInt(out, 0);
        }
        out.write(92);
        out.write(fontSize);
        if (font.size() > 0.0f) {
            RtfWriter.writeInt(out, (int)(font.size() * 2.0f));
        } else {
            RtfWriter.writeInt(out, 20);
        }
        out.write(92);
        out.write(fontColor);
        RtfWriter.writeInt(out, this.addColor(font.color()));
        if (font.isBold()) {
            out.write(92);
            out.write(98);
        }
        if (font.isItalic()) {
            out.write(92);
            out.write(105);
        }
        if (font.isUnderlined()) {
            out.write(92);
            out.write(underline);
        }
        if (font.isStrikethru()) {
            out.write(92);
            out.write(strikethrough);
        }
        if (chunk.getAttributes() != null && (f = (Float)chunk.getAttributes().get("SUBSUPSCRIPT")) != null) {
            if (f.floatValue() > 0.0f) {
                out.write(92);
                out.write(startSuper);
            } else if (f.floatValue() < 0.0f) {
                out.write(92);
                out.write(startSub);
            }
        }
        out.write(32);
    }

    public static final void writeInt(OutputStream out, int i) throws IOException {
        out.write(Integer.toString(i).getBytes());
    }

    private void writeList() throws IOException {
        this.listtable.write(125);
        this.listoverride.write(125);
        this.listtable.writeTo(this.os);
        this.os.write(10);
        this.listoverride.writeTo(this.os);
    }

    private void writeList(List list, ByteArrayOutputStream out) throws IOException, DocumentException {
        int type = 0;
        int align = 0;
        int fontNr = this.addFont(new Font(3, 10.0f, 0, new Color(0, 0, 0)));
        if (!list.isNumbered()) {
            type = 23;
        }
        if (this.listLevel == 0) {
            this.maxListLevel = 0;
            this.listtable.write(123);
            this.listtable.write(92);
            this.listtable.write(listDefinition);
            int i = this.getRandomInt();
            this.listtable.write(92);
            this.listtable.write(listTemplateID);
            RtfWriter.writeInt(this.listtable, i);
            this.listtable.write(92);
            this.listtable.write(hybridList);
            this.listtable.write(10);
        }
        if (this.listLevel >= this.maxListLevel) {
            ++this.maxListLevel;
            this.listtable.write(123);
            this.listtable.write(92);
            this.listtable.write(listLevelDefinition);
            this.listtable.write(92);
            this.listtable.write(listLevelTypeOld);
            RtfWriter.writeInt(this.listtable, type);
            this.listtable.write(92);
            this.listtable.write(listLevelTypeNew);
            RtfWriter.writeInt(this.listtable, type);
            this.listtable.write(92);
            this.listtable.write(listLevelAlignOld);
            RtfWriter.writeInt(this.listtable, align);
            this.listtable.write(92);
            this.listtable.write(listLevelAlignNew);
            RtfWriter.writeInt(this.listtable, align);
            this.listtable.write(92);
            this.listtable.write(listLevelStartAt);
            RtfWriter.writeInt(this.listtable, 1);
            this.listtable.write(123);
            this.listtable.write(92);
            this.listtable.write(listLevelTextDefinition);
            this.listtable.write(92);
            this.listtable.write(listLevelTextLength);
            if (list.isNumbered()) {
                RtfWriter.writeInt(this.listtable, 2);
            } else {
                RtfWriter.writeInt(this.listtable, 1);
            }
            this.listtable.write(92);
            if (list.isNumbered()) {
                this.listtable.write(listLevelTextStyleNumbers);
            } else {
                this.listtable.write(listLevelTextStyleBullet);
            }
            this.listtable.write(59);
            this.listtable.write(125);
            this.listtable.write(123);
            this.listtable.write(92);
            this.listtable.write(listLevelNumbersDefinition);
            if (list.isNumbered()) {
                this.listtable.write(32);
                this.listtable.write(listLevelNumbers);
                RtfWriter.writeInt(this.listtable, this.listLevel + 1);
            }
            this.listtable.write(59);
            this.listtable.write(125);
            if (!list.isNumbered()) {
                this.listtable.write(92);
                this.listtable.write(102);
                RtfWriter.writeInt(this.listtable, fontNr);
            }
            this.listtable.write(92);
            this.listtable.write(firstIndent);
            RtfWriter.writeInt(this.listtable, (int)((double)list.indentationLeft() * 20.0 * -1.0));
            this.listtable.write(92);
            this.listtable.write(listIndent);
            RtfWriter.writeInt(this.listtable, (int)((double)(list.indentationLeft() + list.symbolIndent()) * 20.0));
            this.listtable.write(92);
            this.listtable.write(rightIndent);
            RtfWriter.writeInt(this.listtable, (int)((double)list.indentationRight() * 20.0));
            this.listtable.write(92);
            this.listtable.write(tabStop);
            RtfWriter.writeInt(this.listtable, (int)((double)list.symbolIndent() * 20.0));
            this.listtable.write(125);
            this.listtable.write(10);
        }
        out.write(92);
        out.write(paragraphDefaults);
        out.write(92);
        out.write(alignLeft);
        out.write(92);
        out.write(firstIndent);
        RtfWriter.writeInt(out, (int)((double)list.indentationLeft() * 20.0 * -1.0));
        out.write(92);
        out.write(listIndent);
        RtfWriter.writeInt(out, (int)((double)(list.indentationLeft() + list.symbolIndent()) * 20.0));
        out.write(92);
        out.write(rightIndent);
        RtfWriter.writeInt(out, (int)((double)list.indentationRight() * 20.0));
        out.write(92);
        out.write(fontSize);
        RtfWriter.writeInt(out, 20);
        out.write(92);
        out.write(listBegin);
        RtfWriter.writeInt(out, this.currentListID);
        if (this.listLevel > 0) {
            out.write(92);
            out.write(listCurrentLevel);
            RtfWriter.writeInt(out, this.listLevel);
        }
        out.write(123);
        ListIterator listItems = list.getItems().listIterator();
        int count = 1;
        while (listItems.hasNext()) {
            Element listElem = (Element)listItems.next();
            if (listElem.type() == 10) {
                listElem = new ListItem((Chunk)listElem);
            }
            if (listElem.type() == 15) {
                out.write(123);
                out.write(92);
                out.write(listTextOld);
                out.write(92);
                out.write(paragraphDefaults);
                out.write(92);
                out.write(102);
                if (list.isNumbered()) {
                    RtfWriter.writeInt(out, this.addFont(new Font(2, 0.0f, 10, new Color(0, 0, 0))));
                } else {
                    RtfWriter.writeInt(out, fontNr);
                }
                out.write(92);
                out.write(firstIndent);
                RtfWriter.writeInt(out, (int)((double)list.indentationLeft() * 20.0 * -1.0));
                out.write(92);
                out.write(listIndent);
                RtfWriter.writeInt(out, (int)((double)(list.indentationLeft() + list.symbolIndent()) * 20.0));
                out.write(92);
                out.write(rightIndent);
                RtfWriter.writeInt(out, (int)((double)list.indentationRight() * 20.0));
                out.write(32);
                if (list.isNumbered()) {
                    RtfWriter.writeInt(out, count);
                    out.write(".".getBytes());
                } else {
                    out.write(92);
                    out.write(listBulletOld);
                }
                out.write(92);
                out.write(tab);
                out.write(125);
                this.writeListElement((ListItem)listElem, out);
                ++count;
            } else if (listElem.type() == 14) {
                ++this.listLevel;
                this.writeList((List)listElem, out);
                --this.listLevel;
                out.write(92);
                out.write(paragraphDefaults);
                out.write(92);
                out.write(alignLeft);
                out.write(92);
                out.write(firstIndent);
                RtfWriter.writeInt(out, (int)((double)list.indentationLeft() * 20.0 * -1.0));
                out.write(92);
                out.write(listIndent);
                RtfWriter.writeInt(out, (int)((double)(list.indentationLeft() + list.symbolIndent()) * 20.0));
                out.write(92);
                out.write(rightIndent);
                RtfWriter.writeInt(out, (int)((double)list.indentationRight() * 20.0));
                out.write(92);
                out.write(fontSize);
                RtfWriter.writeInt(out, 20);
                out.write(92);
                out.write(listBegin);
                RtfWriter.writeInt(out, this.currentListID);
                if (this.listLevel > 0) {
                    out.write(92);
                    out.write(listCurrentLevel);
                    RtfWriter.writeInt(out, this.listLevel);
                }
            }
            out.write(10);
        }
        out.write(125);
        if (this.listLevel == 0) {
            int i = this.getRandomInt();
            this.listtable.write(92);
            this.listtable.write(listID);
            RtfWriter.writeInt(this.listtable, i);
            this.listtable.write(125);
            this.listtable.write(10);
            this.listoverride.write(123);
            this.listoverride.write(92);
            this.listoverride.write(listOverride);
            this.listoverride.write(92);
            this.listoverride.write(listID);
            RtfWriter.writeInt(this.listoverride, i);
            this.listoverride.write(92);
            this.listoverride.write(listOverrideCount);
            RtfWriter.writeInt(this.listoverride, 0);
            this.listoverride.write(92);
            this.listoverride.write(listBegin);
            RtfWriter.writeInt(this.listoverride, this.currentListID);
            ++this.currentListID;
            this.listoverride.write(125);
            this.listoverride.write(10);
        }
        out.write(92);
        out.write(paragraphDefaults);
    }

    private void writeListElement(ListItem listItem, ByteArrayOutputStream out) throws IOException, DocumentException {
        Iterator chunks = listItem.getChunks().iterator();
        while (chunks.hasNext()) {
            Chunk ch = (Chunk)chunks.next();
            this.addElement(ch, out);
        }
        out.write(92);
        out.write(paragraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMeta(byte[] metaName, Meta meta) throws IOException {
        this.info.write(123);
        try {
            this.info.write(92);
            this.info.write(metaName);
            this.info.write(32);
            if (meta.type() == 6) {
                this.writeFormatedDateTime(meta.content());
            } else {
                this.info.write(meta.content().getBytes());
            }
            Object var4_3 = null;
            this.info.write(125);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.info.write(125);
            throw throwable;
        }
    }

    private void writeParagraph(Paragraph paragraphElement, ByteArrayOutputStream out) throws IOException {
        out.write(92);
        out.write(paragraphDefaults);
        if (this.inTable) {
            out.write(92);
            out.write(RtfCell.cellInTable);
        }
        switch (paragraphElement.alignment()) {
            case 0: {
                out.write(92);
                out.write(alignLeft);
                break;
            }
            case 2: {
                out.write(92);
                out.write(alignRight);
                break;
            }
            case 1: {
                out.write(92);
                out.write(alignCenter);
                break;
            }
            case 3: 
            case 8: {
                out.write(92);
                out.write(alignJustify);
            }
        }
        out.write(92);
        out.write(listIndent);
        RtfWriter.writeInt(out, (int)((double)paragraphElement.indentationLeft() * 20.0));
        out.write(92);
        out.write(rightIndent);
        RtfWriter.writeInt(out, (int)((double)paragraphElement.indentationRight() * 20.0));
        Iterator chunks = paragraphElement.getChunks().iterator();
        while (chunks.hasNext()) {
            Chunk ch = (Chunk)chunks.next();
            ch.setFont(paragraphElement.font().difference(ch.font()));
        }
        ByteArrayOutputStream save = this.content;
        this.content = out;
        paragraphElement.process(this);
        this.content = save;
        if (!this.inTable) {
            out.write(92);
            out.write(paragraph);
        }
    }

    private void writePhrase(Phrase phrase, ByteArrayOutputStream out) throws IOException {
        out.write(92);
        out.write(paragraphDefaults);
        if (this.inTable) {
            out.write(92);
            out.write(RtfCell.cellInTable);
        }
        Iterator chunks = phrase.getChunks().iterator();
        while (chunks.hasNext()) {
            Chunk ch = (Chunk)chunks.next();
            ch.setFont(phrase.font().difference(ch.font()));
        }
        ByteArrayOutputStream save = this.content;
        this.content = out;
        phrase.process(this);
        this.content = save;
    }

    private void writeSection(Section sectionElement, ByteArrayOutputStream out) throws IOException, DocumentException {
        if (sectionElement.type() == 16) {
            // empty if block
        }
        if (sectionElement.title() != null) {
            if (this.writeTOC) {
                StringBuffer title = new StringBuffer("");
                ListIterator li = sectionElement.title().getChunks().listIterator();
                while (li.hasNext()) {
                    title.append(((Chunk)li.next()).content());
                }
                this.add(new RtfTOCEntry(title.toString(), sectionElement.title().font()));
            } else {
                this.add(sectionElement.title());
            }
            out.write(92);
            out.write(paragraph);
        }
        sectionElement.process(this);
        if (sectionElement.type() == 16) {
            // empty if block
        }
        if (sectionElement.type() == 13) {
            out.write(92);
            out.write(paragraph);
        }
    }

    private void writeSectionDefaults(ByteArrayOutputStream out) throws IOException {
        if (this.header instanceof RtfHeaderFooters || this.footer instanceof RtfHeaderFooters) {
            RtfHeaderFooters rtfHeader = (RtfHeaderFooters)this.header;
            RtfHeaderFooters rtfFooter = (RtfHeaderFooters)this.footer;
            if (rtfHeader != null && (rtfHeader.get(1) != null || rtfHeader.get(2) != null) || rtfFooter != null && (rtfFooter.get(1) != null || rtfFooter.get(2) != null)) {
                out.write(92);
                out.write(facingPages);
            }
        }
        if (this.hasTitlePage) {
            out.write(92);
            out.write(titlePage);
        }
        this.writeHeadersFooters(out);
        if (this.landscape) {
            out.write(92);
            out.write(landscapeTag2);
            out.write(92);
            out.write(sectionPageWidth);
            RtfWriter.writeInt(out, this.pageWidth);
            out.write(92);
            out.write(sectionPageHeight);
            RtfWriter.writeInt(out, this.pageHeight);
        } else {
            out.write(92);
            out.write(sectionPageWidth);
            RtfWriter.writeInt(out, this.pageWidth);
            out.write(92);
            out.write(sectionPageHeight);
            RtfWriter.writeInt(out, this.pageHeight);
        }
    }

    public boolean writeTOC(String tocTitle, Font titleFont, boolean showTOCasEntry, Font showTOCEntryFont) {
        try {
            RtfTOC toc = new RtfTOC(tocTitle, titleFont);
            if (showTOCasEntry) {
                toc.addTOCAsTOCEntry(tocTitle, showTOCEntryFont);
            }
            this.add(new Paragraph(toc));
        }
        catch (DocumentException de) {
            return false;
        }
        return true;
    }

    private void writeTable(Table table, ByteArrayOutputStream out) throws IOException, DocumentException {
        this.inTable = true;
        table.complete();
        RtfTable rtfTable = new RtfTable(this);
        rtfTable.importTable(table, this.pageWidth - this.marginLeft - this.marginRight);
        rtfTable.writeTable(out);
        this.inTable = false;
    }

    public boolean writingHeaderFooter() {
        return this.inHeaderFooter;
    }
}

