/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.direct;

import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.style.RtfColor;
import com.lowagie2.text.rtf.style.RtfFont;
import java.awt.Color;
import java.util.HashMap;

public class RtfImportHeader {
    private HashMap importColorMapping = null;
    private HashMap importFontMapping = null;
    private RtfDocument rtfDoc = null;

    public RtfImportHeader(RtfDocument rtfDoc) {
        this.rtfDoc = rtfDoc;
        this.importFontMapping = new HashMap();
        this.importColorMapping = new HashMap();
    }

    public void importColor(String colorNr, Color color) {
        RtfColor rtfColor = new RtfColor(this.rtfDoc, color);
        this.importColorMapping.put(colorNr, Integer.toString(rtfColor.getColorNumber()));
    }

    public void importFont(String fontNr, String fontName) {
        RtfFont rtfFont = new RtfFont(fontName);
        rtfFont.setRtfDocument(this.rtfDoc);
        this.importFontMapping.put(fontNr, Integer.toString(this.rtfDoc.getDocumentHeader().getFontNumber(rtfFont)));
    }

    public String mapColorNr(String colorNr) {
        if (this.importColorMapping.containsKey(colorNr)) {
            return (String)this.importColorMapping.get(colorNr);
        }
        return "0";
    }

    public String mapFontNr(String fontNr) {
        if (this.importFontMapping.containsKey(fontNr)) {
            return (String)this.importFontMapping.get(fontNr);
        }
        return "0";
    }
}

