/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.graphic;

import com.lowagie2.text.rtf.RtfAddableElement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfShapePosition
extends RtfAddableElement {
    public static final int POSITION_X_RELATIVE_COLUMN = 2;
    public static final int POSITION_X_RELATIVE_MARGIN = 1;
    public static final int POSITION_X_RELATIVE_PAGE = 0;
    public static final int POSITION_Y_RELATIVE_MARGIN = 1;
    public static final int POSITION_Y_RELATIVE_PAGE = 0;
    public static final int POSITION_Y_RELATIVE_PARAGRAPH = 2;
    private int bottom = 0;
    private boolean ignoreXRelative = false;
    private boolean ignoreYRelative = false;
    private int left = 0;
    private int right = 0;
    private boolean shapeBelowText = false;
    private int top = 0;
    private int xRelativePos = 0;
    private int yRelativePos = 0;
    private int zOrder = 0;

    public RtfShapePosition(int top, int left, int right, int bottom) {
        this.top = top;
        this.left = left;
        this.right = right;
        this.bottom = bottom;
    }

    public boolean isShapeBelowText() {
        return this.shapeBelowText;
    }

    protected void setIgnoreXRelative(boolean ignoreXRelative) {
        this.ignoreXRelative = ignoreXRelative;
    }

    protected void setIgnoreYRelative(boolean ignoreYRelative) {
        this.ignoreYRelative = ignoreYRelative;
    }

    public void setShapeBelowText(boolean shapeBelowText) {
        this.shapeBelowText = shapeBelowText;
    }

    public void setXRelativePos(int relativePos) {
        this.xRelativePos = relativePos;
    }

    public void setYRelativePos(int relativePos) {
        this.yRelativePos = relativePos;
    }

    public void setZOrder(int order) {
        this.zOrder = order;
    }

    public byte[] write() {
        ByteArrayOutputStream result;
        block15: {
            result = new ByteArrayOutputStream();
            try {
                result.write("\\shpleft".getBytes());
                result.write(this.intToByteArray(this.left));
                result.write("\\shptop".getBytes());
                result.write(this.intToByteArray(this.top));
                result.write("\\shpright".getBytes());
                result.write(this.intToByteArray(this.right));
                result.write("\\shpbottom".getBytes());
                result.write(this.intToByteArray(this.bottom));
                result.write("\\shpz".getBytes());
                result.write(this.intToByteArray(this.zOrder));
                switch (this.xRelativePos) {
                    case 0: {
                        result.write("\\shpbxpage".getBytes());
                        break;
                    }
                    case 1: {
                        result.write("\\shpbxmargin".getBytes());
                        break;
                    }
                    case 2: {
                        result.write("\\shpbxcolumn".getBytes());
                    }
                }
                if (this.ignoreXRelative) {
                    result.write("\\shpbxignore".getBytes());
                }
                switch (this.yRelativePos) {
                    case 0: {
                        result.write("\\shpbypage".getBytes());
                        break;
                    }
                    case 1: {
                        result.write("\\shpbymargin".getBytes());
                        break;
                    }
                    case 2: {
                        result.write("\\shpbypara".getBytes());
                    }
                }
                if (this.ignoreYRelative) {
                    result.write("\\shpbyignore".getBytes());
                }
                if (this.shapeBelowText) {
                    result.write("\\shpfblwtxt1".getBytes());
                    break block15;
                }
                result.write("\\shpfblwtxt0".getBytes());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return result.toByteArray();
    }
}

