/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.headerfooter;

import com.lowagie2.text.HeaderFooter;
import com.lowagie2.text.Phrase;
import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.headerfooter.RtfHeaderFooter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfHeaderFooterGroup
extends HeaderFooter
implements RtfBasicElement {
    private static final int MODE_MULTIPLE = 2;
    private static final int MODE_NONE = 0;
    private static final int MODE_SINGLE = 1;
    private RtfDocument document = null;
    private RtfHeaderFooter headerAll = null;
    private RtfHeaderFooter headerFirst = null;
    private RtfHeaderFooter headerLeft = null;
    private RtfHeaderFooter headerRight = null;
    private int mode = 0;
    private int type = 1;

    public RtfHeaderFooterGroup(RtfDocument doc, HeaderFooter headerFooter, int type) {
        super(new Phrase(""), false);
        this.document = doc;
        this.type = type;
        this.mode = 1;
        this.headerAll = new RtfHeaderFooter(doc, headerFooter, type, 1);
        this.headerAll.setType(this.type);
    }

    public RtfHeaderFooterGroup(RtfDocument doc, RtfHeaderFooter headerFooter, int type) {
        super(new Phrase(""), false);
        this.document = doc;
        this.type = type;
        this.mode = 1;
        this.headerAll = new RtfHeaderFooter(doc, headerFooter, 1);
        this.headerAll.setType(this.type);
    }

    public RtfHeaderFooterGroup(RtfDocument doc, RtfHeaderFooterGroup headerFooter, int type) {
        super(new Phrase(""), false);
        this.document = doc;
        this.mode = headerFooter.getMode();
        this.type = type;
        if (headerFooter.getHeaderAll() != null) {
            this.headerAll = new RtfHeaderFooter(this.document, headerFooter.getHeaderAll(), 1);
        }
        if (headerFooter.getHeaderFirst() != null) {
            this.headerFirst = new RtfHeaderFooter(this.document, headerFooter.getHeaderFirst(), 0);
        }
        if (headerFooter.getHeaderLeft() != null) {
            this.headerLeft = new RtfHeaderFooter(this.document, headerFooter.getHeaderLeft(), 2);
        }
        if (headerFooter.getHeaderRight() != null) {
            this.headerRight = new RtfHeaderFooter(this.document, headerFooter.getHeaderRight(), 4);
        }
        this.setType(this.type);
    }

    public RtfHeaderFooterGroup(RtfDocument doc, int type) {
        super(new Phrase(""), false);
        this.document = doc;
        this.type = type;
    }

    public RtfHeaderFooterGroup() {
        super(new Phrase(""), false);
        this.mode = 0;
    }

    protected RtfHeaderFooter getHeaderAll() {
        return this.headerAll;
    }

    protected RtfHeaderFooter getHeaderFirst() {
        return this.headerFirst;
    }

    protected RtfHeaderFooter getHeaderLeft() {
        return this.headerLeft;
    }

    protected RtfHeaderFooter getHeaderRight() {
        return this.headerRight;
    }

    protected int getMode() {
        return this.mode;
    }

    public boolean hasFacingPages() {
        return this.headerLeft != null || this.headerRight != null;
    }

    public boolean hasTitlePage() {
        return this.headerFirst != null;
    }

    public void setHasFacingPages() {
        if (this.mode == 1) {
            this.mode = 2;
            this.headerLeft = new RtfHeaderFooter(this.document, this.headerAll, 2);
            this.headerLeft.setType(this.type);
            this.headerRight = new RtfHeaderFooter(this.document, this.headerAll, 4);
            this.headerRight.setType(this.type);
            this.headerAll = null;
        } else if (this.mode == 2) {
            if (this.headerLeft == null && this.headerAll != null) {
                this.headerLeft = new RtfHeaderFooter(this.document, this.headerAll, 2);
                this.headerLeft.setType(this.type);
            }
            if (this.headerRight == null && this.headerAll != null) {
                this.headerRight = new RtfHeaderFooter(this.document, this.headerAll, 4);
                this.headerRight.setType(this.type);
            }
            this.headerAll = null;
        }
    }

    public void setHasTitlePage() {
        if (this.mode == 1) {
            this.mode = 2;
            this.headerFirst = new RtfHeaderFooter(this.document, this.headerAll, 0);
            this.headerFirst.setType(this.type);
        }
    }

    public void setHeaderFooter(HeaderFooter headerFooter, int displayAt) {
        this.mode = 2;
        switch (displayAt) {
            case 1: {
                this.headerAll = new RtfHeaderFooter(this.document, headerFooter, this.type, displayAt);
                break;
            }
            case 0: {
                this.headerFirst = new RtfHeaderFooter(this.document, headerFooter, this.type, displayAt);
                break;
            }
            case 2: {
                this.headerLeft = new RtfHeaderFooter(this.document, headerFooter, this.type, displayAt);
                break;
            }
            case 4: {
                this.headerRight = new RtfHeaderFooter(this.document, headerFooter, this.type, displayAt);
            }
        }
    }

    public void setHeaderFooter(RtfHeaderFooter headerFooter, int displayAt) {
        this.mode = 2;
        headerFooter.setRtfDocument(this.document);
        headerFooter.setType(this.type);
        headerFooter.setDisplayAt(displayAt);
        switch (displayAt) {
            case 1: {
                this.headerAll = headerFooter;
                break;
            }
            case 0: {
                this.headerFirst = headerFooter;
                break;
            }
            case 2: {
                this.headerLeft = headerFooter;
                break;
            }
            case 4: {
                this.headerRight = headerFooter;
            }
        }
    }

    public void setInHeader(boolean inHeader) {
    }

    public void setInTable(boolean inTable) {
    }

    public void setRtfDocument(RtfDocument doc) {
        this.document = doc;
        if (this.headerAll != null) {
            this.headerAll.setRtfDocument(this.document);
        }
        if (this.headerFirst != null) {
            this.headerFirst.setRtfDocument(this.document);
        }
        if (this.headerLeft != null) {
            this.headerLeft.setRtfDocument(this.document);
        }
        if (this.headerRight != null) {
            this.headerRight.setRtfDocument(this.document);
        }
    }

    public void setType(int type) {
        this.type = type;
        if (this.headerAll != null) {
            this.headerAll.setType(this.type);
        }
        if (this.headerFirst != null) {
            this.headerFirst.setType(this.type);
        }
        if (this.headerLeft != null) {
            this.headerLeft.setType(this.type);
        }
        if (this.headerRight != null) {
            this.headerRight.setType(this.type);
        }
    }

    public byte[] write() {
        ByteArrayOutputStream result;
        block7: {
            result = new ByteArrayOutputStream();
            try {
                if (this.mode == 1) {
                    result.write(this.headerAll.write());
                    break block7;
                }
                if (this.mode != 2) break block7;
                if (this.headerFirst != null) {
                    result.write(this.headerFirst.write());
                }
                if (this.headerLeft != null) {
                    result.write(this.headerLeft.write());
                }
                if (this.headerRight != null) {
                    result.write(this.headerRight.write());
                }
                if (this.headerAll != null) {
                    result.write(this.headerAll.write());
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return result.toByteArray();
    }
}

