/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.style;

import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.RtfElement;
import com.lowagie2.text.rtf.RtfExtendedElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.style.RtfFont;
import com.lowagie2.text.rtf.style.RtfParagraphStyle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfFontList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] DEFAULT_FONT = "\\deff".getBytes();
    public static final byte[] FONT_NUMBER;
    private static final byte[] FONT_TABLE;
    private ArrayList fontList = new ArrayList();

    static {
        FONT_TABLE = "\\fonttbl".getBytes();
        FONT_NUMBER = "\\f".getBytes();
    }

    public RtfFontList(RtfDocument doc) {
        super(doc);
        this.fontList.add(new RtfFont(this.document, 0));
    }

    public int getFontNumber(RtfFont font) {
        if (font instanceof RtfParagraphStyle) {
            font = new RtfFont(this.document, (RtfParagraphStyle)font);
        }
        int fontIndex = -1;
        int i = 0;
        while (i < this.fontList.size()) {
            if (this.fontList.get(i).equals(font)) {
                fontIndex = i;
            }
            ++i;
        }
        if (fontIndex == -1) {
            fontIndex = this.fontList.size();
            this.fontList.add(font);
        }
        return fontIndex;
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(DEFAULT_FONT);
            result.write(this.intToByteArray(0));
            result.write(RtfBasicElement.OPEN_GROUP);
            result.write(FONT_TABLE);
            int i = 0;
            while (i < this.fontList.size()) {
                result.write(RtfBasicElement.OPEN_GROUP);
                result.write(FONT_NUMBER);
                result.write(this.intToByteArray(i));
                result.write(((RtfFont)this.fontList.get(i)).writeDefinition());
                result.write(RtfBasicElement.COMMA_DELIMITER);
                result.write(RtfBasicElement.CLOSE_GROUP);
                ++i;
            }
            result.write(RtfBasicElement.CLOSE_GROUP);
            result.write(10);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

