/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.style;

import com.lowagie2.text.Font;
import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.style.RtfFont;
import com.lowagie2.text.rtf.text.RtfParagraph;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfParagraphStyle
extends RtfFont {
    public static final byte[] ALIGN_CENTER;
    public static final byte[] ALIGN_JUSTIFY;
    public static final byte[] ALIGN_LEFT;
    public static final byte[] ALIGN_RIGHT;
    public static final byte[] INDENT_LEFT;
    public static final byte[] INDENT_RIGHT;
    public static final byte[] KEEP_TOGETHER;
    public static final byte[] KEEP_TOGETHER_WITH_NEXT;
    private static final int MODIFIED_ALIGNMENT = 1;
    private static final int MODIFIED_FONT_COLOR = 256;
    private static final int MODIFIED_FONT_NAME = 32;
    private static final int MODIFIED_FONT_SIZE = 64;
    private static final int MODIFIED_FONT_STYLE = 128;
    private static final int MODIFIED_INDENT_LEFT = 2;
    private static final int MODIFIED_INDENT_RIGHT = 4;
    private static final int MODIFIED_KEEP_TOGETHER = 1024;
    private static final int MODIFIED_KEEP_TOGETHER_WITH_NEXT = 2048;
    private static final int MODIFIED_LINE_LEADING = 512;
    private static final int MODIFIED_NONE = 0;
    private static final int MODIFIED_SPACING_AFTER = 16;
    private static final int MODIFIED_SPACING_BEFORE = 8;
    public static final byte[] SPACING_AFTER;
    public static final byte[] SPACING_BEFORE;
    public static final RtfParagraphStyle STYLE_HEADING_1;
    public static final RtfParagraphStyle STYLE_HEADING_2;
    public static final RtfParagraphStyle STYLE_HEADING_3;
    public static final RtfParagraphStyle STYLE_NORMAL;
    private int alignment = 0;
    private RtfParagraphStyle baseStyle = null;
    private String basedOnName = null;
    private int indentLeft = 0;
    private int indentRight = 0;
    private boolean keepTogether = false;
    private boolean keepTogetherWithNext = false;
    private int lineLeading = 0;
    private int modified = 0;
    private int spacingAfter = 0;
    private int spacingBefore = 0;
    private String styleName = "";
    private int styleNumber = -1;

    static {
        ALIGN_LEFT = "\\ql".getBytes();
        ALIGN_RIGHT = "\\qr".getBytes();
        ALIGN_CENTER = "\\qc".getBytes();
        ALIGN_JUSTIFY = "\\qj".getBytes();
        INDENT_LEFT = "\\li".getBytes();
        INDENT_RIGHT = "\\ri".getBytes();
        KEEP_TOGETHER = "\\keep".getBytes();
        KEEP_TOGETHER_WITH_NEXT = "\\keepn".getBytes();
        SPACING_AFTER = "\\sa".getBytes();
        SPACING_BEFORE = "\\sb".getBytes();
        STYLE_NORMAL = new RtfParagraphStyle("Normal", "Arial", 12, 0, Color.black);
        STYLE_HEADING_1 = new RtfParagraphStyle("heading 1", "Normal");
        STYLE_HEADING_2 = new RtfParagraphStyle("heading 2", "Normal");
        STYLE_HEADING_3 = new RtfParagraphStyle("heading 3", "Normal");
        STYLE_HEADING_1.setSize(16.0f);
        STYLE_HEADING_1.setStyle(1);
        STYLE_HEADING_2.setSize(14.0f);
        STYLE_HEADING_2.setStyle(3);
        STYLE_HEADING_3.setSize(13.0f);
        STYLE_HEADING_3.setStyle(1);
    }

    public RtfParagraphStyle(RtfDocument doc, RtfParagraphStyle style) {
        super(doc, style);
        this.document = doc;
        this.styleName = style.getStyleName();
        this.alignment = style.getAlignment();
        this.indentLeft = (int)((double)style.getIndentLeft() * 20.0);
        this.indentRight = (int)((double)style.getIndentRight() * 20.0);
        this.spacingBefore = (int)((double)style.getSpacingBefore() * 20.0);
        this.spacingAfter = (int)((double)style.getSpacingAfter() * 20.0);
        this.lineLeading = (int)((double)style.getLineLeading() * 20.0);
        this.keepTogether = style.getKeepTogether();
        this.keepTogetherWithNext = style.getKeepTogetherWithNext();
        this.basedOnName = style.basedOnName;
        this.modified = style.modified;
        this.styleNumber = style.getStyleNumber();
        if (this.document != null) {
            this.setRtfDocument(this.document);
        }
    }

    public RtfParagraphStyle(String styleName, String basedOnName) {
        super(null, new Font());
        this.styleName = styleName;
        this.basedOnName = basedOnName;
    }

    public RtfParagraphStyle(String styleName, String fontName, int fontSize, int fontStyle, Color fontColor) {
        super(null, new RtfFont(fontName, (float)fontSize, fontStyle, fontColor));
        this.styleName = styleName;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RtfParagraphStyle)) {
            return false;
        }
        RtfParagraphStyle paragraphStyle = (RtfParagraphStyle)o;
        boolean result = this.getStyleName().equals(paragraphStyle.getStyleName());
        return result;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public String getBasedOnName() {
        return this.basedOnName;
    }

    public int getIndentLeft() {
        return this.indentLeft;
    }

    public int getIndentRight() {
        return this.indentRight;
    }

    public boolean getKeepTogether() {
        return this.keepTogether;
    }

    public boolean getKeepTogetherWithNext() {
        return this.keepTogetherWithNext;
    }

    public int getLineLeading() {
        return this.lineLeading;
    }

    public int getSpacingAfter() {
        return this.spacingAfter;
    }

    public int getSpacingBefore() {
        return this.spacingBefore;
    }

    public String getStyleName() {
        return this.styleName;
    }

    private int getStyleNumber() {
        return this.styleNumber;
    }

    public void handleInheritance() {
        if (this.basedOnName != null && this.document.getDocumentHeader().getRtfParagraphStyle(this.basedOnName) != null) {
            this.baseStyle = this.document.getDocumentHeader().getRtfParagraphStyle(this.basedOnName);
            this.baseStyle.handleInheritance();
            if ((this.modified & 1) != 1) {
                this.alignment = this.baseStyle.getAlignment();
            }
            if ((this.modified & 2) != 2) {
                this.indentLeft = this.baseStyle.getIndentLeft();
            }
            if ((this.modified & 4) != 4) {
                this.indentRight = this.baseStyle.getIndentRight();
            }
            if ((this.modified & 8) != 8) {
                this.spacingBefore = this.baseStyle.getSpacingBefore();
            }
            if ((this.modified & 0x10) != 16) {
                this.spacingAfter = this.baseStyle.getSpacingAfter();
            }
            if ((this.modified & 0x20) != 32) {
                this.setFontName(this.baseStyle.getFontName());
            }
            if ((this.modified & 0x40) != 64) {
                this.setSize(this.baseStyle.getFontSize());
            }
            if ((this.modified & 0x80) != 128) {
                this.setStyle(this.baseStyle.getFontStyle());
            }
            if ((this.modified & 0x100) != 256) {
                this.setColor(this.baseStyle.color());
            }
            if ((this.modified & 0x200) != 512) {
                this.setLineLeading(this.baseStyle.getLineLeading());
            }
            if ((this.modified & 0x400) != 1024) {
                this.setKeepTogether(this.baseStyle.getKeepTogether());
            }
            if ((this.modified & 0x800) != 2048) {
                this.setKeepTogetherWithNext(this.baseStyle.getKeepTogetherWithNext());
            }
        }
    }

    public int hashCode() {
        return this.styleName.hashCode();
    }

    public void setAlignment(int alignment) {
        this.modified |= 1;
        this.alignment = alignment;
    }

    public void setColor(Color color) {
        this.modified |= 0x100;
        super.setColor(color);
    }

    public void setFontName(String fontName) {
        this.modified |= 0x20;
        super.setFontName(fontName);
    }

    public void setIndentLeft(int indentLeft) {
        this.modified |= 2;
        this.indentLeft = indentLeft;
    }

    public void setIndentRight(int indentRight) {
        this.modified |= 4;
        this.indentRight = indentRight;
    }

    public void setKeepTogether(boolean keepTogether) {
        this.keepTogether = keepTogether;
        this.modified |= 0x400;
    }

    public void setKeepTogetherWithNext(boolean keepTogetherWithNext) {
        this.keepTogetherWithNext = keepTogetherWithNext;
        this.modified |= 0x800;
    }

    public void setLineLeading(int lineLeading) {
        this.lineLeading = lineLeading;
        this.modified |= 0x200;
    }

    public void setSize(float fontSize) {
        this.modified |= 0x40;
        super.setSize(fontSize);
    }

    public void setSpacingAfter(int spacingAfter) {
        this.modified |= 0x10;
        this.spacingAfter = spacingAfter;
    }

    public void setSpacingBefore(int spacingBefore) {
        this.modified |= 8;
        this.spacingBefore = spacingBefore;
    }

    public void setStyle(int fontStyle) {
        this.modified |= 0x80;
        super.setStyle(fontStyle);
    }

    protected void setStyleNumber(int styleNumber) {
        this.styleNumber = styleNumber;
    }

    public byte[] write() {
        return new byte[0];
    }

    public byte[] writeBegin() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write("\\s".getBytes());
            result.write(this.intToByteArray(this.styleNumber));
            result.write(this.writeParagraphSettings());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write("{".getBytes());
            result.write("\\style".getBytes());
            result.write("\\s".getBytes());
            result.write(this.intToByteArray(this.styleNumber));
            result.write(RtfBasicElement.DELIMITER);
            result.write(this.writeParagraphSettings());
            result.write(super.writeBegin());
            result.write(RtfBasicElement.DELIMITER);
            result.write(this.styleName.getBytes());
            result.write(";".getBytes());
            result.write("}".getBytes());
            if (this.document.getDocumentSettings().isOutputDebugLineBreaks()) {
                result.write(10);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeEnd() {
        return new byte[0];
    }

    private byte[] writeParagraphSettings() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (this.keepTogether) {
                result.write(KEEP_TOGETHER);
            }
            if (this.keepTogetherWithNext) {
                result.write(KEEP_TOGETHER_WITH_NEXT);
            }
            switch (this.alignment) {
                case 0: {
                    result.write(ALIGN_LEFT);
                    break;
                }
                case 2: {
                    result.write(ALIGN_RIGHT);
                    break;
                }
                case 1: {
                    result.write(ALIGN_CENTER);
                    break;
                }
                case 3: 
                case 8: {
                    result.write(ALIGN_JUSTIFY);
                }
            }
            result.write(INDENT_LEFT);
            result.write(this.intToByteArray(this.indentLeft));
            result.write(INDENT_RIGHT);
            result.write(this.intToByteArray(this.indentRight));
            if (this.spacingBefore > 0) {
                result.write(SPACING_BEFORE);
                result.write(this.intToByteArray(this.spacingBefore));
            }
            if (this.spacingAfter > 0) {
                result.write(SPACING_AFTER);
                result.write(this.intToByteArray(this.spacingAfter));
            }
            if (this.lineLeading > 0) {
                result.write(RtfParagraph.LINE_SPACING);
                result.write(this.intToByteArray(this.lineLeading));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

