/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.table;

import com.lowagie2.text.rtf.RtfElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.style.RtfColor;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfBorder
extends RtfElement {
    protected static final byte[] BORDER_COLOR_NUMBER;
    public static final int BORDER_DASHED = 5;
    public static final int BORDER_DOTTED = 4;
    public static final int BORDER_DOT_DASH = 8;
    public static final int BORDER_DOT_DOT_DASH = 9;
    public static final int BORDER_DOUBLE = 7;
    public static final int BORDER_DOUBLE_THICK = 2;
    public static final int BORDER_DOUBLE_WAVY = 21;
    public static final int BORDER_EMBOSS = 23;
    public static final int BORDER_ENGRAVE = 24;
    public static final int BORDER_HAIRLINE = 6;
    public static final int BORDER_NONE = 0;
    public static final int BORDER_SHADOWED = 3;
    public static final int BORDER_SINGLE = 1;
    public static final int BORDER_STRIPED = 22;
    protected static final byte[] BORDER_STYLE_DASHED;
    protected static final byte[] BORDER_STYLE_DOTTED;
    protected static final byte[] BORDER_STYLE_DOT_DASH;
    protected static final byte[] BORDER_STYLE_DOT_DOT_DASH;
    protected static final byte[] BORDER_STYLE_DOUBLE;
    protected static final byte[] BORDER_STYLE_DOUBLE_THICK;
    protected static final byte[] BORDER_STYLE_DOUBLE_WAVY;
    protected static final byte[] BORDER_STYLE_EMBOSS;
    protected static final byte[] BORDER_STYLE_ENGRAVE;
    protected static final byte[] BORDER_STYLE_HAIRLINE;
    protected static final byte[] BORDER_STYLE_SHADOWED;
    protected static final byte[] BORDER_STYLE_SINGLE;
    protected static final byte[] BORDER_STYLE_STRIPED;
    protected static final byte[] BORDER_STYLE_THICK_THIN;
    protected static final byte[] BORDER_STYLE_THICK_THIN_LARGE;
    protected static final byte[] BORDER_STYLE_THICK_THIN_MED;
    protected static final byte[] BORDER_STYLE_THIN_THICK;
    protected static final byte[] BORDER_STYLE_THIN_THICK_LARGE;
    protected static final byte[] BORDER_STYLE_THIN_THICK_MED;
    protected static final byte[] BORDER_STYLE_THIN_THICK_THIN;
    protected static final byte[] BORDER_STYLE_THIN_THICK_THIN_LARGE;
    protected static final byte[] BORDER_STYLE_THIN_THICK_THIN_MED;
    protected static final byte[] BORDER_STYLE_TRIPLE;
    protected static final byte[] BORDER_STYLE_WAVY;
    public static final int BORDER_THICK_THIN = 11;
    public static final int BORDER_THICK_THIN_LARGE = 17;
    public static final int BORDER_THICK_THIN_MED = 14;
    public static final int BORDER_THIN_THICK = 12;
    public static final int BORDER_THIN_THICK_LARGE = 18;
    public static final int BORDER_THIN_THICK_MED = 15;
    public static final int BORDER_THIN_THICK_THIN = 13;
    public static final int BORDER_THIN_THICK_THIN_LARGE = 19;
    public static final int BORDER_THIN_THICK_THIN_MED = 16;
    public static final int BORDER_TRIPLE = 10;
    public static final int BORDER_WAVY = 20;
    protected static final byte[] BORDER_WIDTH;
    protected static final int BOTTOM_BORDER = 8;
    protected static final int BOX_BORDER = 15;
    protected static final int CELL_BORDER = 2;
    protected static final byte[] CELL_BORDER_BOTTOM;
    protected static final byte[] CELL_BORDER_LEFT;
    protected static final byte[] CELL_BORDER_RIGHT;
    protected static final byte[] CELL_BORDER_TOP;
    protected static final int HORIZONTAL_BORDER = 32;
    protected static final int LEFT_BORDER = 1;
    protected static final int NO_BORDER = 0;
    protected static final int RIGHT_BORDER = 4;
    protected static final int ROW_BORDER = 1;
    protected static final byte[] ROW_BORDER_BOTTOM;
    protected static final byte[] ROW_BORDER_HORIZONTAL;
    protected static final byte[] ROW_BORDER_LEFT;
    protected static final byte[] ROW_BORDER_RIGHT;
    protected static final byte[] ROW_BORDER_TOP;
    protected static final byte[] ROW_BORDER_VERTICAL;
    protected static final int TOP_BORDER = 2;
    protected static final int VERTICAL_BORDER = 16;
    private RtfColor borderColor = null;
    private int borderPosition = 0;
    private int borderStyle = 0;
    private int borderType = 1;
    private int borderWidth = 20;

    static {
        ROW_BORDER_LEFT = "\\trbrdrl".getBytes();
        ROW_BORDER_TOP = "\\trbrdrt".getBytes();
        ROW_BORDER_RIGHT = "\\trbrdrr".getBytes();
        ROW_BORDER_BOTTOM = "\\trbrdrb".getBytes();
        ROW_BORDER_HORIZONTAL = "\\trbrdrh".getBytes();
        ROW_BORDER_VERTICAL = "\\trbrdrv".getBytes();
        CELL_BORDER_LEFT = "\\clbrdrl".getBytes();
        CELL_BORDER_TOP = "\\clbrdrt".getBytes();
        CELL_BORDER_RIGHT = "\\clbrdrr".getBytes();
        CELL_BORDER_BOTTOM = "\\clbrdrb".getBytes();
        BORDER_WIDTH = "\\brdrw".getBytes();
        BORDER_COLOR_NUMBER = "\\brdrcf".getBytes();
        BORDER_STYLE_SINGLE = "\\brdrs".getBytes();
        BORDER_STYLE_DOUBLE_THICK = "\\brdrth".getBytes();
        BORDER_STYLE_SHADOWED = "\\brdrsh".getBytes();
        BORDER_STYLE_DOTTED = "\\brdrdot".getBytes();
        BORDER_STYLE_DASHED = "\\brdrdash".getBytes();
        BORDER_STYLE_HAIRLINE = "\\brdrhair".getBytes();
        BORDER_STYLE_DOUBLE = "\\brdrdb".getBytes();
        BORDER_STYLE_DOT_DASH = "\\brdrdashd".getBytes();
        BORDER_STYLE_DOT_DOT_DASH = "\\brdrdashdd".getBytes();
        BORDER_STYLE_TRIPLE = "\\brdrtriple".getBytes();
        BORDER_STYLE_THICK_THIN = "\\brdrtnthsg".getBytes();
        BORDER_STYLE_THIN_THICK = "\\brdrthtnsg".getBytes();
        BORDER_STYLE_THIN_THICK_THIN = "\\brdrtnthtnsg".getBytes();
        BORDER_STYLE_THICK_THIN_MED = "\\brdrtnthmg".getBytes();
        BORDER_STYLE_THIN_THICK_MED = "\\brdrthtnmg".getBytes();
        BORDER_STYLE_THIN_THICK_THIN_MED = "\\brdrtnthtnmg".getBytes();
        BORDER_STYLE_THICK_THIN_LARGE = "\\brdrtnthlg".getBytes();
        BORDER_STYLE_THIN_THICK_LARGE = "\\brdrthtnlg".getBytes();
        BORDER_STYLE_THIN_THICK_THIN_LARGE = "\\brdrtnthtnlg".getBytes();
        BORDER_STYLE_WAVY = "\\brdrwavy".getBytes();
        BORDER_STYLE_DOUBLE_WAVY = "\\brdrwavydb".getBytes();
        BORDER_STYLE_STRIPED = "\\brdrdashdotstr".getBytes();
        BORDER_STYLE_EMBOSS = "\\brdremboss".getBytes();
        BORDER_STYLE_ENGRAVE = "\\brdrengrave".getBytes();
    }

    protected RtfBorder(RtfDocument doc, int borderType, int borderPosition, int borderStyle, float borderWidth, Color borderColor) {
        super(doc);
        this.borderType = borderType;
        this.borderPosition = borderPosition;
        this.borderStyle = borderStyle;
        if (borderWidth > 2.0f) {
            borderWidth = 2.0f;
        }
        this.borderWidth = (int)((double)borderWidth * 20.0);
        if (this.borderWidth == 0) {
            this.borderStyle = 0;
        }
        this.borderColor = borderColor == null ? new RtfColor(this.document, new Color(0, 0, 0)) : new RtfColor(this.document, borderColor);
    }

    protected RtfBorder(RtfDocument doc, int borderType, RtfBorder border) {
        super(doc);
        this.borderType = borderType;
        this.borderPosition = border.getBorderPosition();
        this.borderStyle = border.getBorderStyle();
        this.borderWidth = border.getBorderWidth();
        this.borderColor = new RtfColor(this.document, border.getBorderColor());
    }

    protected RtfColor getBorderColor() {
        return this.borderColor;
    }

    protected int getBorderPosition() {
        return this.borderPosition;
    }

    protected int getBorderStyle() {
        return this.borderStyle;
    }

    protected int getBorderType() {
        return this.borderType;
    }

    protected int getBorderWidth() {
        return this.borderWidth;
    }

    public byte[] write() {
        if (this.borderStyle == 0 || this.borderPosition == 0 || this.borderWidth == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (this.borderType == 1) {
                switch (this.borderPosition) {
                    case 1: {
                        result.write(ROW_BORDER_LEFT);
                        break;
                    }
                    case 2: {
                        result.write(ROW_BORDER_TOP);
                        break;
                    }
                    case 4: {
                        result.write(ROW_BORDER_RIGHT);
                        break;
                    }
                    case 8: {
                        result.write(ROW_BORDER_BOTTOM);
                        break;
                    }
                    case 32: {
                        result.write(ROW_BORDER_HORIZONTAL);
                        break;
                    }
                    case 16: {
                        result.write(ROW_BORDER_VERTICAL);
                        break;
                    }
                    default: {
                        return new byte[0];
                    }
                }
                result.write(this.writeBorderStyle());
                result.write(BORDER_WIDTH);
                result.write(this.intToByteArray(this.borderWidth));
                result.write(BORDER_COLOR_NUMBER);
                result.write(this.intToByteArray(this.borderColor.getColorNumber()));
                result.write(10);
            } else if (this.borderType == 2) {
                switch (this.borderPosition) {
                    case 1: {
                        result.write(CELL_BORDER_LEFT);
                        break;
                    }
                    case 2: {
                        result.write(CELL_BORDER_TOP);
                        break;
                    }
                    case 4: {
                        result.write(CELL_BORDER_RIGHT);
                        break;
                    }
                    case 8: {
                        result.write(CELL_BORDER_BOTTOM);
                        break;
                    }
                    default: {
                        return new byte[0];
                    }
                }
                result.write(this.writeBorderStyle());
                result.write(BORDER_WIDTH);
                result.write(this.intToByteArray(this.borderWidth));
                result.write(BORDER_COLOR_NUMBER);
                result.write(this.intToByteArray(this.borderColor.getColorNumber()));
                result.write(10);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    private byte[] writeBorderStyle() {
        switch (this.borderStyle) {
            case 0: {
                return new byte[0];
            }
            case 1: {
                return BORDER_STYLE_SINGLE;
            }
            case 2: {
                return BORDER_STYLE_DOUBLE_THICK;
            }
            case 3: {
                return BORDER_STYLE_SHADOWED;
            }
            case 4: {
                return BORDER_STYLE_DOTTED;
            }
            case 5: {
                return BORDER_STYLE_DASHED;
            }
            case 6: {
                return BORDER_STYLE_HAIRLINE;
            }
            case 7: {
                return BORDER_STYLE_DOUBLE;
            }
            case 8: {
                return BORDER_STYLE_DOT_DASH;
            }
            case 9: {
                return BORDER_STYLE_DOT_DOT_DASH;
            }
            case 10: {
                return BORDER_STYLE_TRIPLE;
            }
            case 11: {
                return BORDER_STYLE_THICK_THIN;
            }
            case 12: {
                return BORDER_STYLE_THIN_THICK;
            }
            case 13: {
                return BORDER_STYLE_THIN_THICK_THIN;
            }
            case 14: {
                return BORDER_STYLE_THICK_THIN_MED;
            }
            case 15: {
                return BORDER_STYLE_THIN_THICK_MED;
            }
            case 16: {
                return BORDER_STYLE_THIN_THICK_THIN_MED;
            }
            case 17: {
                return BORDER_STYLE_THICK_THIN_LARGE;
            }
            case 18: {
                return BORDER_STYLE_THIN_THICK_LARGE;
            }
            case 19: {
                return BORDER_STYLE_THIN_THICK_THIN_LARGE;
            }
            case 20: {
                return BORDER_STYLE_WAVY;
            }
            case 21: {
                return BORDER_STYLE_DOUBLE_WAVY;
            }
            case 22: {
                return BORDER_STYLE_STRIPED;
            }
            case 23: {
                return BORDER_STYLE_EMBOSS;
            }
            case 24: {
                return BORDER_STYLE_ENGRAVE;
            }
        }
        return BORDER_STYLE_SINGLE;
    }
}

