/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.table;

import com.lowagie2.text.BadElementException;
import com.lowagie2.text.Cell;
import com.lowagie2.text.Paragraph;
import com.lowagie2.text.Table;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.style.RtfParagraphStyle;
import com.lowagie2.text.rtf.table.RtfCell;
import com.lowagie2.text.rtf.table.RtfRow;
import com.lowagie2.text.rtf.table.RtfTable;
import com.lowagie2.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfEmbedTableCell
extends RtfCell {
    private Table table;

    protected RtfEmbedTableCell(RtfDocument doc, RtfRow row, Cell cell) {
        super(doc, row, cell);
        if (cell instanceof RtfEmbedTableCell) {
            this.table = ((RtfEmbedTableCell)cell).table;
        }
    }

    public RtfEmbedTableCell(Table table) throws BadElementException {
        super(new Paragraph("Embed Table"));
        this.table = table;
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            RtfTable t = new RtfTable(this.document, this.table);
            t.setEmbedAlignment(this.horizontalAlignment);
            result.write(10);
            result.write(t.writeEmbed());
            result.write(10);
            result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
            if (this.parentRow.getParentTable().getTableFitToPage()) {
                result.write(RtfParagraphStyle.KEEP_TOGETHER_WITH_NEXT);
            }
            result.write(RtfParagraph.IN_TABLE);
            result.write("\\cell".getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

