/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.text;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Element;
import com.lowagie2.text.Paragraph;
import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.graphic.RtfImage;
import com.lowagie2.text.rtf.style.RtfFont;
import com.lowagie2.text.rtf.style.RtfParagraphStyle;
import com.lowagie2.text.rtf.text.RtfPhrase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfParagraph
extends RtfPhrase {
    public static final byte[] PARAGRAPH = "\\par".getBytes();
    private RtfParagraphStyle paragraphStyle = null;

    public RtfParagraph(RtfDocument doc, Paragraph paragraph) {
        super(doc);
        RtfFont baseFont = null;
        if (paragraph.font() instanceof RtfParagraphStyle) {
            this.paragraphStyle = this.document.getDocumentHeader().getRtfParagraphStyle(((RtfParagraphStyle)paragraph.font()).getStyleName());
            baseFont = this.paragraphStyle;
        } else {
            baseFont = new RtfFont(this.document, paragraph.font());
            this.paragraphStyle = new RtfParagraphStyle(this.document, this.document.getDocumentHeader().getRtfParagraphStyle("Normal"));
            this.paragraphStyle.setAlignment(paragraph.alignment());
            this.paragraphStyle.setIndentLeft((int)((double)paragraph.indentationLeft() * 20.0));
            this.paragraphStyle.setIndentRight((int)((double)paragraph.indentationRight() * 20.0));
            this.paragraphStyle.setSpacingBefore((int)((double)paragraph.spacingBefore() * 20.0));
            this.paragraphStyle.setSpacingAfter((int)((double)paragraph.spacingAfter() * 20.0));
            if (paragraph.leadingDefined()) {
                this.paragraphStyle.setLineLeading((int)((double)paragraph.leading() * 20.0));
            }
            this.paragraphStyle.setKeepTogether(paragraph.getKeepTogether());
        }
        int i = 0;
        while (i < paragraph.size()) {
            Element chunk = (Element)paragraph.get(i);
            if (chunk instanceof Chunk) {
                ((Chunk)chunk).setFont(baseFont.difference(((Chunk)chunk).font()));
            } else if (chunk instanceof RtfImage) {
                ((RtfImage)this.chunks.get(i)).setAlignment(this.paragraphStyle.getAlignment());
            }
            try {
                this.chunks.add(doc.getMapper().mapElement(chunk));
            }
            catch (DocumentException de) {
            }
            ++i;
        }
    }

    public int getIndentLeft() {
        return this.paragraphStyle.getIndentLeft();
    }

    public int getIndentRight() {
        return this.paragraphStyle.getIndentRight();
    }

    public void setIndentLeft(int indentLeft) {
        this.paragraphStyle.setIndentLeft(indentLeft);
    }

    public void setIndentRight(int indentRight) {
        this.paragraphStyle.setIndentRight(indentRight);
    }

    public void setKeepTogetherWithNext(boolean keepTogetherWithNext) {
        this.paragraphStyle.setKeepTogetherWithNext(keepTogetherWithNext);
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(RtfPhrase.PARAGRAPH_DEFAULTS);
            if (this.inTable) {
                result.write(RtfPhrase.IN_TABLE);
            }
            if (this.paragraphStyle != null) {
                result.write(this.paragraphStyle.writeBegin());
            }
            int i = 0;
            while (i < this.chunks.size()) {
                result.write(((RtfBasicElement)this.chunks.get(i)).write());
                ++i;
            }
            if (this.paragraphStyle != null) {
                result.write(this.paragraphStyle.writeEnd());
            }
            if (!this.inTable) {
                result.write(PARAGRAPH);
            }
            if (this.document.getDocumentSettings().isOutputDebugLineBreaks()) {
                result.write(10);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeEbmed() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (this.paragraphStyle != null) {
                result.write(this.paragraphStyle.writeBegin());
            }
            int i = 0;
            while (i < this.chunks.size()) {
                result.write(((RtfBasicElement)this.chunks.get(i)).write());
                ++i;
            }
            if (this.paragraphStyle != null) {
                result.write(this.paragraphStyle.writeEnd());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

