/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.rtf.text;

import com.lowagie2.text.Chunk;
import com.lowagie2.text.DocumentException;
import com.lowagie2.text.Element;
import com.lowagie2.text.Section;
import com.lowagie2.text.rtf.RtfBasicElement;
import com.lowagie2.text.rtf.RtfElement;
import com.lowagie2.text.rtf.document.RtfDocument;
import com.lowagie2.text.rtf.field.RtfTOCEntry;
import com.lowagie2.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfSection
extends RtfElement {
    protected ArrayList items = new ArrayList();
    protected RtfParagraph title = null;

    public RtfSection(RtfDocument doc, Section section) {
        super(doc);
        try {
            if (section.title() != null) {
                this.title = (RtfParagraph)doc.getMapper().mapElement(section.title());
            }
            if (this.document.getAutogenerateTOCEntries()) {
                StringBuffer titleText = new StringBuffer();
                Iterator it = section.title().iterator();
                while (it.hasNext()) {
                    Element element = (Element)it.next();
                    if (element.type() != 10) continue;
                    titleText.append(((Chunk)element).content());
                }
                if (titleText.toString().trim().length() > 0) {
                    RtfTOCEntry tocEntry = new RtfTOCEntry(titleText.toString());
                    tocEntry.setRtfDocument(this.document);
                    this.items.add(tocEntry);
                }
            }
            Iterator iterator = section.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                RtfBasicElement rtfElement = doc.getMapper().mapElement(element);
                if (rtfElement == null) continue;
                this.items.add(rtfElement);
            }
            this.updateIndentation(section.indentationLeft(), section.indentationRight(), section.indentation());
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
    }

    public void setInHeader(boolean inHeader) {
        super.setInHeader(inHeader);
        int i = 0;
        while (i < this.items.size()) {
            ((RtfBasicElement)this.items.get(i)).setInHeader(inHeader);
            ++i;
        }
    }

    public void setInTable(boolean inTable) {
        super.setInTable(inTable);
        int i = 0;
        while (i < this.items.size()) {
            ((RtfBasicElement)this.items.get(i)).setInTable(inTable);
            ++i;
        }
    }

    private void updateIndentation(float indentLeft, float indentRight, float indentContent) {
        if (this.title != null) {
            this.title.setIndentLeft((int)((double)this.title.getIndentLeft() + (double)indentLeft * 20.0));
            this.title.setIndentRight((int)((double)this.title.getIndentRight() + (double)indentRight * 20.0));
        }
        int i = 0;
        while (i < this.items.size()) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.items.get(i);
            if (rtfElement instanceof RtfSection) {
                ((RtfSection)rtfElement).updateIndentation(indentLeft + indentContent, indentRight, 0.0f);
            } else if (rtfElement instanceof RtfParagraph) {
                ((RtfParagraph)rtfElement).setIndentLeft((int)((double)((RtfParagraph)rtfElement).getIndentLeft() + (double)(indentLeft + indentContent) * 20.0));
                ((RtfParagraph)rtfElement).setIndentRight((int)((double)((RtfParagraph)rtfElement).getIndentRight() + (double)indentRight * 20.0));
            }
            ++i;
        }
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(RtfParagraph.PARAGRAPH);
            if (this.title != null) {
                result.write(this.title.write());
            }
            int i = 0;
            while (i < this.items.size()) {
                result.write(((RtfBasicElement)this.items.get(i)).write());
                ++i;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

