/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.text.xml;

import com.lowagie2.text.ExceptionConverter;
import com.lowagie2.text.xml.XmlPeer;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class TagMap
extends HashMap {
    static /* synthetic */ Class class$com$lowagie2$text$xml$TagMap;

    public TagMap(InputStream in) {
        this.init(in);
    }

    public TagMap(String tagfile) {
        try {
            this.init((class$com$lowagie2$text$xml$TagMap == null ? (class$com$lowagie2$text$xml$TagMap = TagMap.class$("com.lowagie2.text.xml.TagMap")) : class$com$lowagie2$text$xml$TagMap).getClassLoader().getResourceAsStream(tagfile));
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected void init(InputStream in) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(new InputSource(in), (DefaultHandler)new AttributeHandler(this));
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    class AttributeHandler
    extends DefaultHandler {
        public static final String ALIAS = "alias";
        public static final String ATTRIBUTE = "attribute";
        public static final String CONTENT = "content";
        public static final String NAME = "name";
        public static final String TAG = "tag";
        public static final String VALUE = "value";
        private XmlPeer currentPeer;
        private HashMap tagMap;

        public AttributeHandler(HashMap tagMap) {
            this.tagMap = tagMap;
        }

        public void characters(char[] ch, int start, int length) {
        }

        public void endElement(String uri, String lname, String tag) {
            if (TAG.equals(tag)) {
                this.tagMap.put(this.currentPeer.getAlias(), this.currentPeer);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        public void startElement(String uri, String lname, String tag, Attributes attrs) {
            String name = attrs.getValue(NAME);
            String alias = attrs.getValue(ALIAS);
            String value = attrs.getValue(VALUE);
            if (name != null) {
                if (TAG.equals(tag)) {
                    this.currentPeer = new XmlPeer(name, alias);
                } else if (ATTRIBUTE.equals(tag)) {
                    if (alias != null) {
                        this.currentPeer.addAlias(name, alias);
                    }
                    if (value != null) {
                        this.currentPeer.addValue(name, value);
                    }
                }
            }
            if ((value = attrs.getValue(CONTENT)) != null) {
                this.currentPeer.setContent(value);
            }
        }
    }
}

