/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie2.tools.plugins.treeview;

import com.lowagie2.text.Rectangle;
import com.lowagie2.text.pdf.PRStream;
import com.lowagie2.text.pdf.PdfArray;
import com.lowagie2.text.pdf.PdfDictionary;
import com.lowagie2.text.pdf.PdfName;
import com.lowagie2.text.pdf.PdfNumber;
import com.lowagie2.text.pdf.PdfObject;
import com.lowagie2.text.pdf.PdfReader;
import com.lowagie2.tools.plugins.treeview.ICommonAnalyzer;
import com.lowagie2.tools.plugins.treeview.IUpdatenodeview;
import com.lowagie2.tools.plugins.treeview.SimpletextTreeNode;
import com.lowagie2.tools.plugins.treeview.TextpaneTreeNode;
import com.lowagie2.tools.plugins.treeview.UpdateableTreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class Pagetreenode
extends UpdateableTreeNode {
    static /* synthetic */ Class class$com$lowagie2$tools$plugins$treeview$TreeViewInternalFrame;
    private PdfDictionary dictionary;
    private float height;
    private int pagenumber;
    private static final long serialVersionUID = -3463874220927052895L;
    private float width;

    public Pagetreenode(PdfDictionary page, int seitennummer, ICommonAnalyzer pageanalyzer, PdfReader pdfreader) {
        PdfObject contents;
        PdfObject reso;
        PdfNumber rotation;
        SimpletextTreeNode info;
        this.dictionary = page;
        this.pagenumber = seitennummer;
        PdfArray arr = (PdfArray)page.get(PdfName.MEDIABOX);
        float curwidth = 0.0f;
        float curheight = 0.0f;
        if (arr != null) {
            ArrayList arl = arr.getArrayList();
            curwidth = Float.parseFloat(arl.get(2).toString());
            curheight = Float.parseFloat(arl.get(3).toString());
            info = new SimpletextTreeNode(PdfName.MEDIABOX + " " + curwidth + "*" + curheight);
            this.add(info);
        }
        PdfArray arrcrop = (PdfArray)page.get(PdfName.CROPBOX);
        float curwidthcrop = 0.0f;
        float curheightcrop = 0.0f;
        if (arrcrop != null) {
            ArrayList arl = arrcrop.getArrayList();
            curwidthcrop = Float.parseFloat(arl.get(2).toString());
            curheightcrop = Float.parseFloat(arl.get(3).toString());
            info = new SimpletextTreeNode(PdfName.CROPBOX + " " + curwidthcrop + "*" + curheightcrop);
            this.add(info);
        }
        if ((rotation = (PdfNumber)PdfReader.getPdfObject(page.get(PdfName.ROTATE))) == null) {
            System.out.println("Rotation missing");
            rotation = new PdfNumber(0);
        } else {
            info = new SimpletextTreeNode(PdfName.ROTATE + " " + rotation);
            this.add(info);
        }
        Rectangle rect = new Rectangle(curwidthcrop, curheightcrop);
        if (rotation.floatValue() == 90.0f || rotation.floatValue() == 270.0f) {
            rect = rect.rotate();
        }
        this.width = rect.width();
        this.height = rect.height();
        PdfArray dict = (PdfArray)PdfReader.getPdfObject(page.get(PdfName.ANNOTS));
        if (dict != null) {
            this.add(new SimpletextTreeNode(PdfName.ANNOTS + " " + dict.length()));
            SimpletextTreeNode sttn = new SimpletextTreeNode(PdfName.ANNOTS + " " + dict.type());
            this.add(sttn);
            pageanalyzer.iterateObjects(dict, pdfreader, sttn);
        }
        if ((reso = PdfReader.getPdfObject(page.get(PdfName.RESOURCES))) != null) {
            SimpletextTreeNode sttn = new SimpletextTreeNode(PdfName.RESOURCES + " " + reso.type());
            this.add(sttn);
            pageanalyzer.iterateObjects(reso, pdfreader, sttn);
        }
        if ((contents = PdfReader.getPdfObject(page.get(PdfName.CONTENTS))) != null) {
            this.add(new TextpaneTreeNode(contents, "Content"));
            if (contents.isStream()) {
                PRStream prstr = (PRStream)contents;
                Set s = prstr.getKeys();
                Iterator it = s.iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    System.out.println("Field:" + obj);
                    PdfObject value = PdfReader.getPdfObject(prstr.get((PdfName)obj));
                    System.out.println("Value:" + value);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public float getHeight() {
        return this.height;
    }

    public Icon getIcon() {
        return new ImageIcon((class$com$lowagie2$tools$plugins$treeview$TreeViewInternalFrame == null ? (class$com$lowagie2$tools$plugins$treeview$TreeViewInternalFrame = Pagetreenode.class$("com.lowagie2.tools.plugins.treeview.TreeViewInternalFrame")) : class$com$lowagie2$tools$plugins$treeview$TreeViewInternalFrame).getResource("pageonly.gif"));
    }

    public int getPagenumber() {
        return this.pagenumber;
    }

    public float getWidth() {
        return this.width;
    }

    public String toString() {
        return "Page " + this.pagenumber;
    }

    public void updateview(IUpdatenodeview updateobject) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<p>");
        sb.append("Page " + this.getPagenumber());
        sb.append("</p>");
        sb.append("<p>");
        sb.append("Size: " + this.getWidth() + "*" + this.getHeight());
        sb.append("</p>");
        Set set = this.dictionary.getKeys();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            sb.append("<p>");
            sb.append("Key " + it.next().toString());
            sb.append("</p>");
        }
        sb.append("</html>");
        updateobject.showvalues(sb.toString());
    }
}

