/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.page;

import com.itextpdf.html2pdf.attach.impl.layout.RunningElementContainer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class CssRunningManager {
    private Map<String, LinkedHashSet<RunningElementContainer>> runningElements = new HashMap<String, LinkedHashSet<RunningElementContainer>>();

    public void addRunningElement(String runningElemName, RunningElementContainer container) {
        LinkedHashSet<RunningElementContainer> runningElems = this.runningElements.get(runningElemName);
        if (runningElems == null) {
            runningElems = new LinkedHashSet();
            this.runningElements.put(runningElemName, runningElems);
        }
        runningElems.add(container);
    }

    public RunningElementContainer getRunningElement(String runningElemName, String occurrenceOption, int pageNum) {
        LinkedHashSet<RunningElementContainer> runningElementContainers = this.runningElements.get(runningElemName);
        if (runningElementContainers == null || runningElementContainers.isEmpty()) {
            return null;
        }
        boolean isLast = "last".equals(occurrenceOption);
        boolean isFirstExcept = "first-except".equals(occurrenceOption);
        boolean isStart = "start".equals(occurrenceOption);
        RunningElementContainer runningElementContainer = null;
        for (RunningElementContainer container : runningElementContainers) {
            if (container.getOccurrencePage() == 0 || container.getOccurrencePage() > pageNum) continue;
            if (container.getOccurrencePage() < pageNum) {
                runningElementContainer = container;
            }
            if (container.getOccurrencePage() != pageNum) continue;
            if (isFirstExcept) {
                return null;
            }
            if (!isStart || container.isFirstOnPage()) {
                runningElementContainer = container;
            }
            if (isLast) continue;
            break;
        }
        return runningElementContainer;
    }
}

