/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.CFFFontSubset;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectObject;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.TrueTypeFontSubSet;
import com.itextpdf.text.pdf.TrueTypeFontUnicode;
import com.itextpdf.text.pdf.TtfUnicodeWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class PdfATtfUnicodeWriter
extends TtfUnicodeWriter {
    protected final PdfAConformanceLevel pdfAConformanceLevel;

    public PdfATtfUnicodeWriter(PdfWriter writer, PdfAConformanceLevel pdfAConformanceLevel) {
        super(writer);
        this.pdfAConformanceLevel = pdfAConformanceLevel;
    }

    public void writeFont(TrueTypeFontUnicode font, PdfIndirectReference ref, Object[] params, byte[] rotbits) throws DocumentException, IOException {
        byte[] b;
        HashMap longTag = (HashMap)params[0];
        font.addRangeUni(longTag, true, font.subset);
        int[][] metrics = (int[][])longTag.values().toArray((T[])new int[0][]);
        Arrays.sort(metrics, font);
        PdfIndirectReference ind_font = null;
        BaseFont.StreamFont pobj = null;
        PdfIndirectObject obj = null;
        PdfIndirectReference cidset = null;
        if (this.pdfAConformanceLevel == PdfAConformanceLevel.PDF_A_1A || this.pdfAConformanceLevel == PdfAConformanceLevel.PDF_A_1B) {
            PdfStream stream;
            if (metrics.length == 0) {
                stream = new PdfStream(new byte[]{-128});
            } else {
                int top = metrics[metrics.length - 1][0];
                byte[] bt = new byte[top / 8 + 1];
                for (int k = 0; k < metrics.length; ++k) {
                    int v = metrics[k][0];
                    int n = v / 8;
                    bt[n] = (byte)(bt[n] | rotbits[v % 8]);
                }
                stream = new PdfStream(bt);
                stream.flateCompress(font.compressionLevel);
            }
            cidset = this.writer.addToBody((PdfObject)stream).getIndirectReference();
        }
        if (font.cff) {
            b = font.readCffFont();
            if (font.subset || font.subsetRanges != null) {
                CFFFontSubset cff = new CFFFontSubset(new RandomAccessFileOrArray(b), longTag);
                b = cff.Process(cff.getNames()[0]);
            }
            pobj = new BaseFont.StreamFont(b, "CIDFontType0C", font.compressionLevel);
            obj = this.writer.addToBody((PdfObject)pobj);
            ind_font = obj.getIndirectReference();
        } else {
            if (font.subset || font.directoryOffset != 0) {
                TrueTypeFontSubSet sb = new TrueTypeFontSubSet(font.fileName, new RandomAccessFileOrArray(font.rf), new HashSet(longTag.keySet()), font.directoryOffset, false, false);
                b = sb.process();
            } else {
                b = font.getFullFont();
            }
            int[] lengths = new int[]{b.length};
            pobj = new BaseFont.StreamFont(b, lengths, font.compressionLevel);
            obj = this.writer.addToBody((PdfObject)pobj);
            ind_font = obj.getIndirectReference();
        }
        String subsetPrefix = "";
        if (font.subset) {
            subsetPrefix = BaseFont.createSubsetPrefix();
        }
        PdfDictionary dic = font.getFontDescriptor(ind_font, subsetPrefix, cidset);
        obj = this.writer.addToBody((PdfObject)dic);
        ind_font = obj.getIndirectReference();
        pobj = font.getCIDFontType2(ind_font, subsetPrefix, (Object[])metrics);
        obj = this.writer.addToBody((PdfObject)pobj);
        ind_font = obj.getIndirectReference();
        pobj = font.getToUnicode((Object[])metrics);
        PdfIndirectReference toUnicodeRef = null;
        if (pobj != null) {
            obj = this.writer.addToBody((PdfObject)pobj);
            toUnicodeRef = obj.getIndirectReference();
        }
        pobj = font.getFontBaseType(ind_font, subsetPrefix, toUnicodeRef);
        this.writer.addToBody((PdfObject)pobj, ref);
    }
}

