/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.log.Counter;
import com.itextpdf.text.log.CounterFactory;
import com.itextpdf.text.pdf.BadPdfFormatException;
import com.itextpdf.text.pdf.ICC_Profile;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfAConformanceException;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfATtfUnicodeWriter;
import com.itextpdf.text.pdf.PdfAWriter;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfIndirectObject;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.TtfUnicodeWriter;
import com.itextpdf.text.pdf.interfaces.PdfAConformance;
import com.itextpdf.text.pdf.interfaces.PdfIsoConformance;
import com.itextpdf.text.pdf.internal.PdfAChecker;
import com.itextpdf.text.pdf.internal.PdfAConformanceImp;
import com.itextpdf.text.xml.xmp.PdfAXmpWriter;
import com.itextpdf.text.xml.xmp.XmpWriter;
import com.itextpdf.xmp.XMPMeta;
import com.itextpdf.xmp.impl.XMPMetaParser;
import com.itextpdf.xmp.properties.XMPProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfACopy
extends PdfCopy {
    protected Counter COUNTER = CounterFactory.getCounter(PdfACopy.class);

    public PdfACopy(Document document, OutputStream os, PdfAConformanceLevel conformanceLevel) throws DocumentException {
        super(document, os);
        ((PdfAConformance)this.pdfIsoConformance).setConformanceLevel(conformanceLevel);
        PdfAWriter.setPdfVersion((PdfWriter)this, conformanceLevel);
    }

    protected Counter getCounter() {
        return this.COUNTER;
    }

    protected PdfIsoConformance initPdfIsoConformance() {
        return new PdfAConformanceImp((PdfWriter)this);
    }

    protected void cacheObject(PdfIndirectObject iobj) {
        super.cacheObject(iobj);
        this.getPdfAChecker().cacheObject(iobj.getIndirectReference(), iobj.object);
    }

    private PdfAChecker getPdfAChecker() {
        return ((PdfAConformanceImp)this.pdfIsoConformance).getPdfAChecker();
    }

    public void addDocument(PdfReader reader) throws DocumentException, IOException {
        this.checkPdfAInfo(reader);
        super.addDocument(reader);
    }

    public void addPage(PdfImportedPage iPage) throws IOException, BadPdfFormatException {
        this.checkPdfAInfo(iPage.readerInstance.getReader());
        super.addPage(iPage);
    }

    public PdfCopy.PageStamp createPageStamp(PdfImportedPage iPage) {
        this.checkPdfAInfo(iPage.readerInstance.getReader());
        return super.createPageStamp(iPage);
    }

    public void setOutputIntents(String outputConditionIdentifier, String outputCondition, String registryName, String info, ICC_Profile colorProfile) throws IOException {
        PdfDictionary d;
        super.setOutputIntents(outputConditionIdentifier, outputCondition, registryName, info, colorProfile);
        PdfArray a = this.extraCatalog.getAsArray(PdfName.OUTPUTINTENTS);
        if (a != null && (d = a.getAsDict(0)) != null) {
            d.put(PdfName.S, (PdfObject)PdfName.GTS_PDFA1);
        }
    }

    public boolean setOutputIntents(PdfReader reader, boolean checkExistence) throws IOException {
        PdfDictionary catalog = reader.catalog;
        PdfArray outs = catalog.getAsArray(PdfName.OUTPUTINTENTS);
        if (outs == null) {
            return false;
        }
        if (outs.size() == 0) {
            return false;
        }
        PdfDictionary outa = outs.getAsDict(0);
        PdfObject obj = PdfReader.getPdfObject((PdfObject)outa.get(PdfName.S));
        if (obj == null || !PdfName.GTS_PDFA1.equals((Object)obj)) {
            return false;
        }
        if (checkExistence) {
            return true;
        }
        PRStream stream = (PRStream)PdfReader.getPdfObject((PdfObject)outa.get(PdfName.DESTOUTPUTPROFILE));
        byte[] destProfile = null;
        if (stream != null) {
            destProfile = PdfReader.getStreamBytes((PRStream)stream);
        }
        this.setOutputIntents(PdfACopy.getNameString((PdfDictionary)outa, (PdfName)PdfName.OUTPUTCONDITIONIDENTIFIER), PdfACopy.getNameString((PdfDictionary)outa, (PdfName)PdfName.OUTPUTCONDITION), PdfACopy.getNameString((PdfDictionary)outa, (PdfName)PdfName.REGISTRYNAME), PdfACopy.getNameString((PdfDictionary)outa, (PdfName)PdfName.INFO), destProfile);
        return true;
    }

    protected XmpWriter createXmpWriter(ByteArrayOutputStream baos, PdfDictionary info) throws IOException {
        return new PdfAXmpWriter((OutputStream)baos, info, ((PdfAConformance)this.pdfIsoConformance).getConformanceLevel(), (PdfWriter)this);
    }

    protected XmpWriter createXmpWriter(ByteArrayOutputStream baos, HashMap<String, String> info) throws IOException {
        return new PdfAXmpWriter((OutputStream)baos, info, ((PdfAConformance)this.pdfIsoConformance).getConformanceLevel(), (PdfWriter)this);
    }

    protected TtfUnicodeWriter getTtfUnicodeWriter() {
        if (this.ttfUnicodeWriter == null) {
            this.ttfUnicodeWriter = new PdfATtfUnicodeWriter((PdfWriter)this, ((PdfAConformance)this.pdfIsoConformance).getConformanceLevel());
        }
        return this.ttfUnicodeWriter;
    }

    public void close() {
        super.close();
        this.getPdfAChecker().close((PdfWriter)this);
    }

    private void checkPdfAInfo(PdfReader reader) {
        XMPProperty pdfaidPart;
        XMPProperty pdfaidConformance;
        try {
            byte[] metadata = reader.getMetadata();
            XMPMeta xmpMeta = XMPMetaParser.parse((Object)metadata, null);
            pdfaidConformance = xmpMeta.getProperty("http://www.aiim.org/pdfa/ns/id/", "pdfaid:conformance");
            pdfaidPart = xmpMeta.getProperty("http://www.aiim.org/pdfa/ns/id/", "pdfaid:part");
        }
        catch (Throwable e) {
            throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"only.pdfa.documents.can.be.added.in.PdfACopy", (Object[])new Object[0]));
        }
        if (pdfaidConformance == null || pdfaidPart == null) {
            throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"only.pdfa.documents.can.be.added.in.PdfACopy", (Object[])new Object[0]));
        }
        switch (((PdfAConformance)this.pdfIsoConformance).getConformanceLevel()) {
            case PDF_A_1A: 
            case PDF_A_1B: {
                if ("1".equals(pdfaidPart.getValue())) break;
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"different.pdf.a.version", (Object[])new Object[]{"1"}));
            }
            case PDF_A_2A: 
            case PDF_A_2B: 
            case PDF_A_2U: {
                if ("2".equals(pdfaidPart.getValue())) break;
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"different.pdf.a.version", (Object[])new Object[]{"2"}));
            }
            case PDF_A_3A: 
            case PDF_A_3B: 
            case PDF_A_3U: 
            case ZUGFeRD: {
                if ("3".equals(pdfaidPart.getValue())) break;
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"different.pdf.a.version", (Object[])new Object[]{"3"}));
            }
        }
        switch (((PdfAConformance)this.pdfIsoConformance).getConformanceLevel()) {
            case PDF_A_1A: 
            case PDF_A_2A: 
            case PDF_A_3A: {
                if ("A".equals(pdfaidConformance.getValue())) break;
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"incompatible.pdf.a.conformance.level", (Object[])new Object[]{"a"}));
            }
            case PDF_A_2U: 
            case PDF_A_3U: {
                if (!"B".equals(pdfaidConformance.getValue())) break;
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"incompatible.pdf.a.conformance.level", (Object[])new Object[]{"u"}));
            }
        }
    }
}

