/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.annot;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPopupAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PdfMarkupAnnotation
extends PdfAnnotation {
    private static final long serialVersionUID = 239280278775576458L;
    protected PdfAnnotation inReplyTo = null;
    protected PdfPopupAnnotation popup = null;

    protected PdfMarkupAnnotation(Rectangle rect) {
        super(rect);
    }

    protected PdfMarkupAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public PdfString getText() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.T);
    }

    public PdfMarkupAnnotation setText(PdfString text) {
        return (PdfMarkupAnnotation)this.put(PdfName.T, text);
    }

    public PdfNumber getOpacity() {
        return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.CA);
    }

    public PdfMarkupAnnotation setOpacity(PdfNumber ca) {
        return (PdfMarkupAnnotation)this.put(PdfName.CA, ca);
    }

    public PdfObject getRichText() {
        return ((PdfDictionary)this.getPdfObject()).get(PdfName.RC);
    }

    public PdfMarkupAnnotation setRichText(PdfObject richText) {
        return (PdfMarkupAnnotation)this.put(PdfName.RC, richText);
    }

    public PdfString getCreationDate() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.CreationDate);
    }

    public PdfMarkupAnnotation setCreationDate(PdfString creationDate) {
        return (PdfMarkupAnnotation)this.put(PdfName.CreationDate, creationDate);
    }

    public PdfDictionary getInReplyToObject() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.IRT);
    }

    public PdfAnnotation getInReplyTo() {
        if (this.inReplyTo == null) {
            this.inReplyTo = PdfMarkupAnnotation.makeAnnotation(this.getInReplyToObject());
        }
        return this.inReplyTo;
    }

    public PdfMarkupAnnotation setInReplyTo(PdfAnnotation inReplyTo) {
        this.inReplyTo = inReplyTo;
        return (PdfMarkupAnnotation)this.put(PdfName.IRT, (PdfObject)inReplyTo.getPdfObject());
    }

    public PdfMarkupAnnotation setPopup(PdfPopupAnnotation popup) {
        this.popup = popup;
        popup.setParent(this);
        return (PdfMarkupAnnotation)this.put(PdfName.Popup, (PdfObject)popup.getPdfObject());
    }

    public PdfDictionary getPopupObject() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Popup);
    }

    public PdfPopupAnnotation getPopup() {
        PdfDictionary popupObject;
        if (this.popup == null && (popupObject = this.getPopupObject()) != null) {
            PdfAnnotation annotation = PdfMarkupAnnotation.makeAnnotation(popupObject);
            if (!(annotation instanceof PdfPopupAnnotation)) {
                Logger logger = LoggerFactory.getLogger(PdfMarkupAnnotation.class);
                logger.warn("Popup entry in the markup annotations refers not to the annotation with Popup subtype.");
                return null;
            }
            this.popup = (PdfPopupAnnotation)annotation;
        }
        return this.popup;
    }

    public PdfString getSubject() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.Subj);
    }

    public PdfMarkupAnnotation setSubject(PdfString subject) {
        return (PdfMarkupAnnotation)this.put(PdfName.Subj, subject);
    }

    public PdfName getReplyType() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.RT);
    }

    public PdfMarkupAnnotation setReplyType(PdfName replyType) {
        return (PdfMarkupAnnotation)this.put(PdfName.RT, replyType);
    }

    public PdfName getIntent() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.IT);
    }

    public PdfMarkupAnnotation setIntent(PdfName intent) {
        return (PdfMarkupAnnotation)this.put(PdfName.IT, intent);
    }

    public PdfDictionary getExternalData() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.ExData);
    }

    @Deprecated
    public PdfMarkupAnnotation setExternalData(PdfName exData) {
        return (PdfMarkupAnnotation)this.put(PdfName.ExData, exData);
    }

    public PdfMarkupAnnotation setExternalData(PdfDictionary exData) {
        return (PdfMarkupAnnotation)this.put(PdfName.ExData, exData);
    }
}

